/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import java.io.Serializable;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.closure.AbstractClosure;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.NamedClosure;
import org.operamasks.el.eval.closure.ThisObject;
import org.operamasks.el.parser.ELNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultClosureObject
extends AbstractClosure
implements ClosureObject,
Serializable {
    protected ThisObject thisObj;
    private static final long serialVersionUID = 2293668654108141430L;

    DefaultClosureObject(ThisObject thisObj) {
        this.thisObj = thisObj;
    }

    @Override
    public ClassDefinition get_class() {
        return this.thisObj.get_class();
    }

    @Override
    public ClosureObject get_this() {
        return this.thisObj;
    }

    @Override
    public ClosureObject get_owner() {
        return this;
    }

    @Override
    public Object get_proxy() {
        return this.thisObj.get_proxy();
    }

    @Override
    public Closure get_closure(ELContext elctx, String name) {
        return this.thisObj.getPublicClosure(elctx, name);
    }

    @Override
    public Map<String, Closure> get_closures(ELContext elctx) {
        return this.thisObj.get_closures(elctx);
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        Closure operator;
        Object result;
        if (property instanceof String) {
            String key = (String)property;
            result = this.thisObj.invokePublic(elctx, "get" + ELUtils.capitalize(key), ELUtils.NO_PARAMS);
            if (result != ELUtils.NO_RESULT) {
                elctx.setPropertyResolved(true);
                return this.checkResult(result);
            }
            Closure member = this.get_closure(elctx, key);
            if (member != null) {
                result = member.getValue(elctx);
                elctx.setPropertyResolved(true);
                return this.checkResult(result);
            }
        }
        if ((operator = this.get_closure(elctx, "[]")) != null) {
            result = operator.call(elctx, property);
            elctx.setPropertyResolved(true);
            return this.checkResult(result);
        }
        return null;
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        Closure operator;
        if (property instanceof String) {
            String key = (String)property;
            Object result = this.thisObj.invokePublic(elctx, "set" + ELUtils.capitalize(key), new Closure[]{new LiteralClosure(value)});
            if (result != ELUtils.NO_RESULT) {
                elctx.setPropertyResolved(true);
                return;
            }
            Closure member = this.get_closure(elctx, key);
            if (member != null) {
                try {
                    member.setValue(elctx, value);
                    elctx.setPropertyResolved(true);
                    return;
                }
                catch (PropertyNotWritableException ex) {
                    // empty catch block
                }
            }
        }
        if ((operator = this.get_closure(elctx, "[]=")) != null) {
            operator.call(elctx, property, value);
            elctx.setPropertyResolved(true);
            return;
        }
    }

    @Override
    public Object invoke(ELContext elctx, String name, Closure[] args) {
        Object result = this.thisObj.invokePublic(elctx, name, args);
        if (result != ELUtils.NO_RESULT) {
            return this.checkResult(result);
        }
        Closure proc = this.get_closure(elctx, "invoke");
        if (proc != null) {
            if (proc.arity(elctx) == 3) {
                String[] keys = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof NamedClosure)) continue;
                    NamedClosure c = (NamedClosure)args[i];
                    keys[i] = c.name();
                    args[i] = c.getDelegate();
                }
                ELNode.VarArgList vlist = new ELNode.VarArgList(elctx, args, 0);
                return this.checkResult(proc.call(elctx, name, keys, vlist));
            }
            ELNode.VarArgList vlist = new ELNode.VarArgList(elctx, args, 0);
            return this.checkResult(proc.call(elctx, name, vlist));
        }
        return ELUtils.NO_RESULT;
    }

    @Override
    public Object invokeSpecial(ELContext elctx, String name, Closure[] args) {
        return this.checkResult(this.thisObj.invokePublic(elctx, name, args));
    }

    @Override
    public Object invoke(ELContext elctx, Closure[] args) {
        Object result = this.thisObj.invokePublic(elctx, "__call__", args);
        if (result != ELUtils.NO_RESULT) {
            return this.checkResult(result);
        }
        throw new MethodNotFoundException();
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        return this.thisObj.getType(elctx, property);
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        return this.thisObj.isReadOnly(elctx, property);
    }

    public String toString() {
        return this.thisObj.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.thisObj.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.thisObj.hashCode();
    }

    private Object checkResult(Object result) {
        return result == this.thisObj ? this : result;
    }
}

