/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Annotation;
import java.io.Serializable;
import java.util.Arrays;

public final class MetaData
implements Serializable {
    private Annotation[] annotations;
    private int modifiers;
    private static final long serialVersionUID = -1656409680539962167L;

    public MetaData(Annotation[] annotations, int modifiers) {
        this.annotations = annotations;
        this.modifiers = modifiers;
    }

    public boolean isAnnotationPresent(String type) {
        for (Annotation a : this.annotations) {
            if (!type.equals(a.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    public Annotation getAnnotation(String type) {
        for (Annotation a : this.annotations) {
            if (!type.equals(a.getAnnotationType())) continue;
            return a;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return (Annotation[])this.annotations.clone();
    }

    public void addAnnotation(Annotation annotation) {
        Annotation[] t = new Annotation[this.annotations.length + 1];
        System.arraycopy(this.annotations, 0, t, 0, this.annotations.length);
        t[this.annotations.length] = annotation;
        this.annotations = t;
    }

    public void removeAnnotation(String type) {
        int len = this.annotations.length;
        int i = 0;
        while (i < len) {
            if (type.equals(this.annotations[i].getAnnotationType())) {
                System.arraycopy(this.annotations, i + 1, this.annotations, i, len - i - 1);
                --len;
                continue;
            }
            --i;
        }
        if (len != this.annotations.length) {
            Annotation[] t = new Annotation[len];
            System.arraycopy(this.annotations, 0, t, 0, len);
            this.annotations = t;
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 6) == 0;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MetaData) {
            MetaData other = (MetaData)obj;
            return Arrays.equals(this.annotations, other.annotations) && this.modifiers == other.modifiers;
        }
        return false;
    }

    public int hashCode() {
        int h = this.modifiers;
        for (Annotation a : this.annotations) {
            h = 31 * h + a.hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < this.annotations.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.annotations[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

