/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import javax.el.ELContext;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.MethodDelegate;
import org.operamasks.el.eval.MethodResolvable;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.AbstractClosure;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.EvalClosure;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Procedure
extends EvalClosure {
    public Procedure(EvaluationContext context, ELNode node) {
        super(context, node);
    }

    @Override
    public Object getValue(ELContext elctx) {
        return this;
    }

    @Override
    public void setValue(ELContext elctx, Object value) {
        throw new PropertyNotWritableException();
    }

    @Override
    public boolean isReadOnly(ELContext elctx) {
        return true;
    }

    @Override
    public Class<?> getType(ELContext elctx) {
        return Procedure.class;
    }

    @Override
    public boolean isProcedure() {
        return true;
    }

    public Object call_with(ELContext elctx, Object scope, Closure ... args) {
        if (scope instanceof ClosureObject) {
            scope = ((ClosureObject)scope).get_owner();
        }
        EvaluationContext env = this.getContext(elctx);
        env = env.pushContext(new EnvExtent(env, scope));
        return this.node.invoke(env, args);
    }

    private static class ScopedClosure
    extends AbstractClosure {
        final EvaluationContext env;
        final Object scope;
        final String name;

        ScopedClosure(EvaluationContext env, Object scope, String name) {
            this.env = env;
            this.scope = scope;
            this.name = name;
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            ValueExpression expr;
            MethodClosure method;
            Object result;
            MethodResolver resolver = MethodResolver.getInstance(elctx);
            if (this.scope instanceof ClosureObject) {
                result = ((ClosureObject)this.scope).invokeSpecial(elctx, this.name, args);
                if (result != ELUtils.NO_RESULT) {
                    return result;
                }
            } else if (!(this.scope instanceof MethodDelegate) && (method = resolver.resolveMethod(this.scope.getClass(), this.name)) != null) {
                return method.invoke(elctx, this.scope, args);
            }
            if ((expr = this.env.resolveVariable(this.name)) != null) {
                ValueExpression target = expr instanceof Closure ? expr : expr.getValue(elctx);
                return ELEngine.invokeTarget(elctx, target, args);
            }
            method = resolver.resolveGlobalMethod(this.name);
            if (method != null) {
                return method.invoke(elctx, args);
            }
            elctx.setPropertyResolved(false);
            Object target = elctx.getELResolver().getValue(elctx, null, (Object)this.name);
            if (target != null && elctx.isPropertyResolved()) {
                return ELEngine.invokeTarget(elctx, target, args);
            }
            if (this.scope instanceof ClosureObject) {
                result = ((ClosureObject)this.scope).invoke(elctx, this.name, args);
                if (result != ELUtils.NO_RESULT) {
                    return result;
                }
            } else if (this.scope instanceof MethodResolvable) {
                return ((MethodResolvable)this.scope).invoke(elctx, this.name, args);
            }
            throw new EvaluationException(elctx, Resources._T("EL_UNDEFINED_IDENTIFIER", this.name));
        }

        public Object getValue(ELContext elctx) {
            ValueExpression expr;
            Object result;
            MethodResolver resolver = MethodResolver.getInstance(elctx);
            if (this.scope instanceof ClosureObject) {
                elctx.setPropertyResolved(false);
                result = ((ClosureObject)this.scope).getValue(elctx, this.name);
                if (elctx.isPropertyResolved()) {
                    return result;
                }
            } else {
                try {
                    elctx.setPropertyResolved(false);
                    result = elctx.getELResolver().getValue(elctx, this.scope, (Object)this.name);
                    if (elctx.isPropertyResolved()) {
                        return result;
                    }
                }
                catch (PropertyNotFoundException ex) {
                    // empty catch block
                }
            }
            if ((expr = this.env.resolveVariable(this.name)) != null) {
                elctx.setPropertyResolved(true);
                return expr.getValue(elctx);
            }
            if (!(this.scope instanceof ClosureObject) && (result = resolver.resolveMethod(this.scope.getClass(), this.name)) != null) {
                elctx.setPropertyResolved(true);
                return result;
            }
            result = resolver.resolveGlobalMethod(this.name);
            if (result != null) {
                elctx.setPropertyResolved(true);
                return result;
            }
            elctx.setPropertyResolved(false);
            result = elctx.getELResolver().getValue(elctx, null, (Object)this.name);
            if (elctx.isPropertyResolved()) {
                return result;
            }
            throw new EvaluationException(elctx, Resources._T("EL_UNDEFINED_IDENTIFIER", this.name));
        }

        public void setValue(ELContext elctx, Object value) {
            ValueExpression expr;
            if (this.scope instanceof ClosureObject) {
                elctx.setPropertyResolved(false);
                ((ClosureObject)this.scope).setValue(elctx, this.name, value);
                if (elctx.isPropertyResolved()) {
                    return;
                }
            } else {
                elctx.setPropertyResolved(false);
                elctx.getELResolver().setValue(elctx, this.scope, (Object)this.name, value);
                if (elctx.isPropertyResolved()) {
                    return;
                }
            }
            if ((expr = this.env.resolveVariable(this.name)) != null) {
                elctx.setPropertyResolved(true);
                expr.setValue(elctx, value);
                return;
            }
            elctx.setPropertyResolved(false);
            elctx.getELResolver().setValue(elctx, null, (Object)this.name, value);
            if (elctx.isPropertyResolved()) {
                return;
            }
            throw new EvaluationException(elctx, Resources._T("EL_UNDEFINED_IDENTIFIER", this.name));
        }
    }

    private static class EnvExtent
    extends VariableMapperImpl {
        final EvaluationContext env;
        final Object scope;

        EnvExtent(EvaluationContext env, Object scope) {
            this.env = env;
            this.scope = scope;
        }

        public ValueExpression resolveVariable(String name) {
            ValueExpression value = super.resolveVariable(name);
            if (value != null) {
                return value;
            }
            if ("this".equals(name)) {
                LiteralClosure thisObj = new LiteralClosure(this.scope);
                super.setVariable("this", thisObj);
                return thisObj;
            }
            ScopedClosure wrapper = new ScopedClosure(this.env, this.scope, name);
            super.setVariable(name, wrapper);
            return wrapper;
        }
    }
}

