/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.seq;

import elite.lang.Seq;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.operamasks.el.eval.seq.AbstractSeq;
import org.operamasks.el.eval.seq.Cons;
import org.operamasks.el.eval.seq.RandomAccessListSeq;

public class ListSeq
extends AbstractSeq {
    private final List list;
    private final int offset;
    private Seq tail;

    protected ListSeq(List list, int offset) {
        this.list = list;
        this.offset = offset;
    }

    public static Seq make(List list) {
        return ListSeq.make(list, 0);
    }

    public static Seq make(List list, int offset) {
        if (offset < list.size()) {
            if (list instanceof RandomAccess) {
                return new RandomAccessListSeq(list, offset);
            }
            return new ListSeq(list, offset);
        }
        return Cons.nil();
    }

    public Object get() {
        return this.list.get(this.offset);
    }

    public Object set(Object x) {
        return this.list.set(this.offset, x);
    }

    public Object remove() {
        return this.list.remove(this.offset);
    }

    public Seq tail() {
        if (this.tail == null) {
            this.tail = ListSeq.make(this.list, this.offset + 1);
        }
        return this.tail;
    }

    public Seq last() {
        if (this.offset + 1 >= this.list.size()) {
            return this;
        }
        return ListSeq.make(this.list, this.list.size() - 1);
    }

    public int size() {
        return this.list.size() - this.offset;
    }

    public boolean isEmpty() {
        return this.offset >= this.list.size();
    }

    public Object get(int index) {
        this.rangeCheck(index);
        return this.list.get(this.offset + index);
    }

    public Object set(int index, Object x) {
        this.rangeCheck(index);
        return this.list.set(this.offset + index, x);
    }

    public boolean add(Object x) {
        return this.list.add(x);
    }

    public void add(int index, Object x) {
        this.rangeCheck(index);
        this.list.add(this.offset + index, x);
    }

    public Object remove(int index) {
        this.rangeCheck(index);
        return this.list.remove(this.offset + index);
    }

    public boolean addAll(Collection c) {
        return this.list.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.rangeCheck(index);
        return this.list.addAll(this.offset + index, c);
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(int index) {
        this.rangeCheck(index);
        final ListIterator i = this.list.listIterator(this.offset + index);
        return new ListIterator(){

            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return i.next();
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return i.previous();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return i.nextIndex() - ListSeq.this.offset;
            }

            public int previousIndex() {
                return i.previousIndex() - ListSeq.this.offset;
            }

            public void remove() {
                i.remove();
            }

            public void set(Object o) {
                i.set(o);
            }

            public void add(Object o) {
                i.add(o);
            }
        };
    }

    private void rangeCheck(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index:" + index);
        }
    }
}

