/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import org.operamasks.el.parser.ELNode;

public class DefaultVisitor
extends ELNode.Visitor {
    public void scan(ELNode e) {
        if (e != null) {
            e.accept(this);
        }
    }

    public void scan(ELNode[] args) {
        if (args != null) {
            for (ELNode e : args) {
                this.scan(e);
            }
        }
    }

    public void visit(ELNode.Composite e) {
        this.scan(e.elems);
    }

    public void visit(ELNode.LAMBDA e) {
        this.scan(e.vars);
        this.scan(e.body);
    }

    public void visit(ELNode.DEFINE e) {
        this.scan(e.meta);
        this.scan(e.expr);
    }

    public void visit(ELNode.CLASSDEF e) {
        this.scan(e.vars);
        this.scan(e.cvars);
        this.scan(e.ivars);
    }

    public void visit(ELNode.UNDEF e) {
    }

    public void visit(ELNode.IDENT e) {
    }

    public void visit(ELNode.ACCESS e) {
        this.scan(e.right);
        this.scan(e.index);
    }

    public void visit(ELNode.APPLY e) {
        this.scan(e.right);
        this.scan(e.args);
    }

    public void visit(ELNode.COND e) {
        this.scan(e.cond);
        this.scan(e.left);
        this.scan(e.right);
    }

    public void visitUnary(ELNode.Unary e) {
        this.scan(e.right);
    }

    public void visitBinary(ELNode.Binary e) {
        this.scan(e.left);
        this.scan(e.right);
    }

    public void visit(ELNode.XFORM e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.PREFIX e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.INFIX e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.ASSIGN e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.COALESCE e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.SAFEREF e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.OR e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.AND e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.BITOR e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.BITAND e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.XOR e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.SHL e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.SHR e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.USHR e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.EQ e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.NE e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.IDEQ e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.IDNE e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.LT e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.LE e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.GT e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.GE e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.INSTANCEOF e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.IN e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.ADD e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.SUB e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.MUL e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.DIV e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.REM e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.POW e) {
        this.visitBinary(e);
    }

    public void visit(ELNode.BITNOT e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.POS e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.NEG e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.INC e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.DEC e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.NOT e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.EMPTY e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.EXPR e) {
        this.visitUnary(e);
    }

    public void visit(ELNode.COMPOUND e) {
        this.scan(e.exps);
    }

    public void visit(ELNode.WHILE e) {
        this.scan(e.cond);
        this.scan(e.body);
    }

    public void visit(ELNode.FOR e) {
        this.scan(e.init);
        this.scan(e.cond);
        this.scan(e.step);
        this.scan(e.body);
    }

    public void visit(ELNode.FOREACH e) {
        this.scan(e.index);
        this.scan(e.var);
        this.scan(e.range);
        this.scan(e.body);
    }

    public void visit(ELNode.SWITCH e) {
        this.scan(e.arg);
        this.scan(e.cases);
        this.scan(e.exps);
    }

    public void visit(ELNode.CASE e) {
        this.scan(e.exp);
    }

    public void visit(ELNode.WITH e) {
        this.scan(e.args);
        this.scan(e.alts);
        this.scan(e.deflt);
    }

    public void visit(ELNode.MATCHCASE e) {
        if (e.patterns != null) {
            for (ELNode.Pattern p : e.patterns) {
                this.scan((ELNode)((Object)p));
            }
        }
        this.scan(e.guard);
        this.scan(e.body);
    }

    public void visit(ELNode.LET e) {
        this.scan(e.left);
        this.scan(e.right);
    }

    public void visit(ELNode.BREAK e) {
    }

    public void visit(ELNode.CONTINUE e) {
    }

    public void visit(ELNode.RETURN e) {
        this.scan(e.right);
    }

    public void visit(ELNode.THROW e) {
        this.scan(e.cause);
    }

    public void visit(ELNode.TRY e) {
        this.scan(e.body);
        this.scan(e.handlers);
        this.scan(e.finalizer);
    }

    public void visit(ELNode.CATCH e) {
        this.scan(e.body);
    }

    public void visit(ELNode.SYNCHRONIZED e) {
        this.scan(e.exp);
        this.scan(e.body);
    }

    public void visit(ELNode.ASSERT e) {
        this.scan(e.exp);
        this.scan(e.msg);
    }

    public void visitConstant(ELNode.Constant e) {
    }

    public void visit(ELNode.BOOLEANVAL e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.CHARVAL e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.NUMBER e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.SYMBOL e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.STRINGVAL e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.REGEXP e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.LITERAL e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.NULL e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.CLASS e) {
        this.visitConstant(e);
    }

    public void visit(ELNode.ARRAY e) {
        this.scan(e.dims);
        this.scan(e.init);
    }

    public void visit(ELNode.LIST e) {
        this.scan(e.elems);
        this.scan(e.tail);
    }

    public void visit(ELNode.TUPLE e) {
        this.scan(e.elems);
    }

    public void visit(ELNode.MAP e) {
        this.scan(e.keys);
        this.scan(e.values);
    }

    public void visit(ELNode.RANGE e) {
        this.scan(e.begin);
        this.scan(e.next);
        this.scan(e.end);
    }

    public void visit(ELNode.XML e) {
        this.scan(e.tag);
        this.scan(e.keys);
        this.scan(e.values);
        this.scan(e.children);
    }

    public void visit(ELNode.NEW e) {
        this.scan(e.args);
        this.scan(e.props);
    }

    public void visit(ELNode.NEWOBJ e) {
        this.scan(e.vars);
        this.scan(e.cvars);
        this.scan(e.ivars);
    }

    public void visit(ELNode.METADATA e) {
        this.scan(e.values);
    }

    public void visit(ELNode.METASET e) {
        this.scan(e.metadata);
    }

    public void visitNode(ELNode e) {
        assert (false);
    }
}

