/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import elite.lang.Annotation;
import elite.lang.Closure;
import elite.lang.Decimal;
import elite.lang.Range;
import elite.lang.Rational;
import elite.lang.Seq;
import elite.lang.Symbol;
import elite.lang.annotation.Constructor;
import elite.xml.XmlNode;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.CharRanges;
import org.operamasks.el.eval.Control;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.Frame;
import org.operamasks.el.eval.GlobalScope;
import org.operamasks.el.eval.MethodDelegate;
import org.operamasks.el.eval.MethodResolvable;
import org.operamasks.el.eval.Ranges;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.SystemScope;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.UserException;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.AbstractClosure;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.DelayClosure;
import org.operamasks.el.eval.closure.EvalClosure;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.MetaData;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.eval.closure.NamedClosure;
import org.operamasks.el.eval.closure.Procedure;
import org.operamasks.el.eval.closure.TargetMethodClosure;
import org.operamasks.el.eval.closure.ThisObject;
import org.operamasks.el.eval.closure.TypedClosure;
import org.operamasks.el.eval.closure.VarClosure;
import org.operamasks.el.eval.seq.Cons;
import org.operamasks.el.eval.seq.DelayCons;
import org.operamasks.el.eval.seq.IteratorSeq;
import org.operamasks.el.parser.DefaultVisitor;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.el.resources.Resources;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ELNode
implements Serializable {
    public final int op;
    public final int pos;
    public static final int ASSIGN_PREC = 0;
    public static final int ASSIGNOP_PREC = 1;
    public static final int COND_PREC = 2;
    public static final int COALESCE_PREC = 3;
    public static final int OR_PREC = 4;
    public static final int AND_PREC = 5;
    public static final int BITOR_PREC = 6;
    public static final int XOR_PREC = 7;
    public static final int BITAND_PREC = 8;
    public static final int EQ_PREC = 9;
    public static final int ORD_PREC = 10;
    public static final int SHIFT_PREC = 11;
    public static final int ADD_PREC = 12;
    public static final int MUL_PREC = 13;
    public static final int PREFIX_PREC = 14;
    public static final int XFORM_PREC = 15;
    public static final int POW_PREC = 16;
    public static final int POSTFIX_PREC = 17;
    public static final int DEFAULT_PREC = 17;
    public static final int NO_PREC = 100;
    public static final String[] opIdentifiers = new String[113];
    private static final AtomicReference<Closure[]> op_args;
    private static final AtomicReference<Closure[]> op_args2;
    private static final long LONG_SIG_BIT = Long.MIN_VALUE;

    ELNode(int op, int pos) {
        this.op = op;
        this.pos = pos;
    }

    public final int op() {
        return this.op;
    }

    public final int pos() {
        return this.pos;
    }

    final ELNode pos(Frame f) {
        if (f != null) {
            f.setPos(this.pos);
        }
        return this;
    }

    public int precedence() {
        return 100;
    }

    ELNode order() {
        return this;
    }

    public abstract Object getValue(EvaluationContext var1);

    public abstract Class getType(EvaluationContext var1);

    public boolean isReadOnly(EvaluationContext context) {
        return true;
    }

    public void setValue(EvaluationContext context, Object value) {
        throw this.propertyNotWritable(context.getELContext(), null, null);
    }

    boolean getBoolean(EvaluationContext context) {
        Object value = this.getValue(context);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            return TypeCoercion.coerceToBoolean(value);
        }
        catch (ELException ex) {
            throw this.runtimeError(context.getELContext(), ex);
        }
    }

    public MethodInfo getMethodInfo(EvaluationContext context) {
        return ELEngine.getTargetMethodInfo(context.getELContext(), this.getValue(context));
    }

    public Object invokeMethod(EvaluationContext context, Object[] args) {
        return this.invoke(context, ELEngine.getCallArgs(args));
    }

    public Object invoke(EvaluationContext context, Closure[] args) {
        ELContext elctx = context.getELContext();
        Object target = this.getValue(context);
        try {
            return ELEngine.invokeTarget(elctx, target, args);
        }
        catch (MethodNotFoundException ex) {
            throw this.methodNotFound(elctx, target, null, ex);
        }
        catch (RuntimeException ex) {
            throw this.runtimeError(elctx, ex);
        }
    }

    Object resolveTarget(EvaluationContext context, String id) {
        ELContext elctx = context.getELContext();
        ValueExpression expr = context.resolveVariable(id);
        if (expr != null) {
            return expr instanceof Closure ? expr : expr.getValue(elctx);
        }
        MethodClosure method = MethodResolver.getInstance(elctx).resolveGlobalMethod(context.getFunctionMapper(), id);
        if (method != null) {
            return method;
        }
        elctx.setPropertyResolved(false);
        return elctx.getELResolver().getValue(elctx, null, (Object)id);
    }

    boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
        call.result = args == null ? this.getValue(context) : this.invoke(context, args);
        return false;
    }

    Closure closure(EvaluationContext context) {
        return new DelayClosure(context, this);
    }

    public final void applyFunctionMapper(final FunctionMapper fnm) {
        DefaultVisitor v = new DefaultVisitor(){

            public void visit(APPLY apply) {
                String id;
                int i;
                if (apply.right instanceof IDENT && (i = (id = ((IDENT)apply.right).id).indexOf(58)) != -1) {
                    fnm.resolveFunction(id.substring(0, i), id.substring(i + 1));
                }
            }
        };
        this.accept(v);
    }

    public final void applyVariableMapper(final VariableMapper vm) {
        DefaultVisitor v = new DefaultVisitor(){

            public void visit(IDENT node) {
                vm.resolveVariable(node.id);
            }

            public void visit(NEW node) {
                vm.resolveVariable(node.base);
            }
        };
        this.accept(v);
    }

    public abstract void accept(Visitor var1);

    ELException runtimeError(ELContext elctx, String message) {
        return new EvaluationException(elctx, message);
    }

    ELException runtimeError(ELContext elctx, Throwable cause) {
        if (cause instanceof EvaluationException) {
            throw (EvaluationException)((Object)cause);
        }
        if (cause instanceof Control) {
            throw (Control)cause;
        }
        if (cause instanceof ELException) {
            throw new EvaluationException(elctx, cause.getMessage(), cause.getCause());
        }
        throw new EvaluationException(elctx, cause);
    }

    ELException runtimeError(ELContext elctx, String message, Throwable cause) {
        return new EvaluationException(elctx, message, cause);
    }

    ELException propertyNotFound(ELContext elctx, Object base, Object property) {
        String message;
        if (base != null && property == null) {
            message = base instanceof String ? Resources._T("EL_UNDEFINED_IDENTIFIER", base) : Resources._T("EL_PROPERTY_NOT_FOUND", base, property);
        } else {
            if (base instanceof ClosureObject) {
                base = ((ClosureObject)base).get_class().getName();
            } else if (base instanceof Closure) {
                base = base.toString();
            } else if (base != null) {
                base = base.getClass().getName();
            }
            message = Resources._T("EL_PROPERTY_NOT_FOUND", base, property);
        }
        throw new EvaluationException(elctx, message);
    }

    ELException propertyNotWritable(ELContext elctx, Object base, Object property) {
        String message;
        if (base != null && property == null) {
            message = base instanceof String ? Resources._T("EL_VARIABLE_NOT_WRITABLE", base) : Resources._T("EL_READONLY_EXPRESSION");
        } else {
            if (base instanceof ClosureObject) {
                base = ((ClosureObject)base).get_class().getName();
            } else if (base instanceof Closure) {
                base = base.toString();
            } else if (base != null) {
                base = base.getClass().getName();
            }
            message = Resources._T("EL_PROPERTY_NOT_WRITABLE", base, property);
        }
        throw new EvaluationException(elctx, message);
    }

    ELException methodNotFound(ELContext elctx, Object base, Object property, MethodNotFoundException cause) {
        String msg;
        String string = msg = cause == null ? null : cause.getMessage();
        if (msg == null) {
            if (base instanceof ClosureObject) {
                base = ((ClosureObject)base).get_class().getName();
            } else if (base instanceof Closure) {
                base = base.toString();
            } else if (base != null) {
                base = base.getClass().getName();
            }
            msg = Resources._T("EL_METHOD_NOT_FOUND", base, property);
        }
        throw new EvaluationException(elctx, msg, cause);
    }

    static Closure[] getArgs(Object arg) {
        Closure[] args = op_args.getAndSet(null);
        if (args == null) {
            args = new Closure[]{new LiteralClosure(arg)};
        }
        return args;
    }

    static Closure[] getArgs(Object arg1, Object arg2) {
        Closure[] args = op_args2.getAndSet(null);
        if (args == null) {
            args = new Closure[]{new LiteralClosure(arg1), new LiteralClosure(arg2)};
        }
        return args;
    }

    static void releaseArgs(Closure[] args) {
        (args.length == 1 ? op_args : op_args2).set(args);
    }

    static boolean isWildcard(ELNode pattern) {
        if (pattern instanceof DEFINE) {
            DEFINE var = (DEFINE)pattern;
            return "_".equals(var.id) && var.type == null && var.expr == null;
        }
        return false;
    }

    static {
        ELNode.opIdentifiers[35] = "__pos__";
        ELNode.opIdentifiers[36] = "__neg__";
        ELNode.opIdentifiers[33] = "!";
        ELNode.opIdentifiers[34] = "~";
        ELNode.opIdentifiers[37] = "++";
        ELNode.opIdentifiers[38] = "--";
        ELNode.opIdentifiers[10] = "|";
        ELNode.opIdentifiers[12] = "&";
        ELNode.opIdentifiers[11] = "__xor__";
        ELNode.opIdentifiers[21] = "<<";
        ELNode.opIdentifiers[22] = ">>";
        ELNode.opIdentifiers[23] = ">>>";
        ELNode.opIdentifiers[24] = "+";
        ELNode.opIdentifiers[25] = "-";
        ELNode.opIdentifiers[26] = "*";
        ELNode.opIdentifiers[27] = "/";
        ELNode.opIdentifiers[29] = "%";
        ELNode.opIdentifiers[30] = "^";
        ELNode.opIdentifiers[13] = "==";
        ELNode.opIdentifiers[14] = "!=";
        ELNode.opIdentifiers[17] = "<";
        ELNode.opIdentifiers[19] = "<=";
        ELNode.opIdentifiers[18] = ">";
        ELNode.opIdentifiers[20] = ">=";
        op_args = new AtomicReference();
        op_args2 = new AtomicReference();
    }

    public static abstract class Visitor {
        public void visit(Composite e) {
            this.visitNode(e);
        }

        public void visit(LAMBDA e) {
            this.visitNode(e);
        }

        public void visit(DEFINE e) {
            this.visitNode(e);
        }

        public void visit(CLASSDEF e) {
            this.visitNode(e);
        }

        public void visit(UNDEF e) {
            this.visitNode(e);
        }

        public void visit(IDENT e) {
            this.visitNode(e);
        }

        public void visit(ACCESS e) {
            this.visitNode(e);
        }

        public void visit(APPLY e) {
            this.visitNode(e);
        }

        public void visit(XFORM e) {
            this.visitNode(e);
        }

        public void visit(PREFIX e) {
            this.visitNode(e);
        }

        public void visit(INFIX e) {
            this.visitNode(e);
        }

        public void visit(ASSIGN e) {
            this.visitNode(e);
        }

        public void visit(COND e) {
            this.visitNode(e);
        }

        public void visit(COALESCE e) {
            this.visitNode(e);
        }

        public void visit(SAFEREF e) {
            this.visitNode(e);
        }

        public void visit(OR e) {
            this.visitNode(e);
        }

        public void visit(AND e) {
            this.visitNode(e);
        }

        public void visit(BITOR e) {
            this.visitNode(e);
        }

        public void visit(BITAND e) {
            this.visitNode(e);
        }

        public void visit(XOR e) {
            this.visitNode(e);
        }

        public void visit(SHL e) {
            this.visitNode(e);
        }

        public void visit(SHR e) {
            this.visitNode(e);
        }

        public void visit(USHR e) {
            this.visitNode(e);
        }

        public void visit(EQ e) {
            this.visitNode(e);
        }

        public void visit(NE e) {
            this.visitNode(e);
        }

        public void visit(IDEQ e) {
            this.visitNode(e);
        }

        public void visit(IDNE e) {
            this.visitNode(e);
        }

        public void visit(LT e) {
            this.visitNode(e);
        }

        public void visit(LE e) {
            this.visitNode(e);
        }

        public void visit(GT e) {
            this.visitNode(e);
        }

        public void visit(GE e) {
            this.visitNode(e);
        }

        public void visit(INSTANCEOF e) {
            this.visitNode(e);
        }

        public void visit(IN e) {
            this.visitNode(e);
        }

        public void visit(ADD e) {
            this.visitNode(e);
        }

        public void visit(SUB e) {
            this.visitNode(e);
        }

        public void visit(MUL e) {
            this.visitNode(e);
        }

        public void visit(DIV e) {
            this.visitNode(e);
        }

        public void visit(REM e) {
            this.visitNode(e);
        }

        public void visit(POW e) {
            this.visitNode(e);
        }

        public void visit(BITNOT e) {
            this.visitNode(e);
        }

        public void visit(POS e) {
            this.visitNode(e);
        }

        public void visit(NEG e) {
            this.visitNode(e);
        }

        public void visit(INC e) {
            this.visitNode(e);
        }

        public void visit(DEC e) {
            this.visitNode(e);
        }

        public void visit(NOT e) {
            this.visitNode(e);
        }

        public void visit(EMPTY e) {
            this.visitNode(e);
        }

        public void visit(EXPR e) {
            this.visitNode(e);
        }

        public void visit(COMPOUND e) {
            this.visitNode(e);
        }

        public void visit(WHILE e) {
            this.visitNode(e);
        }

        public void visit(FOR e) {
            this.visitNode(e);
        }

        public void visit(FOREACH e) {
            this.visitNode(e);
        }

        public void visit(SWITCH e) {
            this.visitNode(e);
        }

        public void visit(CASE e) {
            this.visitNode(e);
        }

        public void visit(WITH e) {
            this.visitNode(e);
        }

        public void visit(MATCHCASE e) {
            this.visitNode(e);
        }

        public void visit(LET e) {
            this.visitNode(e);
        }

        public void visit(BREAK e) {
            this.visitNode(e);
        }

        public void visit(CONTINUE e) {
            this.visitNode(e);
        }

        public void visit(RETURN e) {
            this.visitNode(e);
        }

        public void visit(THROW e) {
            this.visitNode(e);
        }

        public void visit(TRY e) {
            this.visitNode(e);
        }

        public void visit(CATCH e) {
            this.visitNode(e);
        }

        public void visit(SYNCHRONIZED e) {
            this.visitNode(e);
        }

        public void visit(ASSERT e) {
            this.visitNode(e);
        }

        public void visit(BOOLEANVAL e) {
            this.visitNode(e);
        }

        public void visit(CHARVAL e) {
            this.visitNode(e);
        }

        public void visit(NUMBER e) {
            this.visitNode(e);
        }

        public void visit(SYMBOL e) {
            this.visitNode(e);
        }

        public void visit(STRINGVAL e) {
            this.visitNode(e);
        }

        public void visit(REGEXP e) {
            this.visitNode(e);
        }

        public void visit(LITERAL e) {
            this.visitNode(e);
        }

        public void visit(NULL e) {
            this.visitNode(e);
        }

        public void visit(CLASS e) {
            this.visitNode(e);
        }

        public void visit(ARRAY e) {
            this.visitNode(e);
        }

        public void visit(LIST e) {
            this.visitNode(e);
        }

        public void visit(TUPLE e) {
            this.visitNode(e);
        }

        public void visit(MAP e) {
            this.visitNode(e);
        }

        public void visit(RANGE e) {
            this.visitNode(e);
        }

        public void visit(XML e) {
            this.visitNode(e);
        }

        public void visit(NEW e) {
            this.visitNode(e);
        }

        public void visit(NEWOBJ e) {
            this.visitNode(e);
        }

        public void visit(METADATA e) {
            this.visitNode(e);
        }

        public void visit(METASET e) {
            this.visitNode(e);
        }

        public void visitNode(ELNode e) {
            assert (false);
        }
    }

    public static class METASET
    extends ELNode {
        public final METADATA[] metadata;
        public final int modifiers;

        public METASET(int pos, int modifiers) {
            super(62, pos);
            this.metadata = new METADATA[0];
            this.modifiers = modifiers;
        }

        public METASET(int pos, METADATA[] metadata, int modifiers) {
            super(62, pos);
            this.metadata = metadata;
            this.modifiers = modifiers;
        }

        public METASET combine(METASET that) {
            METADATA[] data = new METADATA[this.metadata.length + that.metadata.length];
            System.arraycopy(this.metadata, 0, data, 0, this.metadata.length);
            System.arraycopy(that.metadata, 0, data, this.metadata.length, that.metadata.length);
            return new METASET(this.pos, data, this.modifiers | that.modifiers);
        }

        public Object getValue(EvaluationContext context) {
            assert (false);
            return null;
        }

        public Class getType(EvaluationContext context) {
            assert (false);
            return null;
        }

        public MetaData getMetaData(EvaluationContext context) {
            Annotation[] annotations = new Annotation[this.metadata.length];
            for (int i = 0; i < this.metadata.length; ++i) {
                annotations[i] = (Annotation)this.metadata[i].getValue(context);
            }
            return new MetaData(annotations, this.modifiers);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class METADATA
    extends ELNode {
        public final String type;
        public final String[] keys;
        public final ELNode[] values;

        public METADATA(int pos, String type, String[] keys, ELNode[] values) {
            super(61, pos);
            this.type = type;
            this.keys = keys;
            this.values = values;
        }

        public Object getValue(EvaluationContext context) {
            assert (this.keys.length == this.values.length);
            Annotation a = new Annotation(this.type);
            for (int i = 0; i < this.keys.length; ++i) {
                a.setAttribute(this.keys[i], this.values[i].getValue(context));
            }
            return a;
        }

        public Class getType(EvaluationContext context) {
            return Annotation.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class NEWOBJ
    extends CLASSDEF {
        public NEWOBJ(int pos, String file, String base, String tag, DEFINE[] body) {
            super(pos, file, tag, base, null, null, body);
        }

        public NEWOBJ(int pos, String file, String base, String tag, DEFINE[] cvars, DEFINE[] ivars) {
            super(pos, file, tag, base, null, null, cvars, ivars);
        }

        public Object getValue(EvaluationContext context) {
            ClassDefinition cdef = new ClassDefinition(context, this);
            return cdef._new(context.getELContext(), new Closure[0]);
        }

        public Class getType(EvaluationContext context) {
            Object cls = ELEngine.resolveClass(context, this.base);
            if (cls instanceof Class) {
                return (Class)cls;
            }
            return Object.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NEW
    extends ELNode
    implements Pattern {
        public final String base;
        public final ELNode[] args;
        public final String[] keys;
        public final MAP props;

        public NEW(int pos, String base, ELNode[] args, String[] keys, MAP props) {
            super(45, pos);
            this.base = base;
            this.args = args;
            this.keys = keys;
            this.props = props;
        }

        @Override
        public Object getValue(EvaluationContext context) {
            Object obj;
            block4: {
                ELContext elctx = context.getELContext();
                Object cls = ELEngine.resolveClass(context, this.base);
                Closure[] argv = this.getCallArgs(context);
                obj = cls instanceof ClassDefinition ? ((ClassDefinition)cls)._new(elctx, argv) : ELEngine.newInstance(elctx, (Class)cls, argv);
                if (obj == null || this.props == null) break block4;
                if (obj instanceof ClosureObject) {
                    ClosureObject clo = (ClosureObject)obj;
                    for (int i = 0; i < this.props.keys.length; ++i) {
                        Object key = this.props.keys[i].getValue(context);
                        Object value = this.props.values[i].getValue(context);
                        clo.setValue(elctx, key, value);
                    }
                } else {
                    ELResolver resolver = elctx.getELResolver();
                    for (int i = 0; i < this.props.keys.length; ++i) {
                        Object key = this.props.keys[i].getValue(context);
                        Object value = this.props.values[i].getValue(context);
                        resolver.setValue(elctx, obj, key, value);
                    }
                }
            }
            return obj;
        }

        private Closure[] getCallArgs(EvaluationContext context) {
            int i;
            if (this.args.length == 0) {
                return ELUtils.NO_PARAMS;
            }
            Closure[] extra = new Closure[this.args.length];
            for (i = 0; i < extra.length; ++i) {
                extra[i] = this.args[i].closure(context);
            }
            if (this.keys != null) {
                for (i = 0; i < extra.length; ++i) {
                    if (this.keys[i] == null) continue;
                    extra[i] = new NamedClosure(this.keys[i], extra[i]);
                }
            }
            return extra;
        }

        @Override
        public Class getType(EvaluationContext context) {
            Object cls = ELEngine.resolveClass(context, this.base);
            if (cls instanceof Class) {
                return (Class)cls;
            }
            return ClosureObject.class;
        }

        @Override
        public boolean matches(EvaluationContext context, Object value) {
            Object cls = ELEngine.resolveClass(context, this.base);
            if (cls instanceof ClassDefinition) {
                return ((ClassDefinition)cls).matches(context, value, this.args, this.keys);
            }
            return this.matches(context, (Class)cls, value);
        }

        private boolean matches(EvaluationContext context, Class<?> cls, Object obj) {
            String[] vars;
            ELContext elctx = context.getELContext();
            int argc = this.args.length;
            if (!cls.isInstance(obj)) {
                return false;
            }
            if (argc == 0) {
                return true;
            }
            if (this.keys != null) {
                vars = this.keys;
            } else {
                Constructor c = cls.getAnnotation(Constructor.class);
                String[] stringArray = vars = c == null ? null : c.value();
                if (vars == null || vars.length != argc) {
                    return false;
                }
            }
            try {
                ELResolver resolver = elctx.getELResolver();
                for (int i = 0; i < argc; ++i) {
                    if (NEW.isWildcard(this.args[i])) continue;
                    elctx.setPropertyResolved(false);
                    Object value = resolver.getValue(elctx, obj, (Object)vars[i]);
                    if (!elctx.isPropertyResolved()) {
                        return false;
                    }
                    if (((Pattern)((Object)this.args[i])).matches(context, value)) continue;
                    return false;
                }
            }
            catch (PropertyNotFoundException ex) {
                return false;
            }
            return true;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class XML
    extends ELNode {
        public final ELNode tag;
        public final ELNode[] keys;
        public final ELNode[] values;
        public final ELNode[] children;

        public XML(int pos, ELNode tag, ELNode[] keys, ELNode[] values, ELNode[] children) {
            super(59, pos);
            this.tag = tag;
            this.keys = keys;
            this.values = values;
            this.children = children;
        }

        public Object getValue(EvaluationContext context) {
            ELContext elctx = context.getELContext();
            Document doc = XmlNode.getContextDocument(elctx);
            EvaluationContext env = context.pushContext();
            try {
                int i;
                int colon;
                String name;
                String[] att_names = null;
                String[] att_values = null;
                if (this.keys != null && this.values != null) {
                    int i2;
                    att_names = new String[this.keys.length];
                    att_values = new String[this.values.length];
                    for (i2 = 0; i2 < this.keys.length; ++i2) {
                        att_names[i2] = TypeCoercion.coerceToString(this.keys[i2].getValue(context));
                        att_values[i2] = TypeCoercion.coerceToString(this.values[i2].getValue(context));
                    }
                    for (i2 = 0; i2 < att_names.length; ++i2) {
                        name = att_names[i2];
                        if (name.equals("xmlns")) {
                            env.declarePrefix("", att_values[i2]);
                            continue;
                        }
                        if (!name.startsWith("xmlns:")) continue;
                        env.declarePrefix(name.substring(6), att_values[i2]);
                    }
                }
                String prefix = (colon = (name = TypeCoercion.coerceToString(this.tag.getValue(env))).indexOf(58)) == -1 ? "" : name.substring(0, colon);
                String uri = env.getURI(prefix);
                Element elem = uri == null ? doc.createElement(name) : doc.createElementNS(uri, name);
                if (att_names != null) {
                    for (i = 0; i < att_names.length; ++i) {
                        String key = att_names[i];
                        String value = att_values[i];
                        if (key.equals("xmlns") || key.startsWith("xmlns:")) {
                            prefix = "xmlns";
                            uri = "http://www.w3.org/2000/xmlns/";
                        } else {
                            colon = key.indexOf(58);
                            prefix = colon == -1 ? "" : key.substring(0, colon);
                            uri = env.getURI(prefix);
                        }
                        if (uri == null) {
                            elem.setAttribute(key, value);
                            continue;
                        }
                        elem.setAttributeNS(uri, key, value);
                    }
                }
                if (this.children != null) {
                    for (i = 0; i < this.children.length; ++i) {
                        Object value = this.children[i].getValue(env);
                        Node node = XmlNode.coerceToNode(elctx, value);
                        if (node == null) continue;
                        elem.appendChild(node);
                    }
                }
                return XmlNode.valueOf(elem);
            }
            catch (DOMException ex) {
                throw this.runtimeError(elctx, ex);
            }
        }

        public Class getType(EvaluationContext context) {
            return XmlNode.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class RANGE
    extends ELNode {
        public final ELNode begin;
        public final ELNode next;
        public final ELNode end;
        public final boolean exclude;
        private Object value;

        public RANGE(int pos, ELNode begin, ELNode next, ELNode end, boolean exclude) {
            super(58, pos);
            this.begin = begin;
            this.next = next;
            this.end = end;
            this.exclude = exclude;
            if (this.isNum(begin) && this.isNum(next) && this.isNum(end) || this.isChar(begin) && this.isChar(next) && this.isChar(end)) {
                this.value = this.getValue(null);
            }
        }

        public Object getValue(EvaluationContext context) {
            long l_step;
            Object end;
            if (this.value != null) {
                return this.value;
            }
            Object begin = this.begin.getValue(context);
            Object next = this.next == null ? null : this.next.getValue(context);
            Object object = end = this.end == null ? null : this.end.getValue(context);
            if (this.isChar(begin) && (next == null || this.isChar(next)) && (end == null || this.isChar(end))) {
                int c_step;
                char c_begin = this.getChar(begin);
                int n = c_step = next == null ? 1 : this.getChar(next) - c_begin;
                if (end == null) {
                    return CharRanges.createUnboundedRange(c_begin, c_step);
                }
                char c_end = this.getChar(end);
                if (this.exclude) {
                    c_end = (char)(c_end - c_step);
                }
                return CharRanges.createCharRange(c_begin, c_end, c_step);
            }
            long l_begin = TypeCoercion.coerceToLong(begin);
            long l = l_step = next == null ? 1L : TypeCoercion.coerceToLong(next) - l_begin;
            if (end == null) {
                return Ranges.createUnboundedRange(l_begin, l_step);
            }
            long l_end = TypeCoercion.coerceToLong(end);
            if (this.exclude) {
                l_end -= l_step;
            }
            return Ranges.createRange(l_begin, l_end, l_step);
        }

        private boolean isChar(Object o) {
            if (o instanceof Character) {
                return true;
            }
            if (o instanceof String) {
                return ((String)o).length() == 1;
            }
            return false;
        }

        private boolean isChar(ELNode node) {
            if (node == null) {
                return true;
            }
            if (node instanceof CHARVAL) {
                return true;
            }
            if (node instanceof STRINGVAL) {
                return ((STRINGVAL)node).value.length() == 1;
            }
            return false;
        }

        private char getChar(Object o) {
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            if (o instanceof String) {
                return ((String)o).charAt(0);
            }
            throw new AssertionError();
        }

        private boolean isNum(ELNode node) {
            if (node == null) {
                return true;
            }
            return node instanceof NUMBER;
        }

        public Class getType(EvaluationContext context) {
            return List.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class MAP
    extends ELNode
    implements Pattern {
        public final ELNode[] keys;
        public final ELNode[] values;

        public MAP(int pos, ELNode[] keys, ELNode[] values) {
            super(57, pos);
            assert (keys.length == values.length);
            this.keys = keys;
            this.values = values;
        }

        public Object getValue(EvaluationContext context) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            for (int i = 0; i < this.keys.length; ++i) {
                map.put(this.keys[i].getValue(context), this.values[i].getValue(context));
            }
            return map;
        }

        public Class getType(EvaluationContext context) {
            return Map.class;
        }

        public boolean matches(EvaluationContext context, Object base) {
            ELContext elctx = context.getELContext();
            for (int i = 0; i < this.keys.length; ++i) {
                assert (this.keys[i] instanceof STRINGVAL);
                assert (this.values[i] instanceof Pattern);
                try {
                    String key = (String)this.keys[i].getValue(context);
                    Object value = elctx.getELResolver().getValue(elctx, base, (Object)key);
                    if (((Pattern)((Object)this.values[i])).matches(context, value)) continue;
                    return false;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            return true;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class PATTERN_TUPLE
    extends TUPLE {
        public PATTERN_TUPLE(int pos, ELNode[] elems) {
            super(pos, elems);
        }
    }

    public static class TUPLE
    extends ELNode
    implements Pattern {
        public final ELNode[] elems;

        public TUPLE(int pos, ELNode[] elems) {
            super(56, pos);
            this.elems = elems;
        }

        public Object getValue(EvaluationContext context) {
            ELNode[] elems = this.elems;
            int len = elems.length;
            Object[] tuple = new Object[len];
            for (int i = 0; i < len; ++i) {
                tuple[i] = elems[i].getValue(context);
            }
            return tuple;
        }

        public void setValue(EvaluationContext context, Object value) {
            if (value == null || !value.getClass().isArray()) {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_TUPLE_PATTERN_NOT_MATCH"));
            }
            ELNode[] elems = this.elems;
            int len = Array.getLength(value);
            if (len != elems.length) {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_TUPLE_PATTERN_NOT_MATCH"));
            }
            for (int i = 0; i < len; ++i) {
                elems[i].setValue(context, Array.get(value, i));
            }
        }

        public Object[] copyValue(EvaluationContext context, ELNode[] value) {
            int i;
            ELNode[] elems = this.elems;
            int len = elems.length;
            if (len != value.length) {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_TUPLE_PATTERN_NOT_MATCH"));
            }
            Object[] result = new Object[len];
            for (i = 0; i < len; ++i) {
                result[i] = value[i].getValue(context);
            }
            for (i = 0; i < len; ++i) {
                elems[i].setValue(context, result[i]);
            }
            return result;
        }

        public Class getType(EvaluationContext context) {
            return Object[].class;
        }

        public boolean matches(EvaluationContext context, Object arg) {
            if (arg == null || !arg.getClass().isArray()) {
                return false;
            }
            int len = Array.getLength(arg);
            if (len != this.elems.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (((Pattern)((Object)this.elems[i])).matches(context, Array.get(arg, i))) continue;
                return false;
            }
            return true;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class LIST
    extends ELNode
    implements Pattern {
        public final ELNode[] elems;
        public final ELNode tail;
        public final boolean delay;

        public LIST(int pos, ELNode[] elems, ELNode tail) {
            this(pos, elems, tail, false);
        }

        public LIST(int pos, ELNode[] elems, ELNode tail, boolean delay) {
            super(55, pos);
            this.elems = elems;
            this.tail = tail;
            this.delay = delay;
        }

        public Object getValue(EvaluationContext context) {
            Object tval;
            Seq seq = this.tail == null ? new Cons() : (this.delay ? new DelayCons(this.tail.closure(context)) : ((tval = this.tail.getValue(context)) instanceof Closure ? new DelayCons((Closure)((Object)tval)) : TypeCoercion.coerceToSeq(tval)));
            ELNode[] elems = this.elems;
            int i = elems.length;
            while (--i >= 0) {
                seq = new Cons(elems[i].getValue(context), seq);
            }
            return seq;
        }

        public void setValue(EvaluationContext context, Object value) {
            if (value instanceof Seq) {
                this.copyValueWithSeq(context, (Seq)value);
            } else if (value instanceof Iterable) {
                this.copyValueWithCollection(context, (Iterable)value);
            } else {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_LIST_PATTERN_NOT_MATCH"));
            }
        }

        public Class getType(EvaluationContext context) {
            return List.class;
        }

        protected Seq copyValue(EvaluationContext context, ELNode[] xs) {
            ELNode[] elems = this.elems;
            int len = elems.length;
            assert (this.tail == null);
            if (len != xs.length) {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_LIST_PATTERN_NOT_MATCH"));
            }
            Cons seq = new Cons();
            int i = len;
            while (--i >= 0) {
                seq = new Cons(xs[i].getValue(context), seq);
            }
            Seq t = seq;
            int i2 = 0;
            while (!t.isEmpty()) {
                elems[i2].setValue(context, t.get());
                t = t.tail();
                ++i2;
            }
            return seq;
        }

        private void copyValueWithSeq(EvaluationContext context, Seq xs) {
            int i;
            ELNode[] elems = this.elems;
            int hl = elems.length;
            if (hl == 1 && this.tail != null) {
                if (xs.isEmpty()) {
                    throw this.runtimeError(context.getELContext(), Resources._T("EL_LIST_PATTERN_NOT_MATCH"));
                }
                Object x = xs.get();
                xs = xs.tail();
                elems[0].setValue(context, x);
                this.tail.setValue(context, xs);
                return;
            }
            Object[] h = new Object[hl];
            for (i = 0; i < hl; ++i) {
                if (xs.isEmpty()) {
                    throw this.runtimeError(context.getELContext(), Resources._T("EL_LIST_PATTERN_NOT_MATCH"));
                }
                h[i] = xs.get();
                xs = xs.tail();
            }
            if (this.tail == null && !xs.isEmpty()) {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_LIST_PATTERN_NOT_MATCH"));
            }
            for (i = 0; i < hl; ++i) {
                elems[i].setValue(context, h[i]);
            }
            if (this.tail != null) {
                this.tail.setValue(context, xs);
            }
        }

        private void copyValueWithCollection(EvaluationContext context, Iterable xs) {
            int i;
            ELNode[] elems = this.elems;
            int hl = elems.length;
            Iterator it = xs.iterator();
            Object[] h = new Object[hl];
            for (i = 0; i < hl; ++i) {
                if (!it.hasNext()) {
                    throw this.runtimeError(context.getELContext(), Resources._T("EL_LIST_PATTERN_NOT_MATCH"));
                }
                h[i] = it.next();
            }
            if (this.tail == null && it.hasNext()) {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_LIST_PATTERN_NOT_MATCH"));
            }
            for (i = 0; i < hl; ++i) {
                elems[i].setValue(context, h[i]);
            }
            if (this.tail != null) {
                this.tail.setValue(context, IteratorSeq.make(it));
            }
        }

        public boolean matches(EvaluationContext context, Object arg) {
            if (!(arg instanceof List)) {
                return false;
            }
            ELNode[] elems = this.elems;
            int hl = elems.length;
            Seq xs = TypeCoercion.coerceToSeq(arg);
            for (int i = 0; i < hl; ++i) {
                if (xs.isEmpty()) {
                    return false;
                }
                if (!((Pattern)((Object)elems[i])).matches(context, xs.get())) {
                    return false;
                }
                xs = xs.tail();
            }
            if (this.tail == null) {
                return xs.isEmpty();
            }
            return ((Pattern)((Object)this.tail)).matches(context, xs);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class ARRAY
    extends ELNode {
        public final String type;
        public final ELNode[] dims;
        public final ELNode[] init;

        public ARRAY(int pos, String type, ELNode[] dims, ELNode[] init) {
            super(54, pos);
            this.type = type;
            this.dims = dims;
            this.init = init;
        }

        public Object getValue(EvaluationContext context) {
            if (this.dims == null || this.dims.length == 1) {
                return this.createOneDimensionalArray(context);
            }
            return this.createMultiDimensionalArray(context);
        }

        private Object createOneDimensionalArray(EvaluationContext context) {
            Object result;
            block6: {
                int length = 0;
                if (this.dims != null) {
                    length = TypeCoercion.coerceToInt(this.dims[0].getValue(context));
                }
                if (this.init != null && length < this.init.length) {
                    length = this.init.length;
                }
                Class cls = this.componentType(context);
                result = Array.newInstance(cls, length);
                if (this.init == null) break block6;
                if (result instanceof Object[]) {
                    Object[] a = (Object[])result;
                    for (int i = 0; i < this.init.length; ++i) {
                        a[i] = this.init[i].getValue(context);
                    }
                } else {
                    for (int i = 0; i < this.init.length; ++i) {
                        Object value = this.init[i].getValue(context);
                        Array.set(result, i, TypeCoercion.coerce(value, cls));
                    }
                }
            }
            return result;
        }

        private Object createMultiDimensionalArray(EvaluationContext context) {
            assert (this.dims != null && this.dims.length > 1);
            int[] d = new int[this.dims.length];
            for (int i = 0; i < d.length; ++i) {
                d[i] = TypeCoercion.coerceToInt(this.dims[i].getValue(context));
            }
            Class t = this.componentType(context);
            return Array.newInstance(t, d);
        }

        private Class componentType(EvaluationContext context) {
            if (this.type == null) {
                return Object.class;
            }
            Object cls = ELEngine.resolveClass(context, this.type);
            if (cls instanceof Class) {
                return (Class)cls;
            }
            return Object.class;
        }

        public Class getType(EvaluationContext context) {
            return Object[].class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class CLASS
    extends Constant {
        public final String name;

        public CLASS(int pos, String name) {
            super(53, pos);
            this.name = name;
        }

        public Object getValue(EvaluationContext context) {
            return ELEngine.resolveJavaClass(context.getELContext(), this.name);
        }

        public Class getType(EvaluationContext context) {
            return Class.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class NULL
    extends Constant
    implements Pattern {
        public NULL(int pos) {
            super(72, pos);
        }

        public Object getValue(EvaluationContext context) {
            return null;
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public boolean matches(EvaluationContext context, Object arg) {
            return arg == null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class LITERAL
    extends Constant {
        public final String value;

        public LITERAL(int pos, String value) {
            super(46, pos);
            this.value = value;
        }

        public Object getValue(EvaluationContext context) {
            return this.value;
        }

        public Class getType(EvaluationContext context) {
            return String.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class REGEXP
    extends Constant
    implements Pattern {
        public final java.util.regex.Pattern value;

        public REGEXP(int pos, String value) {
            super(52, pos);
            this.value = java.util.regex.Pattern.compile(value);
        }

        public Object getValue(EvaluationContext context) {
            return this.value;
        }

        public Class getType(EvaluationContext context) {
            return java.util.regex.Pattern.class;
        }

        public boolean matches(EvaluationContext context, Object arg) {
            if (arg instanceof String) {
                return this.value.matcher((String)arg).matches();
            }
            return false;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class STRINGVAL
    extends Constant
    implements Pattern {
        public final String value;

        public STRINGVAL(int pos, String value) {
            super(52, pos);
            this.value = value;
        }

        public Object getValue(EvaluationContext context) {
            return this.value;
        }

        public Class getType(EvaluationContext context) {
            return String.class;
        }

        public boolean matches(EvaluationContext context, Object arg) {
            return this.value.equals(arg);
        }

        public Object invoke(EvaluationContext context, Closure[] args) {
            ELContext elctx = context.getELContext();
            Object target = this.resolveTarget(context, this.value);
            if (target == null) {
                throw this.runtimeError(elctx, Resources._T("EL_UNDEFINED_IDENTIFIER", this.value));
            }
            try {
                return ELEngine.invokeTarget(elctx, target, args);
            }
            catch (MethodNotFoundException ex) {
                throw this.methodNotFound(elctx, target, this.value, ex);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class SYMBOL
    extends Constant
    implements Pattern {
        public final Symbol value;

        public SYMBOL(int pos, Symbol value) {
            super(51, pos);
            this.value = value;
        }

        public Object getValue(EvaluationContext context) {
            return this.value;
        }

        public Class getType(EvaluationContext context) {
            return Symbol.class;
        }

        public boolean matches(EvaluationContext context, Object arg) {
            return this.value == arg;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class NUMBER
    extends Constant
    implements Pattern {
        public final Number value;

        public NUMBER(int pos, Number value) {
            super(50, pos);
            this.value = value;
        }

        public Object getValue(EvaluationContext context) {
            return this.value;
        }

        public Class getType(EvaluationContext context) {
            return this.value.getClass();
        }

        public boolean matches(EvaluationContext context, Object arg) {
            try {
                return EQ.equals(context.getELContext(), this.value, arg);
            }
            catch (Exception ex) {
                return false;
            }
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class CHARVAL
    extends Constant
    implements Pattern {
        public final Character value;

        public CHARVAL(int pos, char value) {
            super(49, pos);
            this.value = Character.valueOf(value);
        }

        public Object getValue(EvaluationContext context) {
            return this.value;
        }

        public Class getType(EvaluationContext context) {
            return Character.class;
        }

        public boolean matches(EvaluationContext context, Object arg) {
            try {
                return this.value.equals(TypeCoercion.coerceToCharacter(arg));
            }
            catch (Exception ex) {
                return false;
            }
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class BOOLEANVAL
    extends Constant
    implements Pattern {
        public final Boolean value;

        public BOOLEANVAL(int pos, boolean value) {
            super(48, pos);
            this.value = value;
        }

        public Object getValue(EvaluationContext context) {
            return this.value;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public boolean matches(EvaluationContext context, Object arg) {
            try {
                return this.value.equals(TypeCoercion.coerceToBoolean(arg));
            }
            catch (Exception ex) {
                return false;
            }
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static abstract class Constant
    extends ELNode {
        public Constant(int op, int pos) {
            super(op, pos);
        }

        Closure closure(EvaluationContext context) {
            return new LiteralClosure(this.getValue(null));
        }
    }

    public static class ASSERT
    extends ELNode {
        public final ELNode exp;
        public final ELNode msg;

        public ASSERT(int pos, ELNode exp, ELNode msg) {
            super(113, pos);
            this.exp = exp;
            this.msg = msg;
        }

        public Object getValue(EvaluationContext context) {
            try {
                if (this.msg == null) {
                    assert (this.exp.getBoolean(context));
                } else assert (this.exp.getBoolean(context)) : this.msg.getValue(context);
                return null;
            }
            catch (AssertionError ex) {
                throw this.runtimeError(context.getELContext(), (Throwable)((Object)ex));
            }
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class SYNCHRONIZED
    extends ELNode {
        public final ELNode exp;
        public final ELNode body;

        public SYNCHRONIZED(int pos, ELNode exp, ELNode body) {
            super(69, pos);
            this.exp = exp;
            this.body = body;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(EvaluationContext context) {
            Frame f = context.getFrame();
            Object obj = this.exp.pos(f).getValue(context);
            if (obj instanceof ThisObject) {
                obj = ((ThisObject)obj).get_proxy();
            }
            if (obj == null) {
                throw this.runtimeError(context.getELContext(), new NullPointerException());
            }
            Object object = obj;
            synchronized (object) {
                return this.body.pos(f).getValue(context);
            }
        }

        public Class getType(EvaluationContext context) {
            return this.body.getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class CATCH
    extends ELNode {
        public final String var;
        public final ELNode body;

        public CATCH(int pos, String var, ELNode body) {
            super(111, pos);
            this.var = var;
            this.body = body;
        }

        public Object getValue(EvaluationContext context) {
            Object cp = new Object();
            try {
                EvaluationContext env = this.setup(context, cp);
                return this.body.pos(context.getFrame()).getValue(env);
            }
            catch (Control.Escape esc) {
                if (cp == esc.getCatchPoint()) {
                    return esc.getResult();
                }
                throw esc;
            }
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            Object cp = new Object();
            try {
                EvaluationContext env = this.setup(context, cp);
                return this.body.pos(context.getFrame()).invokeTail(env, call, args);
            }
            catch (Control.Escape esc) {
                if (cp == esc.getCatchPoint()) {
                    call.result = esc.getResult();
                    return false;
                }
                throw esc;
            }
        }

        private EvaluationContext setup(EvaluationContext context, final Object cp) {
            AbstractClosure escape = new AbstractClosure(){

                public Object invoke(ELContext context, Closure[] args) {
                    Object result = args.length > 0 ? args[0].getValue(context) : null;
                    throw new Control.Escape(result, cp);
                }
            };
            EvaluationContext env = context.pushContext();
            env.setVariable(this.var, escape);
            return env;
        }

        public Class getType(EvaluationContext context) {
            return this.body.pos(context.getFrame()).getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class TRY
    extends ELNode {
        public final ELNode body;
        public final DEFINE[] handlers;
        public final ELNode finalizer;

        public TRY(int pos, ELNode body, DEFINE[] handlers, ELNode finalizer) {
            super(110, pos);
            this.body = body;
            this.handlers = handlers;
            this.finalizer = finalizer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getValue(EvaluationContext context) {
            Object result;
            Frame f = context.getFrame();
            if (this.handlers != null) {
                try {
                    result = this.body.pos(f).getValue(context);
                    return result;
                }
                catch (Control control) {
                    throw control;
                }
                catch (EvaluationException ex) {
                    Throwable t = ex.getCause();
                    result = t != null ? this.handle(context, f, t) : this.handle(context, f, (Throwable)((Object)ex));
                    if (result != ELUtils.NO_RESULT) return result;
                    throw ex;
                }
                catch (RuntimeException ex) {
                    result = this.handle(context, f, ex);
                    if (result != ELUtils.NO_RESULT) return result;
                    throw ex;
                }
                catch (Error ex) {
                    result = this.handle(context, f, ex);
                    if (result != ELUtils.NO_RESULT) return result;
                    throw ex;
                }
                finally {
                    if (this.finalizer != null) {
                        this.finalizer.pos(f).getValue(context);
                    }
                }
            }
            try {
                result = this.body.pos(f).getValue(context);
                return result;
            }
            finally {
                this.finalizer.pos(f).getValue(context);
            }
        }

        private Object handle(EvaluationContext context, Frame f, Throwable exc) {
            DEFINE handler = null;
            for (DEFINE def : this.handlers) {
                if (def.type != null) {
                    if (!TypedClosure.typecheck(context, def.type, exc)) continue;
                    handler = def;
                    break;
                }
                handler = def;
                break;
            }
            if (handler != null) {
                EvaluationContext env = context.pushContext();
                env.setVariable(handler.id, new LiteralClosure(exc));
                return handler.expr.pos(f).getValue(env);
            }
            return ELUtils.NO_RESULT;
        }

        public Class getType(EvaluationContext context) {
            return this.body.getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class THROW
    extends ELNode {
        public final ELNode cause;

        public THROW(int pos, ELNode cause) {
            super(109, pos);
            this.cause = cause;
        }

        public Object getValue(EvaluationContext context) {
            ELContext elctx = context.getELContext();
            Object value = this.cause.getValue(context);
            if (value instanceof UserException) {
                throw (UserException)((Object)value);
            }
            if (value instanceof Throwable) {
                throw new UserException(elctx, (Throwable)value);
            }
            if (value instanceof String) {
                throw new UserException(elctx, (String)value);
            }
            throw new UserException(elctx);
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class RETURN
    extends ELNode {
        public final ELNode right;

        public RETURN(int pos, ELNode right) {
            super(109, pos);
            this.right = right;
        }

        public Class getType(EvaluationContext context) {
            return this.right.getType(context);
        }

        public Object getValue(EvaluationContext context) {
            throw new Control.Return(this.right.getValue(context));
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            return this.right.invokeTail(context, call, args);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class CONTINUE
    extends ELNode {
        public CONTINUE(int pos) {
            super(107, pos);
        }

        public Object getValue(EvaluationContext context) {
            throw new Control.Continue();
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class BREAK
    extends ELNode {
        public BREAK(int pos) {
            super(106, pos);
        }

        public Object getValue(EvaluationContext context) {
            throw new Control.Break();
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class LET
    extends ELNode {
        public final ELNode left;
        public final ELNode right;

        public LET(int pos, ELNode left, ELNode right) {
            super(97, pos);
            this.left = left;
            this.right = right;
        }

        public Object getValue(EvaluationContext context) {
            Frame f = context.getFrame();
            Object value = this.right.pos(f).getValue(context);
            if (!((Pattern)((Object)this.left.pos(f))).matches(context, value)) {
                throw this.runtimeError(context.getELContext(), "pattern not match");
            }
            return value;
        }

        public Class getType(EvaluationContext context) {
            return this.right.getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class MATCHCASE
    extends ELNode {
        public final Pattern[] patterns;
        public final ELNode guard;
        public final ELNode body;

        public MATCHCASE(int pos, Pattern pattern, ELNode guard, ELNode body) {
            this(pos, new Pattern[]{pattern}, guard, body);
        }

        public MATCHCASE(int pos, Pattern[] elems, ELNode guard, ELNode body) {
            super(104, pos);
            this.patterns = elems;
            this.guard = guard;
            this.body = body;
        }

        public Object getValue(EvaluationContext context) {
            throw new AssertionError();
        }

        public Class getType(EvaluationContext context) {
            throw new AssertionError();
        }

        public boolean matches(EvaluationContext context, Object[] args) {
            Frame frame = context.getFrame();
            if (this.patterns != null) {
                VariableMapperImpl vm = new VariableMapperImpl();
                EvaluationContext env = context.pushContext(vm);
                assert (this.patterns.length == args.length);
                for (int i = 0; i < this.patterns.length; ++i) {
                    ((ELNode)((Object)this.patterns[i])).pos(frame);
                    if (this.patterns[i].matches(env, args[i])) continue;
                    return false;
                }
                if (this.guard != null && !this.guard.pos(frame).getBoolean(env)) {
                    return false;
                }
                for (Map.Entry<String, ValueExpression> e : vm.getVariableMap().entrySet()) {
                    context.setVariable(e.getKey(), e.getValue());
                }
                return true;
            }
            return this.guard == null || this.guard.pos(frame).getBoolean(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class WITH
    extends ELNode {
        public final ELNode[] args;
        public final MATCHCASE[] alts;
        public final ELNode deflt;

        public WITH(int pos, ELNode arg, MATCHCASE alt, ELNode deflt) {
            this(pos, new ELNode[]{arg}, new MATCHCASE[]{alt}, deflt);
        }

        public WITH(int pos, ELNode arg, MATCHCASE[] alts, ELNode deflt) {
            this(pos, new ELNode[]{arg}, alts, deflt);
        }

        public WITH(int pos, ELNode[] args, MATCHCASE alt, ELNode deflt) {
            this(pos, args, new MATCHCASE[]{alt}, deflt);
        }

        public WITH(int pos, ELNode[] args, MATCHCASE[] alts, ELNode deflt) {
            super(103, pos);
            this.args = args;
            this.alts = alts;
            this.deflt = deflt;
        }

        public Object getValue(EvaluationContext context) {
            EvaluationContext env = context.pushContext();
            ELNode body = this.matchBody(env);
            return body.getValue(env);
        }

        public Class getType(EvaluationContext context) {
            EvaluationContext env = context.pushContext();
            ELNode body = this.matchBody(env);
            return body.getType(env);
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            EvaluationContext env = context.pushContext();
            ELNode body = this.matchBody(env);
            return body.invokeTail(env, call, args);
        }

        private ELNode matchBody(EvaluationContext context) {
            Frame f = context.getFrame();
            Object[] values = new Object[this.args.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.args[i].pos(f).getValue(context);
            }
            for (MATCHCASE b : this.alts) {
                if (!b.matches(context, values)) continue;
                return b.body.pos(f);
            }
            if (this.deflt == null) {
                this.pos(f);
                throw this.runtimeError(context.getELContext(), "no pattern matched.");
            }
            return this.deflt.pos(f);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class CASE
    extends ELNode {
        public final ELNode exp;
        public int index;

        public CASE(int pos, ELNode exp) {
            super(104, pos);
            this.exp = exp;
        }

        public Object getValue(EvaluationContext context) {
            throw new AssertionError();
        }

        public Class getType(EvaluationContext context) {
            throw new AssertionError();
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class SWITCH
    extends ELNode {
        public final ELNode arg;
        public final CASE[] cases;
        public final ELNode[] exps;

        public SWITCH(int pos, ELNode arg, CASE[] cases, ELNode[] exps) {
            super(102, pos);
            this.arg = arg;
            this.cases = cases;
            this.exps = exps;
        }

        public Object getValue(EvaluationContext context) {
            ELNode exp = this.findBranch(context);
            if (exp != null) {
                return exp.getValue(context);
            }
            return null;
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            ELNode exp = this.findBranch(context);
            if (exp != null) {
                return exp.invokeTail(context, call, args);
            }
            call.result = null;
            return false;
        }

        public Class getType(EvaluationContext context) {
            ELNode exp = this.findBranch(context);
            if (exp != null) {
                return exp.getType(context);
            }
            return null;
        }

        private ELNode findBranch(EvaluationContext context) {
            ELContext elctx = context.getELContext();
            Frame f = context.getFrame();
            ELNode deflt = null;
            Object sw = this.arg.pos(f).getValue(context);
            for (CASE c : this.cases) {
                if (c.exp == null) {
                    deflt = this.exps[c.index];
                    continue;
                }
                if (!EQ.equals(elctx, sw, c.exp.pos(f).getValue(context))) continue;
                return this.exps[c.index].pos(f);
            }
            return deflt == null ? null : deflt.pos(f);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FOREACH
    extends ELNode {
        public final DEFINE index;
        public final DEFINE var;
        public final ELNode range;
        public final ELNode body;

        public FOREACH(int pos, DEFINE index, DEFINE var, ELNode range, ELNode body) {
            super(100, pos);
            this.index = index;
            this.var = var;
            this.range = range;
            this.body = body;
        }

        @Override
        public Object getValue(EvaluationContext context) {
            Object range = this.range.getValue(context);
            if (range == null) {
                return null;
            }
            EvaluationContext env = context.pushContext();
            Closure var = this.var.defineClosure(context);
            env.setVariable(this.var.id, var);
            if (this.index != null) {
                Closure idx = this.index.defineClosure(context);
                env.setVariable(this.index.id, idx);
                if (range instanceof Range) {
                    Range r = (Range)range;
                    if (r.isUnbound()) {
                        this.step(env, idx, var, r.getBegin(), r.getStep());
                    } else if (r.getStep() > 0L) {
                        this.stepUp(env, idx, var, r.getBegin(), r.getEnd(), r.getStep());
                    } else {
                        this.stepDown(env, idx, var, r.getBegin(), r.getEnd(), r.getStep());
                    }
                } else if (range instanceof Iterable) {
                    this.foreach(env, idx, var, (Iterable)range);
                } else if (range instanceof Map) {
                    this.foreach(env, idx, var, (Map)range);
                } else if (range instanceof Object[]) {
                    this.foreach(env, idx, var, (Object[])range);
                } else if (range.getClass().isArray()) {
                    this.foreach(env, idx, var, range);
                } else if (range instanceof String) {
                    this.foreach(env, idx, var, (Object)((String)range).toCharArray());
                }
            } else if (range instanceof Range) {
                Range r = (Range)range;
                if (r.isUnbound()) {
                    this.step(env, var, r.getBegin(), r.getStep());
                } else if (r.getStep() > 0L) {
                    this.stepUp(env, var, r.getBegin(), r.getEnd(), r.getStep());
                } else {
                    this.stepDown(env, var, r.getBegin(), r.getEnd(), r.getStep());
                }
            } else if (range instanceof Iterable) {
                this.foreach(env, var, (Iterable)range);
            } else if (range instanceof Map) {
                this.foreach(env, var, (Map)range);
            } else if (range instanceof Object[]) {
                this.foreach(env, var, (Object[])range);
            } else if (range.getClass().isArray()) {
                this.foreach(env, var, range);
            } else if (range instanceof String) {
                this.foreach(env, var, (Object)((String)range).toCharArray());
            }
            return null;
        }

        private void step(EvaluationContext ctx, Closure idx, Closure var, long begin, long step) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int i = 0;
            long x = begin;
            while (true) {
                try {
                    idx.setValue(elctx, i);
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
                x += step;
                ++i;
            }
        }

        private void step(EvaluationContext ctx, Closure var, long begin, long step) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            long x = begin;
            while (true) {
                try {
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
                x += step;
            }
        }

        private void stepUp(EvaluationContext ctx, Closure idx, Closure var, long begin, long end, long step) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int i = 0;
            long x = begin;
            while (x <= end) {
                try {
                    idx.setValue(elctx, i);
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
                x += step;
                ++i;
            }
        }

        private void stepUp(EvaluationContext ctx, Closure var, long begin, long end, long step) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            for (long x = begin; x <= end; x += step) {
                try {
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
            }
        }

        private void stepDown(EvaluationContext ctx, Closure idx, Closure var, long begin, long end, long step) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int i = 0;
            long x = begin;
            while (x >= end) {
                try {
                    idx.setValue(elctx, i);
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
                x += step;
                ++i;
            }
        }

        private void stepDown(EvaluationContext ctx, Closure var, long begin, long end, long step) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            for (long x = begin; x >= end; x += step) {
                try {
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure idx, Closure var, Iterable xs) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int i = 0;
            for (Object x : xs) {
                try {
                    idx.setValue(elctx, i++);
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure var, Iterable xs) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            for (Object x : xs) {
                try {
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure idx, Closure var, Map<?, ?> map) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            for (Map.Entry<?, ?> e : map.entrySet()) {
                try {
                    idx.setValue(elctx, e.getKey());
                    var.setValue(elctx, e.getValue());
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure var, Map<?, ?> map) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            for (Map.Entry<?, ?> x : map.entrySet()) {
                try {
                    var.setValue(elctx, x);
                    this.body.pos(f).getValue(ctx);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure idx, Closure var, Object[] xs) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int len = xs.length;
            for (int i = 0; i < len; ++i) {
                try {
                    idx.setValue(elctx, i);
                    var.setValue(elctx, xs[i]);
                    this.body.pos(f).getValue(ctx);
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure var, Object[] xs) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int len = xs.length;
            for (int i = 0; i < len; ++i) {
                try {
                    var.setValue(elctx, xs[i]);
                    this.body.pos(f).getValue(ctx);
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure idx, Closure var, Object xs) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int len = Array.getLength(xs);
            for (int i = 0; i < len; ++i) {
                try {
                    idx.setValue(elctx, i);
                    var.setValue(elctx, Array.get(xs, i));
                    this.body.pos(f).getValue(ctx);
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
            }
        }

        private void foreach(EvaluationContext ctx, Closure var, Object xs) {
            ELContext elctx = ctx.getELContext();
            Frame f = ctx.getFrame();
            int len = Array.getLength(xs);
            for (int i = 0; i < len; ++i) {
                try {
                    var.setValue(elctx, Array.get(xs, i));
                    this.body.pos(f).getValue(ctx);
                    continue;
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue c) {
                    // empty catch block
                }
            }
        }

        @Override
        public Class getType(EvaluationContext context) {
            return null;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class FOR
    extends ELNode {
        public final ELNode[] init;
        public final ELNode cond;
        public final ELNode[] step;
        public final ELNode body;
        public final boolean local;

        public FOR(int pos, ELNode[] init, ELNode cond, ELNode[] step, ELNode body, boolean local) {
            super(100, pos);
            this.init = init;
            this.cond = cond;
            this.step = step;
            this.body = body;
            this.local = local;
        }

        public Object getValue(EvaluationContext context) {
            if (this.local) {
                context = context.pushContext();
            }
            Frame f = context.getFrame();
            if (this.init != null) {
                for (ELNode e : this.init) {
                    e.pos(f).getValue(context);
                }
            }
            while (this.cond.pos(f).getBoolean(context)) {
                if (this.body != null) {
                    try {
                        this.body.pos(f).getValue(context);
                    }
                    catch (Control.Break b) {
                        break;
                    }
                    catch (Control.Continue c) {
                        // empty catch block
                    }
                }
                if (this.step == null) continue;
                for (ELNode e : this.step) {
                    e.pos(f).getValue(context);
                }
            }
            return null;
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class WHILE
    extends ELNode {
        public final ELNode cond;
        public final ELNode body;

        public WHILE(int pos, ELNode cond, ELNode body) {
            super(101, pos);
            this.cond = cond;
            this.body = body;
        }

        public Object getValue(EvaluationContext context) {
            Frame f = context.getFrame();
            while (this.cond.pos(f).getBoolean(context)) {
                try {
                    this.body.pos(f).getValue(context);
                }
                catch (Control.Break b) {
                    break;
                }
                catch (Control.Continue continue_) {
                }
            }
            return null;
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class COMPOUND
    extends ELNode {
        public final ELNode[] exps;

        public COMPOUND(int pos, ELNode[] exps) {
            super(41, pos);
            this.exps = exps;
        }

        public Object getValue(EvaluationContext context) {
            int n = this.exps.length;
            if (n == 0) {
                return null;
            }
            EvaluationContext env = context.pushContext();
            Frame f = context.getFrame();
            for (int i = 0; i < n - 1; ++i) {
                this.exps[i].pos(f).getValue(env);
            }
            return this.exps[n - 1].pos(f).getValue(env);
        }

        public Class getType(EvaluationContext context) {
            int n = this.exps.length;
            if (n == 0) {
                return null;
            }
            EvaluationContext env = context.pushContext();
            Frame f = context.getFrame();
            for (int i = 0; i < n - 1; ++i) {
                this.exps[i].pos(f).getValue(env);
            }
            return this.exps[n - 1].pos(f).getType(env);
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            int n = this.exps.length;
            if (n == 0) {
                call.result = null;
                return false;
            }
            EvaluationContext env = context.pushContext();
            Frame f = context.getFrame();
            for (int i = 0; i < n - 1; ++i) {
                this.exps[i].pos(f).getValue(env);
            }
            return this.exps[n - 1].pos(f).invokeTail(env, call, args);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class EXPR
    extends Unary {
        public EXPR(int pos, ELNode right) {
            super(41, pos, right);
        }

        public Object getValue(EvaluationContext context) {
            return this.right.getValue(context);
        }

        public Class getType(EvaluationContext context) {
            return this.right.getType(context);
        }

        public boolean isReadOnly(EvaluationContext context) {
            return this.right.isReadOnly(context);
        }

        public void setValue(EvaluationContext context, Object value) {
            this.right.setValue(context, value);
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            return this.right.invokeTail(context, call, args);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class EMPTY
    extends Unary {
        public EMPTY(int pos, ELNode right) {
            super(39, pos, right);
        }

        public int precedence() {
            return 14;
        }

        protected Object evaluate(ELContext elctx, Object x) {
            boolean result = x == null ? true : (x instanceof String ? ((String)x).length() == 0 : (x.getClass().isArray() ? Array.getLength(x) == 0 : (x instanceof Map ? ((Map)x).isEmpty() : (x instanceof Collection ? ((Collection)x).isEmpty() : false))));
            return result;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class NOT
    extends Unary {
        public NOT(int pos, ELNode right) {
            super(33, pos, right);
        }

        public int precedence() {
            return 14;
        }

        public Object getValue(EvaluationContext context) {
            return !this.right.getBoolean(context);
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class DEC
    extends Unary {
        public final boolean is_preincrement;

        public DEC(int pos, ELNode right, boolean is_preincrement) {
            super(38, pos, right);
            this.is_preincrement = is_preincrement;
        }

        public int precedence() {
            return this.is_preincrement ? 14 : 17;
        }

        public Object getValue(EvaluationContext context) {
            Comparable<Long> y;
            Object x = this.right.getValue(context);
            if (x == null) {
                y = null;
            } else if (x instanceof Long) {
                y = (Long)x - 1L;
            } else if (x instanceof Integer) {
                y = (Integer)x - 1;
            } else if (x instanceof Double) {
                y = (Double)x - 1.0;
            } else if (x instanceof Float) {
                y = Float.valueOf(((Float)x).floatValue() - 1.0f);
            } else if (x instanceof Short) {
                y = (short)((Short)x - 1);
            } else if (x instanceof Character) {
                y = Character.valueOf((char)(((Character)x).charValue() - '\u0001'));
            } else if (x instanceof Byte) {
                y = (byte)((Byte)x - 1);
            } else if (x instanceof BigDecimal) {
                y = ((BigDecimal)x).subtract(BigDecimal.ONE);
            } else if (x instanceof BigInteger) {
                y = ((BigInteger)x).subtract(BigInteger.ONE);
            } else if (x instanceof Decimal) {
                y = ((Decimal)x).subtract(Decimal.ONE);
            } else if (x instanceof Rational) {
                y = ((Rational)x).subtract(Rational.ONE);
            } else {
                throw this.runtimeError(context.getELContext(), Resources._T("JSPRT_UNSUPPORTED_EVAL_TYPE", x.getClass().getName()));
            }
            this.right.setValue(context, y);
            return this.is_preincrement ? y : x;
        }

        public Class getType(EvaluationContext context) {
            return this.right.getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class INC
    extends Unary {
        public final boolean is_preincrement;

        public INC(int pos, ELNode right, boolean is_preincrement) {
            super(37, pos, right);
            this.is_preincrement = is_preincrement;
        }

        public int precedence() {
            return this.is_preincrement ? 14 : 17;
        }

        public Object getValue(EvaluationContext context) {
            Comparable<Long> y;
            Object x = this.right.getValue(context);
            if (x == null) {
                y = null;
            } else if (x instanceof Long) {
                y = (Long)x + 1L;
            } else if (x instanceof Integer) {
                y = (Integer)x + 1;
            } else if (x instanceof Double) {
                y = (Double)x + 1.0;
            } else if (x instanceof Float) {
                y = Float.valueOf(((Float)x).floatValue() + 1.0f);
            } else if (x instanceof Short) {
                y = (short)((Short)x + 1);
            } else if (x instanceof Character) {
                y = Character.valueOf((char)(((Character)x).charValue() + '\u0001'));
            } else if (x instanceof Byte) {
                y = (byte)((Byte)x + 1);
            } else if (x instanceof BigDecimal) {
                y = ((BigDecimal)x).add(BigDecimal.ONE);
            } else if (x instanceof BigInteger) {
                y = ((BigInteger)x).add(BigInteger.ONE);
            } else if (x instanceof Decimal) {
                y = ((Decimal)x).add(Decimal.ONE);
            } else if (x instanceof Rational) {
                y = ((Rational)x).add(Rational.ONE);
            } else {
                throw this.runtimeError(context.getELContext(), Resources._T("JSPRT_UNSUPPORTED_EVAL_TYPE", x.getClass().getName()));
            }
            this.right.setValue(context, y);
            return this.is_preincrement ? y : x;
        }

        public Class getType(EvaluationContext context) {
            return this.right.getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class NEG
    extends Unary {
        public NEG(int pos, ELNode right) {
            super(36, pos, right);
        }

        public int precedence() {
            return 14;
        }

        protected Object evaluate(ELContext elctx, Object x) {
            if (x == null) {
                return 0;
            }
            if (x instanceof Long) {
                return -((Long)x).longValue();
            }
            if (x instanceof Integer) {
                return -((Integer)x).intValue();
            }
            if (x instanceof Double) {
                return -((Double)x).doubleValue();
            }
            if (x instanceof Float) {
                return Float.valueOf(-((Float)x).floatValue());
            }
            if (x instanceof Short) {
                return (int)(-((Short)x).shortValue());
            }
            if (x instanceof Byte) {
                return (int)(-((Byte)x).byteValue());
            }
            if (x instanceof BigDecimal) {
                return ((BigDecimal)x).negate();
            }
            if (x instanceof BigInteger) {
                return ((BigInteger)x).negate();
            }
            if (x instanceof Decimal) {
                return ((Decimal)x).negate();
            }
            if (x instanceof Rational) {
                return ((Rational)x).negate();
            }
            if (x instanceof String) {
                String s = (String)x;
                if (ELUtils.looksLikeFloat(s)) {
                    return -Double.valueOf(s).doubleValue();
                }
                return -Long.valueOf(s).longValue();
            }
            throw this.runtimeError(elctx, Resources._T("JSPRT_UNSUPPORTED_EVAL_TYPE", x.getClass().getName()));
        }

        public Class getType(EvaluationContext context) {
            return Number.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class POS
    extends Unary {
        public POS(int pos, ELNode right) {
            super(35, pos, right);
        }

        public int precedence() {
            return 14;
        }

        protected Object evaluate(ELContext elctx, Object x) {
            if (x == null) {
                return 0;
            }
            if (x instanceof String) {
                if (ELUtils.looksLikeFloat(x)) {
                    return TypeCoercion.coerceToDouble(x);
                }
                return TypeCoercion.coerceToLong(x);
            }
            if (x instanceof Number) {
                return x;
            }
            throw this.runtimeError(elctx, Resources._T("JSPRT_UNSUPPORTED_EVAL_TYPE", x.getClass().getName()));
        }

        public Class getType(EvaluationContext context) {
            return Number.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class BITNOT
    extends Unary {
        public BITNOT(int pos, ELNode right) {
            super(34, pos, right);
        }

        public int precedence() {
            return 14;
        }

        protected Object evaluate(ELContext elctx, Object x) {
            if (x == null) {
                return 0;
            }
            if (x instanceof Long) {
                return (Long)x ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (x instanceof Integer) {
                return ~((Integer)x).intValue();
            }
            if (x instanceof Short) {
                return ~((Short)x).shortValue();
            }
            if (x instanceof Byte) {
                return ~((Byte)x).byteValue();
            }
            if (x instanceof BigDecimal) {
                return ((BigDecimal)x).toBigInteger().not();
            }
            if (x instanceof BigInteger) {
                return ((BigInteger)x).not();
            }
            return TypeCoercion.coerceToLong(x) ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public Class getType(EvaluationContext context) {
            return Number.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class POW
    extends Arithmetic {
        public POW(int pos, ELNode left, ELNode right) {
            super(30, pos, left, right);
        }

        public int precedence() {
            return 16;
        }

        public ELNode order() {
            if (this.precedence() >= this.left.precedence()) {
                Unary e = (Unary)this.left;
                this.left = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }

        protected Object evaluate(ELContext elctx, Object x, Object y) {
            if (x == null || y == null) {
                return 0;
            }
            if (x instanceof Number && y instanceof Number) {
                return this.pow(elctx, (Number)x, (Number)y);
            }
            return Math.pow(TypeCoercion.coerceToDouble(x), TypeCoercion.coerceToDouble(y));
        }

        private Number pow(ELContext elctx, Number x, Number y) {
            if (y instanceof Integer || y instanceof Short || y instanceof Byte) {
                int n = y.intValue();
                if (x instanceof BigInteger) {
                    if (n == 0) {
                        return 1;
                    }
                    if (n == 1) {
                        return x;
                    }
                    if (n > 0) {
                        return ((BigInteger)x).pow(n);
                    }
                    if (GlobalScope.isRationalEnabled(elctx)) {
                        return Rational.make(BigInteger.ONE, ((BigInteger)x).pow(-n));
                    }
                    return Math.pow(x.doubleValue(), n);
                }
                if (x instanceof Long || x instanceof Integer || x instanceof Short || x instanceof Byte) {
                    long m = x.longValue();
                    if (n == 0) {
                        return 1;
                    }
                    if (n == 1) {
                        return m;
                    }
                    if (n > 0) {
                        BigInteger z = BigInteger.valueOf(m).pow(n);
                        return z.bitLength() < 32 ? (Number)z.intValue() : (Number)(z.bitLength() < 64 ? Long.valueOf(z.longValue()) : z);
                    }
                    if (GlobalScope.isRationalEnabled(elctx)) {
                        return Rational.make(BigInteger.ONE, BigInteger.valueOf(m).pow(-n));
                    }
                    return Math.pow(x.doubleValue(), n);
                }
                if (x instanceof BigDecimal) {
                    MathContext mc = (MathContext)elctx.getContext(MathContext.class);
                    return mc == null ? ((BigDecimal)x).pow(n) : ((BigDecimal)x).pow(n, mc);
                }
                if (x instanceof Decimal) {
                    return Decimal.valueOf(((Decimal)x).toBigDecimal().pow(n));
                }
                if (x instanceof Rational) {
                    return ((Rational)x).pow(n).reduce();
                }
                return Math.pow(x.doubleValue(), n);
            }
            return Math.pow(x.doubleValue(), y.doubleValue());
        }

        protected Number eval(ELContext elctx, BigDecimal x, BigDecimal y) {
            return null;
        }

        protected Number eval(ELContext elctx, BigInteger x, BigInteger y) {
            return null;
        }

        protected Number eval(ELContext elctx, Decimal x, Decimal y) {
            return null;
        }

        protected Number eval(ELContext elctx, Rational x, Rational y) {
            return null;
        }

        protected Number eval(ELContext elctx, long x, long y) {
            return null;
        }

        protected Number eval(ELContext elctx, double x, double y) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class REM
    extends Arithmetic {
        public REM(int pos, ELNode left, ELNode right) {
            super(29, pos, left, right);
        }

        public int precedence() {
            return 13;
        }

        protected Number eval(ELContext elctx, BigDecimal x, BigDecimal y) {
            MathContext mc = GlobalScope.getMathContext(elctx);
            return mc == null ? x.remainder(y) : x.remainder(y, mc);
        }

        protected Number eval(ELContext elctx, BigInteger x, BigInteger y) {
            return x.remainder(y);
        }

        protected Number eval(ELContext elctx, Decimal x, Decimal y) {
            return x.remainder(y);
        }

        protected Number eval(ELContext elctx, Rational x, Rational y) {
            return x.remainder(y).reduce();
        }

        protected Number eval(ELContext elctx, long x, long y) {
            return x % y;
        }

        protected Number eval(ELContext elctx, double x, double y) {
            return x % y;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class IDIV
    extends DIV {
        public IDIV(int pos, ELNode left, ELNode right) {
            super(28, pos, left, right);
        }

        protected Number eval(ELContext elctx, BigDecimal x, BigDecimal y) {
            return x.toBigInteger().divide(y.toBigInteger());
        }

        protected Number eval(ELContext elctx, BigInteger x, BigInteger y) {
            return x.divide(y);
        }

        protected Number eval(ELContext elctx, Decimal x, Decimal y) {
            return x.divide(y).longValue();
        }

        protected Number eval(ELContext elctx, Rational x, Rational y) {
            return x.divide(y).longValue();
        }

        protected Number eval(ELContext elctx, long x, long y) {
            return x / y;
        }

        protected Number eval(ELContext elctx, double x, double y) {
            return (long)x / (long)y;
        }
    }

    public static class DIV
    extends Arithmetic {
        public DIV(int pos, ELNode left, ELNode right) {
            super(27, pos, left, right);
        }

        protected DIV(int op, int pos, ELNode left, ELNode right) {
            super(op, pos, left, right);
        }

        public int precedence() {
            return 13;
        }

        protected Number eval(ELContext elctx, BigDecimal x, BigDecimal y) {
            MathContext mc = GlobalScope.getMathContext(elctx);
            if (mc == null) {
                mc = new MathContext((int)Math.min((long)x.precision() + (long)Math.ceil(10.0 * (double)y.precision() / 3.0), Integer.MAX_VALUE), RoundingMode.HALF_UP);
            }
            return x.divide(y, mc);
        }

        protected Number eval(ELContext elctx, BigInteger x, BigInteger y) {
            BigInteger[] r = x.divideAndRemainder(y);
            if (r[1].equals(BigInteger.ZERO)) {
                return r[0];
            }
            if (GlobalScope.isRationalEnabled(elctx)) {
                return Rational.make(x, y);
            }
            return this.eval(elctx, new BigDecimal(x), new BigDecimal(y));
        }

        protected Number eval(ELContext elctx, Decimal x, Decimal y) {
            return x.divide(y);
        }

        protected Number eval(ELContext elctx, Rational x, Rational y) {
            return x.divide(y).reduce();
        }

        protected Number eval(ELContext elctx, long x, long y) {
            if (x % y == 0L) {
                return x / y;
            }
            if (GlobalScope.isRationalEnabled(elctx)) {
                return Rational.make(x, y);
            }
            return (double)x / (double)y;
        }

        protected Number eval(ELContext elctx, double x, double y) {
            return x / y;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class MUL
    extends Arithmetic {
        public MUL(int pos, ELNode left, ELNode right) {
            super(26, pos, left, right);
        }

        public int precedence() {
            return 13;
        }

        protected Number eval(ELContext elctx, BigDecimal x, BigDecimal y) {
            MathContext mc = GlobalScope.getMathContext(elctx);
            return mc == null ? x.multiply(y) : x.multiply(y, mc);
        }

        protected Number eval(ELContext elctx, BigInteger x, BigInteger y) {
            return x.multiply(y);
        }

        protected Number eval(ELContext elctx, Decimal x, Decimal y) {
            return x.multiply(y);
        }

        protected Number eval(ELContext elctx, Rational x, Rational y) {
            return x.multiply(y).reduce();
        }

        protected Number eval(ELContext elctx, double x, double y) {
            return x * y;
        }

        protected Number eval(ELContext elctx, long x, long y) {
            long z = x * y;
            if (y != 0L && z / y != x) {
                return BigInteger.valueOf(x).multiply(BigInteger.valueOf(y));
            }
            return z;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class SUB
    extends Arithmetic {
        public SUB(int pos, ELNode left, ELNode right) {
            super(25, pos, left, right);
        }

        public int precedence() {
            return 12;
        }

        protected Object evaluate(ELContext elctx, Object x, Object y) {
            if (x instanceof Character && y instanceof Integer) {
                int z = ((Character)x).charValue() - (Integer)y;
                if (z >= 0 && z <= 65535) {
                    return Character.valueOf((char)z);
                }
                return z;
            }
            return super.evaluate(elctx, x, y);
        }

        protected Number eval(ELContext elctx, BigDecimal x, BigDecimal y) {
            MathContext mc = GlobalScope.getMathContext(elctx);
            return mc == null ? x.subtract(y) : x.subtract(y);
        }

        protected Number eval(ELContext elctx, BigInteger x, BigInteger y) {
            return x.subtract(y);
        }

        protected Number eval(ELContext elctx, Decimal x, Decimal y) {
            return x.subtract(y);
        }

        protected Number eval(ELContext elctx, Rational x, Rational y) {
            return x.subtract(y).reduce();
        }

        protected Number eval(ELContext elctx, double x, double y) {
            return x - y;
        }

        protected Number eval(ELContext elctx, long x, long y) {
            long z = x - y;
            if (((x ^ (y ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (x ^ z) & Long.MIN_VALUE) != 0L) {
                return BigInteger.valueOf(x).subtract(BigInteger.valueOf(y));
            }
            return z;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class ADD
    extends Arithmetic {
        public ADD(int pos, ELNode left, ELNode right) {
            super(24, pos, left, right);
        }

        public int precedence() {
            return 12;
        }

        protected Object evaluate(ELContext elctx, Object x, Object y) {
            if (x instanceof CharSequence || y instanceof CharSequence) {
                if (ELUtils.looksLikeNumber(x) && ELUtils.looksLikeNumber(y)) {
                    return super.evaluate(elctx, x, y);
                }
                return "" + x + y;
            }
            if (x instanceof Character && y instanceof Integer) {
                int z = ((Character)x).charValue() + (Integer)y;
                if (z >= 0 && z <= 65535) {
                    return Character.valueOf((char)z);
                }
                return z;
            }
            return super.evaluate(elctx, x, y);
        }

        protected Number eval(ELContext elctx, BigDecimal x, BigDecimal y) {
            MathContext mc = GlobalScope.getMathContext(elctx);
            return mc == null ? x.add(y) : x.add(y, mc);
        }

        protected Number eval(ELContext elctx, BigInteger x, BigInteger y) {
            return x.add(y);
        }

        protected Number eval(ELContext elctx, Decimal x, Decimal y) {
            return x.add(y);
        }

        protected Number eval(ELContext elctx, Rational x, Rational y) {
            return x.add(y).reduce();
        }

        protected Number eval(ELContext elctx, double x, double y) {
            return x + y;
        }

        protected Number eval(ELContext elctx, long x, long y) {
            long z = x + y;
            if (((x ^ y ^ 0xFFFFFFFFFFFFFFFFL) & (x ^ z) & Long.MIN_VALUE) != 0L) {
                return BigInteger.valueOf(x).add(BigInteger.valueOf(y));
            }
            return z;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static abstract class Arithmetic
    extends Binary {
        public Arithmetic(int op, int pos, ELNode left, ELNode right) {
            super(op, pos, left, right);
        }

        public Class getType(EvaluationContext context) {
            return Number.class;
        }

        protected abstract Number eval(ELContext var1, BigDecimal var2, BigDecimal var3);

        protected abstract Number eval(ELContext var1, BigInteger var2, BigInteger var3);

        protected abstract Number eval(ELContext var1, Decimal var2, Decimal var3);

        protected abstract Number eval(ELContext var1, Rational var2, Rational var3);

        protected abstract Number eval(ELContext var1, long var2, long var4);

        protected abstract Number eval(ELContext var1, double var2, double var4);

        protected Object evaluate(ELContext elctx, Object x, Object y) {
            if (x == null || y == null) {
                return 0;
            }
            if (x.getClass() == y.getClass()) {
                if (x instanceof Long) {
                    return this.eval(elctx, (Long)x, (Long)y);
                }
                if (x instanceof Integer) {
                    return this.eval(elctx, ((Integer)x).longValue(), ((Integer)y).longValue());
                }
                if (x instanceof Double) {
                    return this.eval(elctx, (Double)x, (Double)y);
                }
                if (x instanceof Float) {
                    return this.eval(elctx, ((Float)x).doubleValue(), ((Float)y).doubleValue());
                }
                if (x instanceof Short) {
                    return this.eval(elctx, ((Short)x).longValue(), ((Short)y).longValue());
                }
                if (x instanceof Byte) {
                    return this.eval(elctx, ((Byte)x).longValue(), ((Byte)y).longValue());
                }
                if (x instanceof Decimal) {
                    return this.eval(elctx, (Decimal)x, (Decimal)y);
                }
                if (x instanceof Rational) {
                    return this.eval(elctx, (Rational)x, (Rational)y);
                }
                if (x instanceof BigInteger) {
                    return this.eval(elctx, (BigInteger)x, (BigInteger)y);
                }
                if (x instanceof BigDecimal) {
                    return this.eval(elctx, (BigDecimal)x, (BigDecimal)y);
                }
            }
            if (x instanceof BigDecimal || y instanceof BigDecimal) {
                return this.eval(elctx, TypeCoercion.coerceToBigDecimal(elctx, x), TypeCoercion.coerceToBigDecimal(elctx, y));
            }
            if (x instanceof Decimal || y instanceof Decimal) {
                return this.eval(elctx, TypeCoercion.coerceToDecimal(x), TypeCoercion.coerceToDecimal(y));
            }
            if (x instanceof Float || x instanceof Double || y instanceof Float || y instanceof Double || ELUtils.looksLikeFloat(x) || ELUtils.looksLikeFloat(y)) {
                return this.eval(elctx, TypeCoercion.coerceToDouble(x), TypeCoercion.coerceToDouble(y));
            }
            if (x instanceof Rational || y instanceof Rational) {
                return this.eval(elctx, TypeCoercion.coerceToRational(x), TypeCoercion.coerceToRational(y));
            }
            if (x instanceof BigInteger || y instanceof BigInteger) {
                return this.eval(elctx, TypeCoercion.coerceToBigInteger(x), TypeCoercion.coerceToBigInteger(y));
            }
            return this.eval(elctx, TypeCoercion.coerceToLong(x), TypeCoercion.coerceToLong(y));
        }
    }

    public static class IN
    extends Binary {
        public final boolean negative;

        public IN(int pos, ELNode left, ELNode right, boolean negative) {
            super(32, pos, left, right);
            this.negative = negative;
        }

        public int precedence() {
            return 10;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public Object getValue(EvaluationContext context) {
            try {
                return this.eval(context.getELContext(), this.left.getValue(context), this.right.getValue(context)) ^ this.negative;
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(context.getELContext(), ex);
            }
        }

        private boolean eval(ELContext elctx, Object x, Object y) {
            block12: {
                if (x == null || y == null) {
                    return false;
                }
                if (y instanceof Object[]) {
                    Object[] a = (Object[])y;
                    int length = a.length;
                    for (int i = 0; i < length; ++i) {
                        if (!EQ.equals(elctx, x, a[i])) continue;
                        return true;
                    }
                    return false;
                }
                if (y.getClass().isArray()) {
                    x = TypeCoercion.coerce(x, y.getClass().getComponentType());
                    int length = Array.getLength(y);
                    for (int i = 0; i < length; ++i) {
                        if (!EQ.equals(elctx, x, Array.get(y, i))) continue;
                        return true;
                    }
                    return false;
                }
                if (!(y instanceof Collection)) break block12;
                if (x instanceof Collection) {
                    return ((Collection)y).containsAll((Collection)x);
                }
                if (y instanceof Set) {
                    return ((Set)y).contains(x);
                }
                if (y instanceof Seq) {
                    Seq seq = (Seq)y;
                    while (!seq.isEmpty()) {
                        if (EQ.equals(elctx, x, seq.get())) {
                            return true;
                        }
                        seq = seq.tail();
                    }
                } else {
                    for (Object e : (Collection)y) {
                        if (!EQ.equals(elctx, x, e)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class INSTANCEOF
    extends Unary {
        public final String type;
        public final boolean negative;

        public int precedence() {
            return 10;
        }

        public INSTANCEOF(int pos, ELNode right, String type, boolean negative) {
            super(31, pos, right);
            this.type = type;
            this.negative = negative;
        }

        public Object getValue(EvaluationContext context) {
            Object value = this.right.getValue(context);
            boolean check = TypedClosure.typecheck(context, this.type, value);
            return check ^ this.negative;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class GE
    extends Comparison {
        public GE(int pos, ELNode left, ELNode right) {
            super(20, pos, left, right);
        }

        protected boolean eval(Comparable x, Comparable y) {
            return x.compareTo(y) >= 0;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class GT
    extends Comparison {
        public GT(int pos, ELNode left, ELNode right) {
            super(18, pos, left, right);
        }

        protected boolean eval(Comparable x, Comparable y) {
            return x.compareTo(y) > 0;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class LE
    extends Comparison {
        public LE(int pos, ELNode left, ELNode right) {
            super(19, pos, left, right);
        }

        protected boolean eval(Comparable x, Comparable y) {
            return x.compareTo(y) <= 0;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class LT
    extends Comparison {
        public LT(int pos, ELNode left, ELNode right) {
            super(17, pos, left, right);
        }

        protected boolean eval(Comparable x, Comparable y) {
            return x.compareTo(y) < 0;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static abstract class Comparison
    extends Binary {
        Comparison(int op, int pos, ELNode left, ELNode right) {
            super(op, pos, left, right);
        }

        public int precedence() {
            return 10;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        protected abstract boolean eval(Comparable var1, Comparable var2);

        protected Boolean evaluate(ELContext elctx, Object x, Object y) {
            if (x == y) {
                return this.op == 19 || this.op == 20;
            }
            if (x == null || y == null) {
                return false;
            }
            if (x.getClass() == y.getClass() && x instanceof Comparable) {
                return this.eval((Comparable)x, (Comparable)y);
            }
            if (x instanceof BigDecimal || y instanceof BigDecimal) {
                return this.eval(TypeCoercion.coerceToBigDecimal(elctx, x), TypeCoercion.coerceToBigDecimal(elctx, y));
            }
            if (x instanceof Decimal || y instanceof Decimal) {
                return this.eval(TypeCoercion.coerceToDecimal(x), TypeCoercion.coerceToDecimal(y));
            }
            if (x instanceof Float || y instanceof Float || x instanceof Double || y instanceof Double) {
                return this.eval(TypeCoercion.coerceToDouble(x), TypeCoercion.coerceToDouble(y));
            }
            if (x instanceof Rational || y instanceof Rational) {
                return this.eval(TypeCoercion.coerceToRational(x), TypeCoercion.coerceToRational(y));
            }
            if (x instanceof BigInteger || y instanceof BigInteger) {
                return this.eval(TypeCoercion.coerceToBigInteger(x), TypeCoercion.coerceToBigInteger(y));
            }
            if (x instanceof Number || y instanceof Number) {
                return this.eval(TypeCoercion.coerceToLong(x), TypeCoercion.coerceToLong(y));
            }
            if (x instanceof String || y instanceof String) {
                return this.eval((Comparable)((Object)x.toString()), (Comparable)((Object)y.toString()));
            }
            if (x instanceof Comparable && y instanceof Comparable) {
                return this.eval((Comparable)x, (Comparable)y);
            }
            throw new ELException(Resources._T("JSPRT_UNSUPPORTED_EVAL_TYPE", x.getClass().getName()));
        }
    }

    public static class IDNE
    extends Binary {
        public IDNE(int pos, ELNode left, ELNode right) {
            super(16, pos, left, right);
        }

        public int precedence() {
            return 9;
        }

        protected Boolean evaluate(ELContext elctx, Object x, Object y) {
            return x != y;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class IDEQ
    extends Binary {
        public IDEQ(int pos, ELNode left, ELNode right) {
            super(15, pos, left, right);
        }

        public int precedence() {
            return 9;
        }

        protected Boolean evaluate(ELContext elctx, Object x, Object y) {
            return x == y;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class NE
    extends Equality {
        public NE(int pos, ELNode left, ELNode right) {
            super(14, pos, left, right);
        }

        protected boolean eval(Number x, Number y) {
            if (x instanceof Comparable) {
                return ((Comparable)((Object)x)).compareTo(y) != 0;
            }
            return !x.equals(y);
        }

        protected boolean eval(Object x, Object y) {
            return !x.equals(y);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class EQ
    extends Equality {
        private static final EQ __eq__ = new EQ(-1, null, null);

        public EQ(int pos, ELNode left, ELNode right) {
            super(13, pos, left, right);
        }

        protected boolean eval(Number x, Number y) {
            if (x instanceof Comparable) {
                return ((Comparable)((Object)x)).compareTo(y) == 0;
            }
            return x.equals(y);
        }

        protected boolean eval(Object x, Object y) {
            return x.equals(y);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }

        public static boolean equals(ELContext elctx, Object x, Object y) {
            return __eq__.evaluate(elctx, x, y);
        }
    }

    public static abstract class Equality
    extends Binary {
        Equality(int op, int pos, ELNode left, ELNode right) {
            super(op, pos, left, right);
        }

        public int precedence() {
            return 9;
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        protected abstract boolean eval(Number var1, Number var2);

        protected abstract boolean eval(Object var1, Object var2);

        protected Boolean evaluate(ELContext elctx, Object x, Object y) {
            if (x == y) {
                return this.op == 13;
            }
            if (x == null || y == null) {
                return this.op != 13;
            }
            if (x.getClass() == y.getClass()) {
                if (x instanceof Number) {
                    return this.eval((Number)((Object)x), (Number)((Object)y));
                }
                if (x instanceof Object[]) {
                    return this.eval(elctx, (Object[])x, (Object[])y);
                }
                return this.eval(x, y);
            }
            if (x instanceof Number && y instanceof Number) {
                if (x instanceof ClosureObject) {
                    return this.eval(x, y);
                }
                if (x instanceof BigDecimal || y instanceof BigDecimal) {
                    return this.eval(TypeCoercion.coerceToBigDecimal(elctx, x), TypeCoercion.coerceToBigDecimal(elctx, y));
                }
                if (x instanceof Decimal || y instanceof Decimal) {
                    return this.eval(TypeCoercion.coerceToDecimal(x), TypeCoercion.coerceToDecimal(y));
                }
                if (x instanceof Float || y instanceof Float || x instanceof Double || y instanceof Double) {
                    return this.eval(TypeCoercion.coerceToDouble(x), TypeCoercion.coerceToDouble(y));
                }
                if (x instanceof Rational || y instanceof Rational) {
                    return this.eval(TypeCoercion.coerceToRational(x), TypeCoercion.coerceToRational(y));
                }
                if (x instanceof BigInteger || y instanceof BigInteger) {
                    return this.eval(TypeCoercion.coerceToBigInteger(x), TypeCoercion.coerceToBigInteger(y));
                }
                return this.eval(TypeCoercion.coerceToLong(x), TypeCoercion.coerceToLong(y));
            }
            if (x instanceof Boolean || y instanceof Boolean) {
                return this.eval(TypeCoercion.coerceToBoolean(x), TypeCoercion.coerceToBoolean(y));
            }
            if (x instanceof Enum || y instanceof Enum) {
                if (!(x instanceof Enum)) {
                    x = TypeCoercion.coerceToEnum(x, ((Enum)y).getClass());
                }
                if (!(y instanceof Enum)) {
                    y = TypeCoercion.coerceToEnum(y, x.getClass());
                }
                return this.eval(x, y);
            }
            if (x instanceof String || y instanceof String) {
                return this.eval(x.toString(), y.toString());
            }
            if (x instanceof Object[] && y instanceof Object[]) {
                return this.eval((Object[])x, (Object[])y);
            }
            if (x instanceof Character && y instanceof Number || x instanceof Number && y instanceof Character) {
                return this.eval(TypeCoercion.coerceToCharacter(x), TypeCoercion.coerceToCharacter(y));
            }
            return this.eval(x, y);
        }

        protected boolean eval(ELContext elctx, Object[] x, Object[] y) {
            int length = x.length;
            if (y.length != length) {
                return this.op != 13;
            }
            for (int i = 0; i < length; ++i) {
                if (this.evaluate(elctx, x[i], y[i]).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    public static class USHR
    extends BitwiseShift {
        public USHR(int pos, ELNode left, ELNode right) {
            super(23, pos, left, right);
        }

        protected BigInteger eval(BigInteger z, int n) {
            return z.shiftRight(n);
        }

        protected long eval(long z, int n) {
            return z >>> n;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class SHR
    extends BitwiseShift {
        public SHR(int pos, ELNode left, ELNode right) {
            super(22, pos, left, right);
        }

        protected BigInteger eval(BigInteger z, int n) {
            return z.shiftRight(n);
        }

        protected long eval(long z, int n) {
            return z >> n;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class SHL
    extends BitwiseShift {
        public SHL(int pos, ELNode left, ELNode right) {
            super(21, pos, left, right);
        }

        protected BigInteger eval(BigInteger z, int n) {
            return z.shiftLeft(n);
        }

        protected long eval(long z, int n) {
            return z << n;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static abstract class BitwiseShift
    extends Binary {
        BitwiseShift(int op, int pos, ELNode left, ELNode right) {
            super(op, pos, left, right);
        }

        public int precedence() {
            return 11;
        }

        public Class getType(EvaluationContext context) {
            return Number.class;
        }

        protected abstract BigInteger eval(BigInteger var1, int var2);

        protected abstract long eval(long var1, int var3);

        protected Object evaluate(ELContext elctx, Object z, Object n) {
            if (z == null || n == null) {
                return 0;
            }
            if (z instanceof BigInteger) {
                return this.eval(TypeCoercion.coerceToBigInteger(z), TypeCoercion.coerceToInt(n));
            }
            return this.eval(TypeCoercion.coerceToLong(z), TypeCoercion.coerceToInt(n));
        }
    }

    public static class XOR
    extends Bitwise {
        public XOR(int pos, ELNode left, ELNode right) {
            super(11, pos, left, right);
        }

        public int precedence() {
            return 7;
        }

        protected BigInteger eval(BigInteger x, BigInteger y) {
            return x.xor(y);
        }

        protected long eval(long x, long y) {
            return x ^ y;
        }

        protected boolean eval(boolean x, boolean y) {
            return x ^ y;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class BITAND
    extends Bitwise {
        public BITAND(int pos, ELNode left, ELNode right) {
            super(12, pos, left, right);
        }

        public int precedence() {
            return 8;
        }

        protected BigInteger eval(BigInteger x, BigInteger y) {
            return x.and(y);
        }

        protected long eval(long x, long y) {
            return x & y;
        }

        protected boolean eval(boolean x, boolean y) {
            return x & y;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class BITOR
    extends Bitwise {
        public BITOR(int pos, ELNode left, ELNode right) {
            super(10, pos, left, right);
        }

        public int precedence() {
            return 6;
        }

        protected BigInteger eval(BigInteger x, BigInteger y) {
            return x.or(y);
        }

        protected long eval(long x, long y) {
            return x | y;
        }

        protected boolean eval(boolean x, boolean y) {
            return x | y;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static abstract class Bitwise
    extends Binary {
        Bitwise(int op, int pos, ELNode left, ELNode right) {
            super(op, pos, left, right);
        }

        public Class getType(EvaluationContext context) {
            return Number.class;
        }

        protected abstract BigInteger eval(BigInteger var1, BigInteger var2);

        protected abstract long eval(long var1, long var3);

        protected abstract boolean eval(boolean var1, boolean var2);

        protected Object evaluate(ELContext elctx, Object x, Object y) {
            if (x == null || y == null) {
                return 0;
            }
            if (x instanceof BigInteger || x instanceof BigDecimal || y instanceof BigInteger || y instanceof BigDecimal) {
                return this.eval(TypeCoercion.coerceToBigInteger(x), TypeCoercion.coerceToBigInteger(y));
            }
            if (x instanceof Boolean || y instanceof Boolean) {
                return this.eval(TypeCoercion.coerceToBoolean(x), TypeCoercion.coerceToBoolean(y));
            }
            return this.eval(TypeCoercion.coerceToLong(x), TypeCoercion.coerceToLong(y));
        }
    }

    public static class AND
    extends Binary {
        public AND(int pos, ELNode left, ELNode right) {
            super(9, pos, left, right);
        }

        public int precedence() {
            return 5;
        }

        public Object getValue(EvaluationContext context) {
            return this.left.getBoolean(context) && this.right.getBoolean(context);
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class OR
    extends Binary {
        public OR(int pos, ELNode left, ELNode right) {
            super(8, pos, left, right);
        }

        public int precedence() {
            return 4;
        }

        public Object getValue(EvaluationContext context) {
            return this.left.getBoolean(context) || this.right.getBoolean(context);
        }

        public Class getType(EvaluationContext context) {
            return Boolean.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class SAFEREF
    extends Binary {
        public SAFEREF(int pos, ELNode left, ELNode right) {
            super(7, pos, left, right);
        }

        public int precedence() {
            return 3;
        }

        public ELNode order() {
            if (this.precedence() >= this.left.precedence()) {
                Unary e = (Unary)this.left;
                this.left = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }

        public Object getValue(EvaluationContext context) {
            Object value = this.getLeftValue(context);
            if (value == null) {
                value = this.right.getValue(context);
            }
            return value;
        }

        private Object getLeftValue(EvaluationContext context) {
            if (this.left.op == 47) {
                ELContext elctx = context.getELContext();
                String id = ((IDENT)this.left).id;
                ValueExpression expr = context.resolveVariable(id);
                if (expr != null) {
                    return expr.getValue(elctx);
                }
                elctx.setPropertyResolved(false);
                Object value = elctx.getELResolver().getValue(elctx, null, (Object)id);
                return elctx.isPropertyResolved() ? value : null;
            }
            return this.left.getValue(context);
        }

        public Class getType(EvaluationContext context) {
            return this.right.getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class COALESCE
    extends Binary {
        public COALESCE(int pos, ELNode left, ELNode right) {
            super(6, pos, left, right);
        }

        public int precedence() {
            return 3;
        }

        public Object getValue(EvaluationContext context) {
            Object value = this.left.getValue(context);
            if (value == null) {
                value = this.right.getValue(context);
            }
            return value;
        }

        public Class getType(EvaluationContext context) {
            return this.right.getType(context);
        }

        protected Object assignop(EvaluationContext context) {
            Object value = this.left.getValue(context);
            if (value == null) {
                value = this.right.getValue(context);
                this.left.setValue(context, value);
            }
            return value;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class COND
    extends Binary {
        public ELNode cond;

        public COND(int pos, ELNode cond, ELNode left, ELNode right) {
            super(5, pos, left, right);
            this.cond = cond;
        }

        public int precedence() {
            return 2;
        }

        public ELNode order() {
            if (this.precedence() > this.cond.precedence()) {
                Unary e = (Unary)this.cond;
                this.cond = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }

        public Object getValue(EvaluationContext context) {
            Frame f = context.getFrame();
            if (this.cond.pos(f).getBoolean(context)) {
                return this.left.pos(f).getValue(context);
            }
            return this.right.pos(f).getValue(context);
        }

        public Class getType(EvaluationContext context) {
            Frame f = context.getFrame();
            if (this.cond.pos(f).getBoolean(context)) {
                return this.left.pos(f).getType(context);
            }
            return this.right.pos(f).getType(context);
        }

        public MethodInfo getMethodInfo(EvaluationContext context) {
            Frame f = context.getFrame();
            if (this.cond.pos(f).getBoolean(context)) {
                return this.left.pos(f).getMethodInfo(context);
            }
            return this.right.pos(f).getMethodInfo(context);
        }

        public Object invoke(EvaluationContext context, Closure[] args) {
            Frame f = context.getFrame();
            if (this.cond.pos(f).getBoolean(context)) {
                return this.left.pos(f).invoke(context, args);
            }
            return this.right.pos(f).invoke(context, args);
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] params) {
            Frame f = context.getFrame();
            if (this.cond.pos(f).getBoolean(context)) {
                return this.left.pos(f).invokeTail(context, call, params);
            }
            return this.right.pos(f).invokeTail(context, call, params);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class ASSIGNOP
    extends ASSIGN {
        public final Binary binary;

        public ASSIGNOP(int pos, Binary binary) {
            super(pos, binary.left, binary.right);
            this.binary = binary;
        }

        public int precedence() {
            return 1;
        }

        public Object getValue(EvaluationContext context) {
            this.binary.left = this.left;
            this.binary.right = this.right;
            return this.binary.assignop(context);
        }
    }

    public static class ASSIGN
    extends Binary {
        public ASSIGN(int pos, ELNode left, ELNode right) {
            super(0, pos, left, right);
        }

        public int precedence() {
            return 0;
        }

        public ELNode order() {
            if (this.precedence() >= this.left.precedence()) {
                Unary e = (Unary)this.left;
                this.left = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }

        public Object getValue(EvaluationContext context) {
            if (this.left.op == 55 && this.right.op == 55) {
                LIST xs = (LIST)this.left;
                LIST ys = (LIST)this.right;
                if (xs.tail == null && ys.tail == null) {
                    return xs.copyValue(context, ys.elems);
                }
            } else if (this.left.op == 56 && this.right.op == 56) {
                return ((TUPLE)this.left).copyValue(context, ((TUPLE)this.right).elems);
            }
            Object value = this.right.getValue(context);
            this.left.setValue(context, value);
            return value;
        }

        public Class getType(EvaluationContext context) {
            return this.left.getType(context);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class INFIX
    extends Binary {
        public final String name;
        public final int prec;

        public INFIX(int pos, String name, int prec, ELNode left, ELNode right) {
            super(3, pos, left, right);
            this.name = name;
            this.prec = prec;
        }

        public int precedence() {
            return this.prec >= 0 ? this.prec : -this.prec;
        }

        public ELNode order() {
            if (this.prec >= 0 ? this.prec > this.left.precedence() : -this.prec >= this.left.precedence()) {
                Unary e = (Unary)this.left;
                this.left = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }

        public Object getValue(EvaluationContext context) {
            Object rhs;
            Object lhs;
            ELContext elctx = context.getELContext();
            Object result = this.invokeOperator(elctx, this.name, lhs = this.left.getValue(context), rhs = this.right.getValue(context));
            if (result != ELUtils.NO_RESULT) {
                return result;
            }
            Object target = this.resolveTarget(context, this.name);
            if (target == null) {
                throw this.runtimeError(elctx, Resources._T("EL_UNDEFINED_IDENTIFIER", this.name));
            }
            try {
                Closure[] args = INFIX.getArgs(lhs, rhs);
                result = ELEngine.invokeTarget(elctx, target, args);
                return result;
            }
            catch (MethodNotFoundException ex) {
                throw this.methodNotFound(elctx, target, this.name, ex);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class PREFIX
    extends Unary {
        public final String name;
        public final int prec;

        public PREFIX(int pos, String name, int prec, ELNode right) {
            super(2, pos, right);
            this.name = name;
            this.prec = prec;
        }

        public int precedence() {
            return this.prec;
        }

        public Object getValue(EvaluationContext context) {
            Object result;
            ELContext elctx = context.getELContext();
            Object rhs = this.right.getValue(context);
            if (rhs != null && (result = this.invokeOperator(elctx, this.name, rhs)) != ELUtils.NO_RESULT) {
                return result;
            }
            Object target = this.resolveTarget(context, this.name);
            if (target == null) {
                throw this.runtimeError(elctx, Resources._T("EL_UNDEFINED_IDENTIFIER", this.name));
            }
            try {
                Closure[] args = PREFIX.getArgs(rhs);
                result = ELEngine.invokeTarget(elctx, target, args);
                PREFIX.releaseArgs(args);
                return result;
            }
            catch (MethodNotFoundException ex) {
                throw this.methodNotFound(elctx, target, this.name, ex);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static abstract class Binary
    extends Unary {
        public ELNode left;

        Binary(int op, int pos, ELNode left, ELNode right) {
            super(op, pos, right);
            this.left = left;
        }

        public ELNode order() {
            if (this.precedence() > this.left.precedence()) {
                Unary e = (Unary)this.left;
                this.left = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }

        public Object getValue(EvaluationContext context) {
            return this.getValue(context.getELContext(), this.left.getValue(context), this.right.getValue(context));
        }

        public Object getValue(ELContext elctx, Object lhs, Object rhs) {
            Object result;
            String opname = opIdentifiers[this.op];
            if (opname != null && (result = this.invokeOperator(elctx, opname, lhs, rhs)) != ELUtils.NO_RESULT) {
                return result;
            }
            try {
                return this.evaluate(elctx, lhs, rhs);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
        }

        protected Object invokeOperator(ELContext elctx, String opname, Object lhs, Object rhs) {
            MethodClosure method;
            Object result;
            Closure[] args;
            Closure cvar;
            ClassDefinition cdef;
            if (lhs != null) {
                if (lhs instanceof ClosureObject) {
                    cdef = ((ClosureObject)lhs).get_class();
                    cvar = cdef.getClosure(elctx, opname);
                    if (cvar != null) {
                        Closure[] args2 = Binary.getArgs(lhs, rhs);
                        Object result2 = cdef.invokeInScope(elctx, cvar, args2);
                        Binary.releaseArgs(args2);
                        return result2;
                    }
                    args = Binary.getArgs(rhs);
                    result = ((ClosureObject)lhs).invokeSpecial(elctx, opname, args);
                    Binary.releaseArgs(args);
                    if (result != ELUtils.NO_RESULT) {
                        return result;
                    }
                } else if (!(lhs instanceof Number) && (method = MethodResolver.getInstance(elctx).resolveMethod(lhs.getClass(), opname)) != null) {
                    Closure[] args3 = Binary.getArgs(rhs);
                    Object result3 = method.invoke(elctx, lhs, args3);
                    Binary.releaseArgs(args3);
                    return result3;
                }
            }
            if (rhs != null) {
                if (rhs instanceof ClosureObject) {
                    cdef = ((ClosureObject)rhs).get_class();
                    cvar = cdef.getClosure(elctx, opname);
                    if (cvar != null) {
                        args = Binary.getArgs(lhs, rhs);
                        result = cdef.invokeInScope(elctx, cvar, args);
                        Binary.releaseArgs(args);
                        return result;
                    }
                    args = Binary.getArgs(lhs);
                    result = ((ClosureObject)rhs).invokeSpecial(elctx, "?".concat(opname), args);
                    Binary.releaseArgs(args);
                    if (result != ELUtils.NO_RESULT) {
                        return result;
                    }
                } else if (!(rhs instanceof Number) && (method = MethodResolver.getInstance(elctx).resolveMethod(rhs.getClass(), "?".concat(opname))) != null) {
                    args = Binary.getArgs(lhs);
                    result = method.invoke(elctx, rhs, args);
                    Binary.releaseArgs(args);
                    return result;
                }
            }
            return ELUtils.NO_RESULT;
        }

        protected Object assignop(EvaluationContext context) {
            ELContext elctx = context.getELContext();
            Object lhs = this.left.getValue(context);
            Object rhs = this.right.getValue(context);
            String opname = opIdentifiers[this.op];
            if (lhs != null && opname != null) {
                MethodClosure method;
                if (lhs instanceof ClosureObject) {
                    Closure[] args = Binary.getArgs(rhs);
                    Object result = ((ClosureObject)lhs).invokeSpecial(elctx, opname.concat("="), args);
                    Binary.releaseArgs(args);
                    if (result != ELUtils.NO_RESULT) {
                        return result;
                    }
                } else if (!(lhs instanceof Number) && (method = MethodResolver.getInstance(elctx).resolveMethod(lhs.getClass(), opname.concat("="))) != null) {
                    Closure[] args = Binary.getArgs(rhs);
                    Object result = method.invoke(elctx, lhs, args);
                    Binary.releaseArgs(args);
                    return result;
                }
            }
            Object value = this.getValue(elctx, lhs, rhs);
            this.left.setValue(context, value);
            return value;
        }

        protected Object evaluate(ELContext elctx, Object x, Object y) {
            throw new AssertionError();
        }
    }

    public static abstract class Unary
    extends ELNode {
        public ELNode right;

        Unary(int op, int pos, ELNode right) {
            super(op, pos);
            this.right = right;
        }

        public ELNode order() {
            if (this.precedence() > this.right.precedence()) {
                Unary e = (Unary)this.right;
                this.right = e.right;
                e.right = this.order();
                return e;
            }
            return this;
        }

        public Object getValue(EvaluationContext context) {
            return this.getValue(context.getELContext(), this.right.getValue(context));
        }

        public Object getValue(ELContext elctx, Object rhs) {
            Object result;
            String opname = opIdentifiers[this.op];
            if (rhs != null && opname != null && (result = this.invokeOperator(elctx, opname, rhs)) != ELUtils.NO_RESULT) {
                return result;
            }
            try {
                return this.evaluate(elctx, rhs);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
        }

        protected Object invokeOperator(ELContext elctx, String opname, Object rhs) {
            MethodClosure method;
            if (rhs instanceof ClosureObject) {
                return ((ClosureObject)rhs).invokeSpecial(elctx, opname, ELUtils.NO_PARAMS);
            }
            if (!(rhs instanceof Number) && (method = MethodResolver.getInstance(elctx).resolveMethod(rhs.getClass(), opname)) != null) {
                return method.invoke(elctx, rhs, ELUtils.NO_PARAMS);
            }
            return ELUtils.NO_RESULT;
        }

        protected Object evaluate(ELContext elctx, Object right) {
            throw new AssertionError();
        }
    }

    public static class XFORM
    extends Binary {
        public XFORM(int pos, ELNode left, ELNode right) {
            super(40, pos, left, right);
        }

        public int precedence() {
            return 15;
        }

        public Object getValue(EvaluationContext context) {
            MethodClosure method;
            if (this.left instanceof TUPLE) {
                return this.right.invoke(context, this.getCallArgs(context));
            }
            ELContext elctx = context.getELContext();
            Object lhs = this.left.getValue(context);
            if (lhs instanceof ClosureObject) {
                Closure[] args = new Closure[]{this.right.closure(context)};
                Object result = ((ClosureObject)lhs).invokeSpecial(elctx, "->", args);
                if (result != ELUtils.NO_RESULT) {
                    return result;
                }
            } else if (lhs != null && (method = MethodResolver.getInstance(elctx).resolveMethod(lhs.getClass(), "->")) != null) {
                Closure[] args = new Closure[]{this.right.closure(context)};
                return method.invoke(elctx, lhs, args);
            }
            return this.right.invoke(context, new Closure[]{new LiteralClosure(lhs)});
        }

        public Class getType(EvaluationContext context) {
            return this.right.getMethodInfo(context).getReturnType();
        }

        public MethodInfo getMethodInfo(EvaluationContext context) {
            return this.right.getMethodInfo(context);
        }

        public Object invokeMethod(EvaluationContext context, Object[] args) {
            Closure[] extra = ELEngine.getCallArgs(args, this.getCallArgs(context));
            return this.right.invoke(context, extra);
        }

        private Closure[] getCallArgs(EvaluationContext context) {
            if (this.left instanceof TUPLE) {
                TUPLE a = (TUPLE)this.left;
                Closure[] args = new Closure[a.elems.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = a.elems[i].closure(context);
                }
                return args;
            }
            return new Closure[]{this.left.closure(context)};
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class APPLY
    extends Unary {
        public final ELNode[] args;
        public final String[] keys;

        public APPLY(int pos, ELNode right, ELNode arg) {
            this(pos, right, new ELNode[]{arg}, null);
        }

        public APPLY(int pos, ELNode right, ELNode[] args, String[] keys) {
            super(44, pos, right);
            this.args = args;
            this.keys = keys;
        }

        public int precedence() {
            return 17;
        }

        public Object getValue(EvaluationContext context) {
            return this.right.invoke(context, this.getCallArgs(context));
        }

        public Class getType(EvaluationContext context) {
            return this.right.getMethodInfo(context).getReturnType();
        }

        public MethodInfo getMethodInfo(EvaluationContext context) {
            return this.right.getMethodInfo(context);
        }

        public Object invokeMethod(EvaluationContext context, Object[] args) {
            Closure[] extra = ELEngine.getCallArgs(args, this.getCallArgs(context));
            return this.right.invoke(context, extra);
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            if (args == null) {
                return this.right.invokeTail(context, call, this.getCallArgs(context));
            }
            return super.invokeTail(context, call, args);
        }

        private Closure[] getCallArgs(EvaluationContext context) {
            int i;
            if (this.args.length == 0) {
                return ELUtils.NO_PARAMS;
            }
            Closure[] extra = new Closure[this.args.length];
            for (i = 0; i < extra.length; ++i) {
                extra[i] = this.args[i].closure(context);
            }
            if (this.keys != null) {
                for (i = 0; i < extra.length; ++i) {
                    if (this.keys[i] == null) continue;
                    extra[i] = new NamedClosure(this.keys[i], extra[i]);
                }
            }
            return extra;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class ACCESS
    extends Unary {
        public final ELNode index;

        public ACCESS(int pos, ELNode right, ELNode index) {
            super(43, pos, right);
            this.index = index;
        }

        public int precedence() {
            return 17;
        }

        public Object getValue(EvaluationContext context) {
            MethodClosure method;
            Object base = this.right.getValue(context);
            Object property = this.index.getValue(context);
            if (base == null || property == null) {
                return null;
            }
            ELContext elctx = context.getELContext();
            try {
                elctx.setPropertyResolved(false);
                Object value = elctx.getELResolver().getValue(elctx, base, property);
                if (elctx.isPropertyResolved()) {
                    return value;
                }
            }
            catch (PropertyNotFoundException ex) {
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
            if (property instanceof String && (method = this.resolveMethod(elctx, base, (String)property)) != null) {
                return new TargetMethodClosure(base, method);
            }
            throw this.propertyNotFound(elctx, base, property);
        }

        public void setValue(EvaluationContext context, Object value) {
            ELContext elctx = context.getELContext();
            Object base = this.right.getValue(context);
            Object property = this.index.getValue(context);
            if (base == null || property == null) {
                throw this.propertyNotFound(elctx, base, this.index.getValue(context));
            }
            try {
                elctx.setPropertyResolved(false);
                elctx.getELResolver().setValue(elctx, base, property, value);
                if (elctx.isPropertyResolved()) {
                    return;
                }
            }
            catch (PropertyNotFoundException ex) {
            }
            catch (PropertyNotWritableException ex) {
                throw this.propertyNotWritable(elctx, base, property);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
            throw this.propertyNotFound(elctx, base, property);
        }

        public Class getType(EvaluationContext context) {
            Object base = this.right.getValue(context);
            Object property = this.index.getValue(context);
            if (base == null || property == null) {
                return null;
            }
            ELContext elctx = context.getELContext();
            try {
                elctx.setPropertyResolved(false);
                Class type = elctx.getELResolver().getType(elctx, base, property);
                if (elctx.isPropertyResolved()) {
                    return type;
                }
            }
            catch (PropertyNotFoundException ex) {
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
            if (property instanceof String && this.resolveMethod(elctx, base, (String)property) != null) {
                return Closure.class;
            }
            throw this.propertyNotFound(elctx, base, property);
        }

        public boolean isReadOnly(EvaluationContext context) {
            Object base = this.right.getValue(context);
            Object property = this.index.getValue(context);
            if (base == null || property == null) {
                return true;
            }
            ELContext elctx = context.getELContext();
            try {
                elctx.setPropertyResolved(false);
                boolean result = elctx.getELResolver().isReadOnly(elctx, base, property);
                if (elctx.isPropertyResolved()) {
                    return result;
                }
            }
            catch (PropertyNotFoundException ex) {
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
            if (property instanceof String && this.resolveMethod(elctx, base, (String)property) != null) {
                return true;
            }
            throw this.propertyNotFound(elctx, base, property);
        }

        public MethodInfo getMethodInfo(EvaluationContext context) {
            MethodClosure method;
            ELContext elctx = context.getELContext();
            Object base = this.right.getValue(context);
            Object property = this.index.getValue(context);
            if (base == null || property == null) {
                throw this.methodNotFound(elctx, base, property, null);
            }
            String name = TypeCoercion.coerceToString(property);
            if (base == GlobalScope.SINGLETON) {
                Object target = this.getValue(context);
                return ELEngine.getTargetMethodInfo(elctx, target);
            }
            if (!(base instanceof MethodDelegate) && (method = this.resolveMethod(elctx, base, name)) != null) {
                return method.getMethodInfo(elctx);
            }
            if (base instanceof MethodResolvable) {
                return ((MethodResolvable)base).getMethodInfo(elctx, name);
            }
            throw this.methodNotFound(elctx, base, name, null);
        }

        public Object invoke(EvaluationContext context, Closure[] args) {
            Closure target;
            MethodClosure method;
            Object result;
            ELContext elctx = context.getELContext();
            Object base = this.right.getValue(context);
            Object property = this.index.getValue(context);
            if (base == null) {
                return null;
            }
            if (property == null) {
                throw this.methodNotFound(elctx, base, property, null);
            }
            String name = TypeCoercion.coerceToString(property);
            if (base == GlobalScope.SINGLETON) {
                Object target2 = this.getValue(context);
                try {
                    return ELEngine.invokeTarget(elctx, target2, args);
                }
                catch (MethodNotFoundException ex) {
                    throw this.methodNotFound(elctx, target2, name, ex);
                }
                catch (RuntimeException ex) {
                    throw this.runtimeError(elctx, ex);
                }
            }
            if (base instanceof ClosureObject && (result = ((ClosureObject)base).invoke(elctx, name, args)) != ELUtils.NO_RESULT) {
                return result;
            }
            if (!(base instanceof MethodDelegate) && (method = this.resolveMethod(elctx, base, name)) != null) {
                try {
                    return method.invoke(elctx, base, args);
                }
                catch (RuntimeException ex) {
                    throw this.runtimeError(elctx, ex);
                }
            }
            if (base instanceof MethodResolvable) {
                return ((MethodResolvable)base).invoke(elctx, name, args);
            }
            if (!(base instanceof ClosureObject) && (target = this.resolveGlobalMethod(elctx, name)) != null) {
                try {
                    Closure[] callArgs = new Closure[args.length + 1];
                    callArgs[0] = new LiteralClosure(base);
                    System.arraycopy(args, 0, callArgs, 1, args.length);
                    return ELEngine.invokeTarget(elctx, (Object)target, callArgs);
                }
                catch (MethodNotFoundException ex) {
                    throw this.methodNotFound(elctx, (Object)target, name, ex);
                }
                catch (RuntimeException ex) {
                    throw this.runtimeError(elctx, ex);
                }
            }
            throw this.methodNotFound(elctx, base, name, null);
        }

        private MethodClosure resolveMethod(ELContext elctx, Object base, String name) {
            MethodResolver resolver = MethodResolver.getInstance(elctx);
            if (base == null) {
                return resolver.resolveGlobalMethod(name);
            }
            if (base == SystemScope.SINGLETON) {
                return resolver.resolveSystemMethod(name);
            }
            if (base instanceof Class) {
                MethodClosure method = resolver.resolveStaticMethod((Class)base, name);
                if (method == null) {
                    method = resolver.resolveMethod(Class.class, name);
                }
                return method;
            }
            return resolver.resolveMethod(base.getClass(), name);
        }

        private Closure resolveGlobalMethod(ELContext elctx, String name) {
            ValueExpression expr = elctx.getVariableMapper().resolveVariable(name);
            if (expr != null && expr instanceof Closure) {
                return (Closure)expr;
            }
            return MethodResolver.getInstance(elctx).resolveGlobalMethod(name);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class IDENT
    extends ELNode {
        public final String id;

        public IDENT(int pos, String id) {
            super(47, pos);
            this.id = id;
        }

        public Object getValue(EvaluationContext context) {
            ELContext elctx = context.getELContext();
            ValueExpression expr = context.resolveVariable(this.id);
            if (expr != null) {
                return expr.getValue(elctx);
            }
            elctx.setPropertyResolved(false);
            Object value = elctx.getELResolver().getValue(elctx, null, (Object)this.id);
            if (elctx.isPropertyResolved()) {
                return value;
            }
            MethodClosure method = this.resolveGlobalMethod(context);
            if (method != null) {
                return method;
            }
            throw this.propertyNotFound(elctx, this.id, null);
        }

        public Class getType(EvaluationContext context) {
            ELContext elctx = context.getELContext();
            ValueExpression expr = context.resolveVariable(this.id);
            if (expr != null) {
                return expr.getType(elctx);
            }
            elctx.setPropertyResolved(false);
            Class type = elctx.getELResolver().getType(elctx, null, (Object)this.id);
            if (elctx.isPropertyResolved()) {
                return type;
            }
            if (this.resolveGlobalMethod(context) != null) {
                return Closure.class;
            }
            throw this.propertyNotFound(elctx, this.id, null);
        }

        public boolean isReadOnly(EvaluationContext context) {
            ELContext elctx = context.getELContext();
            ValueExpression expr = context.resolveVariable(this.id);
            if (expr != null) {
                return expr.isReadOnly(elctx);
            }
            elctx.setPropertyResolved(false);
            boolean readonly = elctx.getELResolver().isReadOnly(elctx, null, (Object)this.id);
            if (elctx.isPropertyResolved()) {
                return readonly;
            }
            return true;
        }

        public void setValue(EvaluationContext context, Object value) {
            ELContext elctx = context.getELContext();
            try {
                ValueExpression expr = context.resolveVariable(this.id);
                if (expr != null) {
                    expr.setValue(elctx, value);
                    return;
                }
                elctx.setPropertyResolved(false);
                elctx.getELResolver().setValue(elctx, null, (Object)this.id, value);
            }
            catch (PropertyNotFoundException ex) {
                throw this.propertyNotFound(elctx, this.id, null);
            }
            catch (PropertyNotWritableException ex) {
                throw this.propertyNotWritable(elctx, this.id, null);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
            if (!elctx.isPropertyResolved()) {
                throw this.propertyNotFound(elctx, this.id, null);
            }
        }

        public MethodInfo getMethodInfo(EvaluationContext context) {
            Object target = this.resolveTarget(context, this.id);
            return ELEngine.getTargetMethodInfo(context.getELContext(), target);
        }

        public Object invoke(EvaluationContext context, Closure[] args) {
            ELContext elctx = context.getELContext();
            Object target = this.resolveTarget(context, this.id);
            if (target == null) {
                throw this.runtimeError(elctx, Resources._T("EL_UNDEFINED_IDENTIFIER", this.id));
            }
            try {
                return ELEngine.invokeTarget(elctx, target, args);
            }
            catch (MethodNotFoundException ex) {
                throw this.methodNotFound(elctx, target, this.id, ex);
            }
            catch (RuntimeException ex) {
                throw this.runtimeError(elctx, ex);
            }
        }

        boolean invokeTail(EvaluationContext context, TailCall call, Closure[] args) {
            if (args != null && context.resolveVariable(this.id) == call) {
                call.args = args;
                return true;
            }
            return super.invokeTail(context, call, args);
        }

        Closure closure(EvaluationContext context) {
            return new VarClosure(context, this);
        }

        private MethodClosure resolveGlobalMethod(EvaluationContext context) {
            return MethodResolver.getInstance(context.getELContext()).resolveGlobalMethod(context.getFunctionMapper(), this.id);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class UNDEF
    extends ELNode {
        public final String id;

        public UNDEF(int pos, String id) {
            super(96, pos);
            this.id = id;
        }

        public Object getValue(EvaluationContext context) {
            context.setVariable(this.id, null);
            return null;
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class CLASSDEF
    extends ELNode {
        public final String file;
        public final String id;
        public final String base;
        public final String[] ifaces;
        public final DEFINE[] vars;
        public final DEFINE[] cvars;
        public final DEFINE[] ivars;

        public CLASSDEF(int pos, String file, String id, String base, String[] ifaces, DEFINE[] vars, DEFINE[] cvars, DEFINE[] ivars) {
            super(93, pos);
            this.file = file;
            this.id = id;
            this.base = base;
            this.ifaces = ifaces;
            this.vars = vars;
            this.cvars = cvars;
            this.ivars = ivars;
        }

        public CLASSDEF(int pos, String file, String id, String base, String[] ifaces, DEFINE[] vars, DEFINE[] body) {
            super(93, pos);
            this.file = file;
            this.id = id;
            this.base = base;
            this.ifaces = ifaces;
            this.vars = vars;
            ArrayList<DEFINE> cvs = new ArrayList<DEFINE>();
            ArrayList ivs = new ArrayList();
            for (DEFINE def : body) {
                (CLASSDEF.isStatic(def) ? cvs : ivs).add(def);
            }
            this.cvars = cvs.toArray(new DEFINE[cvs.size()]);
            this.ivars = ivs.toArray(new DEFINE[ivs.size()]);
        }

        private static boolean isStatic(DEFINE def) {
            return def.meta != null && (def.meta.modifiers & 8) != 0;
        }

        public Object getValue(EvaluationContext context) {
            return new ClassDefinition(context, this);
        }

        public Class getType(EvaluationContext context) {
            return ClassDefinition.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class DEFINE
    extends ELNode
    implements Pattern {
        public final String id;
        public final String type;
        public final METASET meta;
        public final ELNode expr;
        public final boolean immediate;

        public DEFINE(int pos, String id, String type) {
            this(pos, id, type, null, null, true);
        }

        public DEFINE(int pos, String id, String type, METASET meta, ELNode expr, boolean immediate) {
            super(92, pos);
            this.id = id;
            this.type = type;
            this.meta = meta;
            this.expr = expr;
            this.immediate = immediate;
        }

        public Object getValue(EvaluationContext context) {
            context.setVariable(this.id, this.defineClosure(context));
            return null;
        }

        public Closure defineClosure(EvaluationContext context) {
            Closure closure = this.expr == null ? TypedClosure.make(context, this.type, null, false) : (this.immediate ? TypedClosure.make(context, this.type, this.expr.getValue(context), false) : TypedClosure.make(context, this.type, new EvalClosure(context, this.expr)));
            if (this.meta != null) {
                closure.setMetaData(this.meta.getMetaData(context));
            }
            return closure;
        }

        public Closure defineClosure(EvaluationContext context, Object value) {
            Closure closure = TypedClosure.make(context, this.type, value, false);
            if (this.meta != null) {
                closure.setMetaData(this.meta.getMetaData(context));
            }
            return closure;
        }

        public Class getType(EvaluationContext context) {
            return null;
        }

        public boolean matches(EvaluationContext context, Object value) {
            if (this.type != null && !TypedClosure.typecheck(context, this.type, value)) {
                return false;
            }
            if (this.expr != null && !((Pattern)((Object)this.expr)).matches(context, value)) {
                return false;
            }
            if ("_".equals(this.id)) {
                return true;
            }
            ValueExpression ve = context.resolveLocalVariable(this.id);
            if (ve != null) {
                Object bound = ve.getValue(context.getELContext());
                return value == bound || value != null && value.equals(bound);
            }
            context.setVariable(this.id, TypedClosure.make(context, this.type, value, false));
            return true;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VarArgList
    extends AbstractList<Object> {
        private ELContext context;
        private Closure[] args;
        private int begin;

        public VarArgList(ELContext context, Closure[] args, int begin) {
            this.context = context;
            this.args = args;
            this.begin = begin;
        }

        public void force(ELContext context) {
            for (int i = this.begin; i < this.args.length; ++i) {
                this.args[i].getValue(context);
            }
        }

        @Override
        public int size() {
            return this.args.length - this.begin;
        }

        @Override
        public Object get(int index) {
            return this.args[index + this.begin].getValue(this.context);
        }

        @Override
        public Object set(int index, Object element) {
            Object oldValue = this.args[index += this.begin].getValue(this.context);
            this.args[index].setValue(this.context, element);
            return oldValue;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int i = this.begin; i < this.args.length; ++i) {
                    if (null != this.args[i].getValue(this.context)) continue;
                    return i;
                }
            } else {
                for (int i = this.begin; i < this.args.length; ++i) {
                    if (!o.equals(this.args[i].getValue(this.context))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }

    public static class BLOCK
    extends LAMBDA {
        public BLOCK(int pos, String file, ELNode body) {
            super(pos, file, new DEFINE[0], body);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(EvaluationContext context, Closure[] args) {
            ELContext elctx = context.getELContext();
            Frame frame = StackTrace.addFrame(elctx, this.name, this.file, this.pos);
            for (Closure c : args) {
                c.getValue(elctx);
            }
            try {
                EvaluationContext env = context.pushContext();
                if (args.length == 1) {
                    env.setVariable("$", args[0]);
                } else if (args.length > 1) {
                    env.setVariable("$", new LiteralClosure(new VarArgList(elctx, args, 0)));
                }
                Object object = this.body.pos(frame).getValue(env);
                return object;
            }
            catch (Control.Return ret) {
                Object object = ret.getResult();
                return object;
            }
            finally {
                StackTrace.removeFrame(elctx);
            }
        }
    }

    public static class LAMBDA
    extends ELNode {
        public final String file;
        public final String name;
        public final String rtype;
        public final DEFINE[] vars;
        public final boolean varargs;
        public final ELNode body;
        private boolean dvals;

        public LAMBDA(int pos, String file, DEFINE[] vars, ELNode body) {
            this(pos, file, null, null, vars, false, body);
        }

        public LAMBDA(int pos, String file, String name, String rtype, DEFINE[] vars, boolean varargs, ELNode body) {
            super(60, pos);
            this.file = file;
            this.name = name;
            this.rtype = rtype;
            this.vars = vars;
            this.varargs = varargs;
            this.body = body;
            for (DEFINE var : vars) {
                if (var.expr == null) continue;
                this.dvals = true;
                break;
            }
        }

        public Object getValue(EvaluationContext context) {
            return new Procedure(context, this);
        }

        public Class getType(EvaluationContext context) {
            return Procedure.class;
        }

        public MethodInfo getMethodInfo(EvaluationContext context) {
            Object cls;
            Class returnType = Object.class;
            if (this.rtype != null && (cls = ELEngine.resolveClass(context, this.rtype)) instanceof Class) {
                returnType = (Class)cls;
            }
            Class[] paramTypes = new Class[this.vars.length];
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i].type != null) {
                    Object cls2 = ELEngine.resolveClass(context, this.vars[i].type);
                    if (cls2 instanceof Class) {
                        paramTypes[i] = (Class)cls2;
                        continue;
                    }
                    paramTypes[i] = Object.class;
                    continue;
                }
                paramTypes[i] = Object.class;
            }
            return new MethodInfo(this.name, returnType, paramTypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(EvaluationContext context, Closure[] args) {
            if (this.body == null) {
                throw this.runtimeError(context.getELContext(), Resources._T("EL_INVOKE_ABSTRACT_METHOD"));
            }
            Frame frame = StackTrace.addFrame(context.getELContext(), this.name, this.file, this.pos);
            try {
                EvaluationContext env;
                TailCall call = new TailCall(context, this, args);
                do {
                    env = context.pushContext();
                    this.init_call(env, call);
                } while (this.body.pos(frame).invokeTail(env, call, null));
                Object object = this.cast_result(context, call.result);
                return object;
            }
            catch (Control.Return ret) {
                Object object = this.cast_result(context, ret.getResult());
                return object;
            }
            finally {
                StackTrace.removeFrame(context.getELContext());
            }
        }

        private void init_call(EvaluationContext env, TailCall call) {
            ELContext elctx = env.getELContext();
            Closure[] args = this.copyCallArgs(env, call.args);
            call.args = null;
            for (int i = 0; i < args.length; ++i) {
                Object value;
                DEFINE var = this.vars[i];
                if (var.type != null) {
                    args[i] = TypedClosure.make(env, var.type, args[i]);
                }
                if (var.immediate && (value = args[i].getValue(elctx)) instanceof VarArgList) {
                    ((VarArgList)value).force(elctx);
                }
                env.setVariable(var.id, args[i]);
            }
            if (this.name != null) {
                env.setVariable(this.name, call);
            }
        }

        private Closure[] copyCallArgs(EvaluationContext context, Closure[] args) {
            ELContext elctx = context.getELContext();
            int argc = args.length;
            int nvars = this.vars.length;
            Closure[] xargs = null;
            if (argc < nvars && this.dvals) {
                xargs = new Closure[nvars];
            } else if (this.varargs ? argc < nvars - 1 : argc != nvars) {
                throw this.runtimeError(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", this.name, nvars, argc));
            }
            for (int i = 0; i < argc; ++i) {
                if (!(args[i] instanceof NamedClosure)) continue;
                NamedClosure c = (NamedClosure)args[i];
                int j = this.indexOfVar(c.name());
                if (j == -1) {
                    throw this.runtimeError(elctx, Resources._T("EL_UNKNOWN_ARG_NAME", c.name()));
                }
                if (xargs == null) {
                    xargs = new Closure[argc];
                }
                xargs[j] = c.getDelegate();
            }
            if (xargs != null) {
                int j = 0;
                for (int i = 0; i < argc; ++i) {
                    if (args[i] instanceof NamedClosure) continue;
                    while (xargs[j] != null) {
                        ++j;
                    }
                    xargs[j++] = args[i];
                }
                args = xargs;
                argc = xargs.length;
                while (j < argc) {
                    if (args[j] == null) {
                        if (this.vars[j].expr == null) {
                            throw this.runtimeError(elctx, Resources._T("EL_MISSING_ARG_VALUE", this.vars[j].id));
                        }
                        args[j] = this.vars[j].expr.closure(context);
                    }
                    ++j;
                }
            }
            if (this.varargs) {
                Object lastArg;
                assert (argc >= --nvars);
                Object object = lastArg = argc == nvars + 1 ? args[nvars].getValue(elctx) : null;
                if (lastArg == null || !(lastArg instanceof VarArgList)) {
                    Closure[] actual = new Closure[nvars + 1];
                    System.arraycopy(args, 0, actual, 0, nvars);
                    actual[nvars] = new LiteralClosure(new VarArgList(elctx, args, nvars));
                    args = actual;
                }
            }
            return args;
        }

        private int indexOfVar(String name) {
            int nvars = this.vars.length - (this.varargs ? 1 : 0);
            for (int i = 0; i < nvars; ++i) {
                if (!name.equals(this.vars[i].id)) continue;
                return i;
            }
            return -1;
        }

        Object cast_result(EvaluationContext ctx, Object res) {
            if (this.rtype == null) {
                return res;
            }
            return TypedClosure.typecast(ctx, this.rtype, res);
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class Composite
    extends ELNode {
        public final ELNode[] elems;

        public Composite(int pos, ELNode[] elems) {
            super(41, pos);
            this.elems = elems;
        }

        public Object getValue(EvaluationContext context) {
            StringBuilder buf = new StringBuilder();
            for (ELNode e : this.elems) {
                Object v = e.getValue(context);
                buf.append(TypeCoercion.coerceToString(v));
            }
            return buf.toString();
        }

        public Class getType(EvaluationContext context) {
            return String.class;
        }

        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    static class TailCall
    extends Procedure {
        Closure[] args;
        Object result;

        TailCall(EvaluationContext context, LAMBDA node, Closure[] args) {
            super(context, node);
            this.args = args;
        }
    }

    public static interface Pattern {
        public boolean matches(EvaluationContext var1, Object var2);
    }
}

