/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;
import org.operamasks.el.parser.Position;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLParser {
    private Parser s;
    private char next;
    private static final int ROOT = 0;
    private static final int TAG = 1;
    private static final int TEXT = 2;

    XMLParser(Parser s) {
        this.s = s;
    }

    ELNode parse() {
        RootNode root = new RootNode(this.s.pos);
        this.next = (char)60;
        this.parse(root);
        this.s.scan();
        return ((Node)root).transform();
    }

    private void parse(Node body) {
        int state = 62;
        int pos = this.s.pos;
        StringBuilder textBuf = new StringBuilder();
        while (true) {
            switch (state) {
                case 62: {
                    textBuf.setLength(0);
                    state = 120;
                    pos = this.s.pos;
                }
                case 120: {
                    if (this.next == '<') {
                        state = 60;
                        pos = this.s.pos;
                        break;
                    }
                    textBuf.append(this.next);
                    break;
                }
                case 60: {
                    if (this.next == '/') {
                        state = 47;
                        break;
                    }
                    if (this.next == '!') {
                        state = 33;
                        break;
                    }
                    this.processTemplateText(pos, textBuf.toString(), body);
                    if (this.parseTag(pos, this.scanQName(pos), body)) {
                        return;
                    }
                    state = 62;
                    break;
                }
                case 47: {
                    this.processTemplateText(pos, textBuf.toString(), body);
                    this.parseCloseTag(pos, this.scanQName(pos), body);
                    return;
                }
                case 33: {
                    if (this.next == '-') {
                        state = 45;
                        break;
                    }
                    textBuf.append("<!");
                    state = 120;
                    break;
                }
                case 45: {
                    if (this.next == '-') {
                        this.next = this.read();
                        this.readToMatch("-->");
                        state = 120;
                        break;
                    }
                    textBuf.append("<!-");
                    state = 120;
                }
            }
            this.next = this.read();
        }
    }

    private void processTemplateText(int pos, String text, Node body) {
        if ((text = text.trim()).length() != 0) {
            ELNode node = this.s.parseEmbedExpression(pos, text);
            if (node instanceof ELNode.Composite) {
                for (ELNode e : ((ELNode.Composite)node).elems) {
                    body.append(new TextNode(e.pos, e));
                }
            } else {
                body.append(new TextNode(node.pos, node));
            }
        }
    }

    private boolean parseTag(int pos, String tag, Node body) {
        LinkedHashMap<String, ELNode> atts = null;
        boolean endSlash = false;
        if (this.next == '/') {
            endSlash = true;
            this.next = this.read();
            if (this.next != '>') {
                throw this.s.parseError(pos, Resources._T("XML_NO_GT_AFTER_SLASH"));
            }
        } else if (this.next != '>') {
            atts = new LinkedHashMap<String, ELNode>();
            endSlash = this.scanNameValuePairs(atts);
            if (atts.isEmpty()) {
                atts = null;
            }
        }
        TagNode node = new TagNode(pos);
        node.name = tag;
        node.attributes = atts;
        body.append(node);
        if (!endSlash) {
            this.next = this.read();
            this.parse(node);
        }
        return body.type == 0;
    }

    private void parseCloseTag(int pos, String tag, Node body) {
        if (this.next != '>') {
            throw this.s.parseError(pos, Resources._T("XML_NO_GT_IN_CLOSE_TAG", tag));
        }
        if (body == null || body.type == 0) {
            throw this.s.parseError(pos, Resources._T("XML_NO_START_TAG", tag));
        }
        if (!tag.equals(((TagNode)body).name)) {
            throw this.s.parseError(pos, Resources._T("XML_CLOSE_TAG_NOT_MATCH", tag, ((TagNode)body).name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String scanQName(int pos) {
        StringBuilder buf = new StringBuilder();
        if (this.next == '$') {
            this.next = this.read();
            if (!Character.isJavaIdentifierStart(this.next)) throw this.s.parseError(pos, Resources._T("XML_ILLEGAL_NAME_CHAR", Character.valueOf(this.next)));
            buf.append("$");
            while (Character.isJavaIdentifierPart(this.next)) {
                buf.append(this.next);
                this.next = this.read();
            }
            return buf.toString();
        } else {
            if (!Character.isLetter(this.next) && this.next != ':' && this.next != '_') throw this.s.parseError(pos, Resources._T("XML_ILLEGAL_NAME_CHAR", Character.valueOf(this.next)));
            while (Character.isLetterOrDigit(this.next) || this.next == '.' || this.next == '-' || this.next == '_' || this.next == ':') {
                buf.append(this.next);
                this.next = this.read();
            }
        }
        return buf.toString();
    }

    private boolean scanNameValuePairs(Map<String, ELNode> table) {
        while (true) {
            int pos = this.s.pos;
            while (Character.isWhitespace(this.next)) {
                pos = this.s.pos;
                this.next = this.read();
            }
            if (this.next == '>') {
                return false;
            }
            if (this.next == '/') {
                this.next = this.read();
                if (this.next == '>') {
                    return true;
                }
                throw this.s.parseError(pos, Resources._T("XML_NO_GT_AFTER_SLASH"));
            }
            String name = this.scanQName(pos);
            this.scanEqualSign(pos);
            ELNode value = this.scanValue();
            if (table.containsKey(name)) {
                throw this.s.parseError(pos, Resources._T("XML_DUPLICATE_ATTRIBUTE", name));
            }
            table.put(name, value);
        }
    }

    private void scanEqualSign(int pos) {
        boolean seenEqualSign = false;
        while (Character.isWhitespace(this.next) || this.next == '=') {
            if (this.next == '=') {
                if (seenEqualSign) break;
                seenEqualSign = true;
            }
            this.next = this.read();
        }
        if (!seenEqualSign) {
            throw this.s.parseError(pos, Resources._T("XML_NO_EQ_IN_NAME_VALUE_PAIR"));
        }
    }

    private ELNode scanValue() {
        int p = this.s.pos;
        char q = this.next;
        StringBuilder buf = new StringBuilder();
        if (q != '\"' && q != '\'') {
            throw this.s.parseError(p, Resources._T("XML_UNQUOTED_VALUE"));
        }
        while (true) {
            this.next = this.read();
            if (this.next == q) break;
            buf.append(this.next);
        }
        this.next = this.read();
        if (q == '\"') {
            return this.s.parseEmbedExpression(p, buf.toString());
        }
        return new ELNode.STRINGVAL(p, buf.toString());
    }

    private char read() {
        int c = this.s.ch;
        if (c == -1) {
            throw this.s.incomplete(Resources._T("XML_UNEXPECTED_EOI"));
        }
        if (c == 13) {
            if (this.s.nextchar() == 10) {
                c = 10;
                this.s.nextchar();
            }
            this.s.pos = Position.nextline(this.s.pos);
        } else if (c == 10) {
            this.s.nextchar();
            this.s.pos = Position.nextline(this.s.pos);
        } else {
            this.s.nextchar();
        }
        return (char)c;
    }

    private void readToMatch(String match) {
        int state = 0;
        while (true) {
            if (this.next == match.charAt(state)) {
                if (++state == match.length()) {
                    return;
                }
                this.next = this.read();
                continue;
            }
            if (state > 0) {
                state -= XMLParser.matchPrefix(match, state, this.next);
                continue;
            }
            this.next = this.read();
        }
    }

    private static int matchPrefix(String match, int length, char nextchar) {
        int prefix;
        for (prefix = 1; !(prefix >= length || match.substring(prefix, length).equals(match.substring(0, length - prefix)) && nextchar == match.charAt(length - prefix)); ++prefix) {
        }
        return prefix;
    }

    static class TextNode
    extends Node {
        ELNode content;

        TextNode(int pos, ELNode content) {
            super(2, pos);
            this.content = content;
        }

        ELNode transform() {
            return this.content;
        }
    }

    static class TagNode
    extends Node {
        String name;
        Map<String, ELNode> attributes;

        TagNode(int pos) {
            super(1, pos);
        }

        ELNode transform() {
            int i;
            int size;
            ELNode[] keys = null;
            ELNode[] values = null;
            ELNode[] kids = null;
            ELNode tag = this.name.startsWith("$") ? new ELNode.IDENT(this.pos, this.name.substring(1)) : new ELNode.STRINGVAL(this.pos, this.name);
            if (this.attributes != null) {
                size = this.attributes.size();
                keys = new ELNode[size];
                values = new ELNode[size];
                i = 0;
                for (Map.Entry<String, ELNode> e : this.attributes.entrySet()) {
                    String key = e.getKey();
                    ELNode value = e.getValue();
                    keys[i] = key.startsWith("$") ? new ELNode.IDENT(value.pos, key.substring(1)) : new ELNode.STRINGVAL(value.pos, key);
                    values[i] = value;
                    ++i;
                }
            }
            if (!this.children.isEmpty()) {
                size = this.children.size();
                kids = new ELNode[size];
                for (i = 0; i < size; ++i) {
                    kids[i] = ((Node)this.children.get(i)).transform();
                }
            }
            return new ELNode.XML(this.pos, tag, keys, values, kids);
        }
    }

    static class RootNode
    extends Node {
        RootNode(int pos) {
            super(0, pos);
        }

        ELNode transform() {
            assert (this.children.size() == 1);
            return ((Node)this.children.get(0)).transform();
        }
    }

    static abstract class Node {
        int type;
        int pos;
        ArrayList<Node> children = new ArrayList();

        Node(int type, int pos) {
            this.type = type;
            this.pos = pos;
        }

        void append(Node node) {
            this.children.add(node);
        }

        abstract ELNode transform();
    }
}

