/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Range;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListELResolver
extends ELResolver {
    private boolean isReadOnly;
    private static Class<?> theUnmodifiableListClass = Collections.unmodifiableList(new ArrayList()).getClass();

    public ListELResolver() {
        this.isReadOnly = false;
    }

    public ListELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base instanceof List) {
            context.setPropertyResolved(true);
            if (property instanceof Range) {
                return List.class;
            }
            if ("length".equals(property) || "size".equals(property)) {
                return Integer.class;
            }
            return Object.class;
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (!(base instanceof List)) {
            return null;
        }
        List list = (List)base;
        Object result = null;
        if (property instanceof String) {
            if ("length".equals(property) || "size".equals(property)) {
                result = list.size();
                context.setPropertyResolved(true);
            } else if ("first".equals(property)) {
                result = list.isEmpty() ? null : list.get(0);
                context.setPropertyResolved(true);
            } else if ("last".equals(property)) {
                result = list.isEmpty() ? null : list.get(list.size() - 1);
                context.setPropertyResolved(true);
            } else if ("rest".equals(property)) {
                result = list.isEmpty() ? list : list.subList(1, list.size());
                context.setPropertyResolved(true);
            }
        } else if (property instanceof Range) {
            result = this.extractRange(list, (Range)property);
            context.setPropertyResolved(true);
        } else if (property instanceof Number) {
            try {
                result = list.get(((Number)property).intValue());
            }
            catch (IndexOutOfBoundsException ex) {
                result = null;
            }
            context.setPropertyResolved(true);
        } else if (property instanceof List && ((List)property).isEmpty()) {
            result = Collections.EMPTY_LIST;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (!(base instanceof List)) {
            return;
        }
        if (this.isReadOnly || base.getClass() == theUnmodifiableListClass) {
            throw new PropertyNotWritableException();
        }
        List list = (List)base;
        if (property instanceof String) {
            if ("length".equals(property) || "size".equals(property) || "rest".equals(property)) {
                throw new PropertyNotWritableException(property.toString());
            }
            if ("first".equals(property)) {
                this.set(list, 0, value);
                context.setPropertyResolved(true);
            } else if ("last".equals(property)) {
                this.set(list, list.size() - 1, value);
                context.setPropertyResolved(true);
            }
        } else if (property instanceof Range) {
            if (value != null && value.getClass().isArray()) {
                this.copyRangeWithArray(list, (Range)property, value);
            } else if (value instanceof Collection) {
                this.copyRangeWithCollection(list, (Range)property, (Collection)value);
            } else {
                this.copyRangeWithSingle(list, (Range)property, value);
            }
            context.setPropertyResolved(true);
        } else if (property instanceof Number) {
            int index = ((Number)property).intValue();
            this.set(list, index, value);
            context.setPropertyResolved(true);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof List) {
            context.setPropertyResolved(true);
            return this.isReadOnly || base.getClass() == theUnmodifiableListClass;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof List) {
            return Integer.class;
        }
        return null;
    }

    private void set(List base, int index, Object value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index:" + index);
        }
        if (index < base.size()) {
            base.set(index, value);
        } else if (value != null) {
            if (base instanceof ArrayList) {
                ((ArrayList)base).ensureCapacity(index + 1);
            }
            while (base.size() < index) {
                base.add(null);
            }
            base.add(value);
        }
    }

    private List extractRange(List base, Range range) {
        int size;
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = base.size();
        if (range.isUnbound()) {
            long l = end = step > 0L ? length : 0L;
        }
        if (begin < 0L && end < 0L || begin >= length && end >= length) {
            return new ArrayList();
        }
        if (step > 0L) {
            begin = begin < 0L ? 0L : begin;
            long l = end = end >= length ? length - 1L : end;
            assert (begin < length && end < length && end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            end = end < 0L ? 0L : end;
            long l = begin = begin >= length ? length - 1L : begin;
            assert (begin < length && end < length && begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        ArrayList list = new ArrayList(size);
        int i = 0;
        while (i < size) {
            list.add(base.get((int)begin));
            ++i;
            begin += step;
        }
        return list;
    }

    private void copyRangeWithArray(List base, Range range, Object value) {
        int size;
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = base.size();
        if (range.isUnbound()) {
            if (step > 0L) {
                if (begin >= length) {
                    return;
                }
                end = length - 1L;
            } else {
                if (begin < 0L) {
                    return;
                }
                end = 0L;
            }
        } else if (begin < 0L && end < 0L) {
            return;
        }
        if (step > 0L) {
            long l = begin = begin < 0L ? 0L : begin;
            assert (end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            long l = end = end < 0L ? 0L : end;
            assert (begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        int value_size = Array.getLength(value);
        if (size > value_size) {
            size = value_size;
        }
        int i = 0;
        while (i < size) {
            this.set(base, (int)begin, Array.get(value, i));
            ++i;
            begin += step;
        }
    }

    private void copyRangeWithCollection(List base, Range range, Collection value) {
        int size;
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = base.size();
        if (range.isUnbound()) {
            if (step > 0L) {
                if (begin >= length) {
                    return;
                }
                end = length - 1L;
            } else {
                if (begin < 0L) {
                    return;
                }
                end = 0L;
            }
        } else if (begin < 0L && end < 0L) {
            return;
        }
        if (step > 0L) {
            long l = begin = begin < 0L ? 0L : begin;
            assert (end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            long l = end = end < 0L ? 0L : end;
            assert (begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        Iterator it = value.iterator();
        int i = 0;
        while (i < size && it.hasNext()) {
            this.set(base, (int)begin, it.next());
            ++i;
            begin += step;
        }
    }

    private void copyRangeWithSingle(List base, Range range, Object value) {
        int size;
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = base.size();
        if (range.isUnbound()) {
            if (step > 0L) {
                if (begin >= length) {
                    return;
                }
                end = length - 1L;
            } else {
                if (begin < 0L) {
                    return;
                }
                end = 0L;
            }
        } else if (begin < 0L && end < 0L) {
            return;
        }
        if (step > 0L) {
            long l = begin = begin < 0L ? 0L : begin;
            assert (end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            long l = end = end < 0L ? 0L : end;
            assert (begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        int i = 0;
        while (i < size) {
            this.set(base, (int)begin, value);
            ++i;
            begin += step;
        }
    }
}

