/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Builtin;
import elite.lang.Closure;
import elite.lang.annotation.Alias;
import elite.lang.annotation.Expando;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.resolver.ExpandoMethodClosure;
import org.operamasks.el.resolver.JavaMethodClosure;
import org.operamasks.el.resolver.SingleMethodClosure;
import org.operamasks.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodResolver {
    private StaticMethodMap global = new StaticMethodMap();
    private Set<Class> imported = new HashSet<Class>();
    private static StaticMethodMap builtin = new StaticMethodMap();
    private SimpleCache<Class, MethodMap> cache = SimpleCache.make(200);
    private SimpleCache<Class, MethodMap> pcache = SimpleCache.make(200);
    private SimpleCache<Class, MethodMap> scache = SimpleCache.make(200);

    public static MethodResolver getInstance(ELContext context) {
        MethodResolver resolver = (MethodResolver)context.getContext(MethodResolver.class);
        if (resolver == null) {
            resolver = new MethodResolver();
            context.putContext(MethodResolver.class, (Object)resolver);
        }
        return resolver;
    }

    public void addModule(ELContext elctx, Class base, String prefix) {
        if (!this.imported.contains(base)) {
            try {
                Method init = base.getMethod("__init__", ELContext.class);
                if (Modifier.isStatic(init.getModifiers())) {
                    init.invoke(null, elctx);
                }
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Exception ex) {
                throw new EvaluationException(elctx, ex);
            }
            this.imported.add(base);
        }
        this.global.addAllStatic(base, prefix);
    }

    public void addGlobalMethods(Class base) {
        this.global.addAllStatic(base, null);
    }

    public void addGlobalMethod(Method method) {
        this.global.add(method, null);
    }

    public void attachMethod(Class target, String name, Closure closure) {
        this.global.expandoMap.add(new ExpandoMethodClosure(name, target, closure));
    }

    public MethodClosure resolveMethod(Class base, String name) {
        return this.getMethodClosure(base, name);
    }

    public MethodClosure resolveProtectedMethod(Class base, String name) {
        return this.getProtectedMethodClosure(base, name);
    }

    public MethodClosure resolveStaticMethod(Class base, String name) {
        return this.getStaticMethodClosure(base, name);
    }

    public MethodClosure resolveGlobalMethod(String name) {
        MethodClosure closure = this.global.get(name);
        if (closure == null) {
            closure = builtin.get(name);
        }
        return closure;
    }

    public MethodClosure resolveGlobalMethod(FunctionMapper fnm, String name) {
        MethodClosure closure = this.global.get(name);
        if (closure == null && (closure = builtin.get(name)) == null && fnm != null) {
            closure = this.resolveFunctionMethod(fnm, name);
        }
        return closure;
    }

    public MethodClosure resolveFunctionMethod(FunctionMapper fnm, String name) {
        String localName;
        if (fnm == null) {
            return null;
        }
        int sep = name.indexOf(58);
        if (sep == -1) {
            return null;
        }
        String prefix = name.substring(0, sep);
        Method method = fnm.resolveFunction(prefix, localName = name.substring(sep + 1));
        return method == null ? null : new SingleMethodClosure(method);
    }

    public MethodClosure resolveSystemMethod(String name) {
        return builtin.get(name);
    }

    public List<String> listGlobalMethods() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.addAll(this.global.map.keySet());
        return lst;
    }

    public List<String> listSystemMethods() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.addAll(MethodResolver.builtin.map.keySet());
        return lst;
    }

    private MethodClosure getMethodClosure(Class baseClass, String name) {
        MethodClosure c = this.global.getExpandoMethod(baseClass, name);
        if (c != null) {
            return c;
        }
        MethodMap mmap = this.cache.get(baseClass);
        if (mmap == null) {
            mmap = new MethodMap();
            mmap.addAll(baseClass);
            this.cache.put(baseClass, mmap);
        }
        if ((c = mmap.get(name)) != null) {
            return c;
        }
        return builtin.getExpandoMethod(baseClass, name);
    }

    private MethodClosure getProtectedMethodClosure(Class baseClass, String name) {
        MethodMap mmap = this.pcache.get(baseClass);
        if (mmap == null) {
            mmap = new MethodMap();
            mmap.addAllProtected(baseClass);
            this.pcache.put(baseClass, mmap);
        }
        return mmap.get(name);
    }

    private MethodClosure getStaticMethodClosure(Class baseClass, String name) {
        MethodMap smap = this.scache.get(baseClass);
        if (smap == null) {
            smap = new MethodMap();
            smap.addAllStatic(baseClass, null);
            this.scache.put(baseClass, smap);
        }
        return smap.get(name);
    }

    static {
        builtin.addAllStatic(Builtin.class, null);
    }

    static class ExpandoMethodMap {
        final Map<String, SortedSet<ExpandoMethodClosure>> map = new HashMap<String, SortedSet<ExpandoMethodClosure>>();
        private static Comparator<ExpandoMethodClosure> order = new Comparator<ExpandoMethodClosure>(){

            @Override
            public int compare(ExpandoMethodClosure m1, ExpandoMethodClosure m2) {
                Class<?> c2;
                Class<?> c1 = m1.getTarget();
                if (c1 == (c2 = m2.getTarget())) {
                    return 0;
                }
                return c1.isAssignableFrom(c2) ? 1 : -1;
            }
        };

        ExpandoMethodMap() {
        }

        public void add(Method method) {
            Class<?>[] params;
            String name = method.getAnnotation(Expando.class).name();
            if (name.length() == 0) {
                name = method.getName();
            }
            Class<?> target = (params = method.getParameterTypes())[0] != ELContext.class ? params[0] : params[1];
            SortedSet<ExpandoMethodClosure> methods = this.map.get(name);
            if (methods == null) {
                methods = new TreeSet<ExpandoMethodClosure>(order);
                this.map.put(name, methods);
            }
            for (ExpandoMethodClosure expando : methods) {
                if (target != expando.getTarget()) continue;
                expando.addMethod(method);
                return;
            }
            SingleMethodClosure delegate = new SingleMethodClosure(method);
            methods.add(new ExpandoMethodClosure(name, target, delegate));
        }

        public void add(ExpandoMethodClosure expando) {
            String name = expando.getName();
            SortedSet<ExpandoMethodClosure> methods = this.map.get(name);
            if (methods == null) {
                methods = new TreeSet<ExpandoMethodClosure>(order);
                this.map.put(name, methods);
            }
            methods.add(expando);
        }

        public MethodClosure get(Class cls, String name) {
            SortedSet<ExpandoMethodClosure> methods = this.map.get(name);
            if (methods != null) {
                for (ExpandoMethodClosure m : methods) {
                    if (!m.getTarget().isAssignableFrom(cls)) continue;
                    return m;
                }
            }
            return null;
        }
    }

    static class StaticMethodMap
    extends MethodMap {
        final ExpandoMethodMap expandoMap = new ExpandoMethodMap();

        StaticMethodMap() {
        }

        public void add(Method method, String prefix) {
            int mods = method.getModifiers();
            if (Modifier.isPublic(mods) && Modifier.isStatic(mods)) {
                Expando meta = method.getAnnotation(Expando.class);
                if (meta != null) {
                    this.expandoMap.add(method);
                    if (meta.global()) {
                        super.add(method, prefix);
                    }
                } else {
                    super.add(method, prefix);
                }
            }
        }

        public MethodClosure getExpandoMethod(Class baseClass, String name) {
            return this.expandoMap.get(baseClass, name);
        }
    }

    static class MethodMap {
        final Map<String, JavaMethodClosure> map = new HashMap<String, JavaMethodClosure>();

        MethodMap() {
        }

        public MethodClosure get(String name) {
            return this.map.get(name);
        }

        public void addAll(Class baseClass) {
            for (Method method : baseClass.getMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                this.add(method, null);
            }
        }

        public void addAllProtected(Class baseClass) {
            ArrayList<Method> lst = new ArrayList<Method>();
            for (Class c = baseClass; c != null; c = c.getSuperclass()) {
                for (Method method : c.getDeclaredMethods()) {
                    int mod = method.getModifiers();
                    if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod) || Modifier.isStatic(mod)) continue;
                    boolean found = false;
                    for (Method m : lst) {
                        if (!MethodMap.identical(method, m)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    lst.add(method);
                    this.add(method, null);
                }
            }
        }

        private static boolean identical(Method m1, Method m2) {
            if (!m1.getName().equals(m2.getName())) {
                return false;
            }
            return Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
        }

        public void addAllStatic(Class baseClass, String prefix) {
            for (Method method : baseClass.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                this.add(method, prefix);
            }
        }

        public void add(Method method, String prefix) {
            if (method.isAnnotationPresent(Alias.class)) {
                for (String name : method.getAnnotation(Alias.class).value()) {
                    this.add(method, name, prefix);
                }
            } else {
                String name = null;
                if (method.isAnnotationPresent(Expando.class)) {
                    name = method.getAnnotation(Expando.class).name();
                }
                if (name == null || name.length() == 0) {
                    name = method.getName();
                    if (name.startsWith("__")) {
                        return;
                    }
                    if (name.startsWith("_")) {
                        name = name.substring(1);
                    }
                }
                this.add(method, name, prefix);
            }
        }

        private void add(Method method, String name, String prefix) {
            JavaMethodClosure c;
            if (prefix != null) {
                name = prefix + ":" + name;
            }
            this.map.put(name, (c = this.map.get(name)) == null ? new SingleMethodClosure(method) : c.addMethod(method));
        }
    }
}

