/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Range;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringELResolver
extends ELResolver {
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base instanceof CharSequence && property != null) {
            if (property instanceof Range) {
                context.setPropertyResolved(true);
                return base.getClass();
            }
            if ("length".equals(property) || "size".equals(property)) {
                context.setPropertyResolved(true);
                return Integer.class;
            }
            if (property instanceof Number) {
                context.setPropertyResolved(true);
                return Character.TYPE;
            }
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base instanceof CharSequence && property != null) {
            CharSequence cs = (CharSequence)base;
            if (property instanceof Range) {
                context.setPropertyResolved(true);
                return this.getSubSequence(cs, (Range)property);
            }
            if (property instanceof String) {
                if ("length".equals(property) || "size".equals(property)) {
                    context.setPropertyResolved(true);
                    return cs.length();
                }
                if ("first".equals(property)) {
                    context.setPropertyResolved(true);
                    return Character.valueOf(cs.charAt(0));
                }
                if ("last".equals(property)) {
                    context.setPropertyResolved(true);
                    return Character.valueOf(cs.charAt(cs.length() - 1));
                }
            } else if (property instanceof Number) {
                int length = cs.length();
                int index = ((Number)property).intValue();
                if (index >= 0 && index < length) {
                    context.setPropertyResolved(true);
                    return Character.valueOf(cs.charAt(index));
                }
            } else if (property instanceof List && ((List)property).isEmpty()) {
                context.setPropertyResolved(true);
                return "";
            }
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof CharSequence && property != null) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof CharSequence) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof CharSequence) {
            return Integer.class;
        }
        return null;
    }

    private CharSequence getSubSequence(CharSequence cs, Range range) {
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = cs.length();
        if (range.isUnbound()) {
            long l = end = step > 0L ? length : 0L;
        }
        if (step < 0L || begin < 0L && end < 0L || begin >= length && end >= length) {
            return cs.subSequence(0, 0);
        }
        begin = begin < 0L ? 0L : begin;
        long l = end = end >= length ? length : end + 1L;
        assert (begin <= length && end <= length && end >= begin);
        return cs.subSequence((int)begin, (int)end);
    }
}

