/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.script;

import elite.lang.Closure;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELProgram;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.parser.ParseException;
import org.operamasks.el.parser.Parser;
import org.operamasks.el.script.ContextVariableMapper;
import org.operamasks.el.script.ELiteCompiledScript;
import org.operamasks.el.script.ELiteScriptEngineFactory;
import org.operamasks.el.script.ScriptContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ELiteScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private ELiteScriptEngineFactory factory;
    private Parser parser;
    public static final String EL_CONTEXT_KEY = ELContext.class.getName();

    ELiteScriptEngine(ELiteScriptEngineFactory factory) {
        this.factory = factory;
        this.context = new ScriptContextImpl();
    }

    @Override
    public Object get(String key) {
        if (EL_CONTEXT_KEY.equals(key)) {
            return this.getELContext(this.getContext());
        }
        return super.get(key);
    }

    @Override
    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        try {
            ELProgram program = this.parse(script);
            ELContext elctx = this.getELContext(ctx);
            String filename = (String)this.get("javax.script.filename");
            return program.execute(elctx, filename, 1);
        }
        catch (ParseException ex) {
            ScriptException ex2 = new ScriptException(ex.getMessage(), ex.getFileName(), ex.getLineNumber(), ex.getColumnNumber());
            ex2.initCause((Throwable)((Object)ex));
            ex2.setStackTrace(ex.getStackTrace());
            throw ex2;
        }
        catch (EvaluationException ex) {
            ScriptException ex2 = new ScriptException(ex.getMessage());
            ex2.initCause(ex.getCause());
            ex2.setStackTrace(ex.getStackTrace());
            throw ex2;
        }
        catch (ELException ex) {
            throw new ScriptException((Exception)((Object)ex));
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            String script = this.readScript(reader);
            return this.eval(script, context);
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        ELContext elctx = this.getELContext(this.getContext());
        ValueExpression exp = elctx.getVariableMapper().resolveVariable(name);
        if (exp instanceof Closure) {
            try {
                return ((Closure)exp).call(elctx, args);
            }
            catch (EvaluationException ex) {
                ScriptException ex2 = new ScriptException(ex.getMessage());
                ex2.initCause(ex.getCause());
                ex2.setStackTrace(ex.getStackTrace());
                throw ex2;
            }
            catch (ELException ex) {
                throw new ScriptException((Exception)((Object)ex));
            }
        }
        throw new NoSuchMethodException(name);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Object result;
        if (!(thiz instanceof ClosureObject)) {
            throw new NoSuchMethodException("no such method: " + name);
        }
        try {
            ELContext elctx = this.getELContext(this.getContext());
            ClosureObject closure = (ClosureObject)thiz;
            result = closure.invoke(elctx, name, ELEngine.getCallArgs(args));
        }
        catch (MethodNotFoundException ex) {
            throw new NoSuchMethodException("no such method: " + name);
        }
        catch (EvaluationException ex) {
            ScriptException ex2 = new ScriptException(ex.getMessage());
            ex2.initCause(ex.getCause());
            ex2.setStackTrace(ex.getStackTrace());
            throw ex2;
        }
        catch (ELException ex) {
            throw new ScriptException((Exception)((Object)ex));
        }
        if (result == ELUtils.NO_RESULT) {
            throw new NoSuchMethodException("no such method: " + name);
        }
        return result;
    }

    @Override
    public <T> T getInterface(Class<T> iface) {
        if (iface == null || !iface.isInterface()) {
            throw new IllegalArgumentException("interface expected");
        }
        return iface.cast(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new InterfaceImplementorInvocationHandler(null)));
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> iface) {
        if (thiz == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        if (iface == null || !iface.isInterface()) {
            throw new IllegalArgumentException("interface expected");
        }
        return iface.cast(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new InterfaceImplementorInvocationHandler(thiz)));
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        try {
            return new ELiteCompiledScript(this, this.parse(script));
        }
        catch (ParseException ex) {
            ScriptException ex2 = new ScriptException(ex.getMessage(), ex.getFileName(), ex.getLineNumber(), ex.getColumnNumber());
            ex2.initCause((Throwable)((Object)ex));
            ex2.setStackTrace(ex.getStackTrace());
            throw ex2;
        }
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            return this.compile(this.readScript(script));
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
    }

    ELContext getELContext(ScriptContext sctx) {
        ELContext elctx = (ELContext)sctx.getAttribute(EL_CONTEXT_KEY, 100);
        if (elctx == null) {
            ContextVariableMapper vm = new ContextVariableMapper(sctx);
            elctx = ELEngine.createELContext(vm);
            elctx.putContext(ScriptContext.class, (Object)sctx);
            sctx.setAttribute(EL_CONTEXT_KEY, elctx, 100);
            sctx.setAttribute("context", sctx, 100);
            String[] argv = (String[])sctx.getAttribute("javax.script.argv");
            if (argv != null) {
                sctx.setAttribute("ARGV", argv, 100);
            }
            this.factory.contextCreated(elctx, sctx);
        }
        return elctx;
    }

    private ELProgram parse(String script) throws ParseException {
        Parser p = new Parser(script);
        p.setFileName((String)this.get("javax.script.filename"));
        if (this.parser != null) {
            p.importSyntaxRules(this.parser);
        }
        this.parser = p;
        return p.parse();
    }

    private String readScript(Reader reader) throws IOException {
        int len;
        StringBuilder buf = new StringBuilder();
        char[] cbuf = new char[8192];
        while ((len = reader.read(cbuf)) != -1) {
            buf.append(cbuf, 0, len);
        }
        reader.close();
        return buf.toString();
    }

    private final class InterfaceImplementorInvocationHandler
    implements InvocationHandler {
        private Object thiz;
        private AccessControlContext acc;

        InterfaceImplementorInvocationHandler(Object thiz) {
            this.thiz = thiz;
            this.acc = AccessController.getContext();
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            final String name = method.getName();
            final Object[] a = args == null ? new Object[]{} : args;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (InterfaceImplementorInvocationHandler.this.thiz == null) {
                        return ELiteScriptEngine.this.invokeFunction(name, a);
                    }
                    return ELiteScriptEngine.this.invokeMethod(InterfaceImplementorInvocationHandler.this.thiz, name, a);
                }
            }, this.acc);
        }
    }
}

