/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.ELContext;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.operamasks.el.script.ELiteScriptEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELiteScriptEngineFactory
implements ScriptEngineFactory {
    private static List<String> names = new ArrayList<String>(4);
    private static List<String> mimeTypes;
    private static List<String> extensions;

    public String getName() {
        return (String)this.getParameter("javax.script.name");
    }

    @Override
    public String getEngineName() {
        return (String)this.getParameter("javax.script.engine");
    }

    @Override
    public String getEngineVersion() {
        return (String)this.getParameter("javax.script.engine_version");
    }

    @Override
    public String getLanguageName() {
        return (String)this.getParameter("javax.script.language");
    }

    @Override
    public String getLanguageVersion() {
        return (String)this.getParameter("javax.script.language_version");
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return "elite";
        }
        if (key.equals("javax.script.engine")) {
            return "ELite";
        }
        if (key.equals("javax.script.engine_version")) {
            return "0.5.0";
        }
        if (key.equals("javax.script.language")) {
            return "ELite";
        }
        if (key.equals("javax.script.language_version")) {
            return "0.5.0";
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new ELiteScriptEngine(this);
    }

    protected void contextCreated(ELContext elctx, ScriptContext sctx) {
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        String ret = obj + "." + method + "(";
        int len = args.length;
        if (len == 0) {
            ret = ret + ")";
            return ret;
        }
        for (int i = 0; i < len; ++i) {
            ret = ret + args[i];
            ret = i != len - 1 ? ret + "," : ret + ")";
        }
        return ret;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        int len = toDisplay.length();
        buf.append("print('");
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\'': {
                    buf.append("\\'");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("')");
        return buf.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        int len = statements.length;
        String ret = "";
        for (int i = 0; i < len; ++i) {
            ret = ret + statements[i] + ";";
        }
        return ret;
    }

    static {
        names.add("elite");
        names.add("ELite");
        names.add("xel");
        names.add("XEL");
        names = Collections.unmodifiableList(names);
        mimeTypes = new ArrayList<String>(0);
        mimeTypes = Collections.unmodifiableList(mimeTypes);
        extensions = new ArrayList<String>(2);
        extensions.add("elite");
        extensions.add("xel");
        extensions = Collections.unmodifiableList(extensions);
    }
}

