/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.net.sf.cglib.core;

import java.util.ArrayList;
import org.operamasks.org.objectweb.asm.ClassAdapter;
import org.operamasks.org.objectweb.asm.ClassReader;

public class ClassNameReader {
    private static final EarlyExitException EARLY_EXIT = new EarlyExitException();

    private ClassNameReader() {
    }

    public static String getClassName(ClassReader r) {
        return ClassNameReader.getClassInfo(r)[0];
    }

    public static String[] getClassInfo(ClassReader r) {
        final ArrayList array = new ArrayList();
        try {
            r.accept(new ClassAdapter(null){

                public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
                    array.add(name.replace('/', '.'));
                    if (superName != null) {
                        array.add(superName.replace('/', '.'));
                    }
                    for (int i = 0; i < interfaces.length; ++i) {
                        array.add(interfaces[i].replace('/', '.'));
                    }
                    throw EARLY_EXIT;
                }
            }, true);
        }
        catch (EarlyExitException earlyExitException) {
            // empty catch block
        }
        return array.toArray(new String[0]);
    }

    private static class EarlyExitException
    extends RuntimeException {
        private EarlyExitException() {
        }
    }
}

