/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.operamasks.org.objectweb.asm.Attribute;
import org.operamasks.org.objectweb.asm.ClassVisitor;
import org.operamasks.org.objectweb.asm.CodeVisitor;
import org.operamasks.org.objectweb.asm.Label;
import org.operamasks.org.objectweb.asm.tree.AbstractInsnNode;
import org.operamasks.org.objectweb.asm.tree.LineNumberNode;
import org.operamasks.org.objectweb.asm.tree.LocalVariableNode;
import org.operamasks.org.objectweb.asm.tree.TryCatchBlockNode;

public class MethodNode {
    public int access;
    public String name;
    public String desc;
    public final List exceptions;
    public Attribute attrs;
    public final List instructions;
    public final List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public final List localVariables;
    public final List lineNumbers;
    public Attribute codeAttrs;

    public MethodNode(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.exceptions = new ArrayList();
        this.instructions = new ArrayList();
        this.tryCatchBlocks = new ArrayList();
        this.localVariables = new ArrayList();
        this.lineNumbers = new ArrayList();
        if (exceptions != null) {
            this.exceptions.addAll(Arrays.asList(exceptions));
        }
        this.attrs = attrs;
    }

    public void accept(ClassVisitor cv) {
        String[] exceptions = new String[this.exceptions.size()];
        this.exceptions.toArray(exceptions);
        CodeVisitor mv = cv.visitMethod(this.access, this.name, this.desc, exceptions, this.attrs);
        if (mv != null && this.instructions.size() > 0) {
            int i;
            for (i = 0; i < this.instructions.size(); ++i) {
                Object insn = this.instructions.get(i);
                if (insn instanceof Label) {
                    mv.visitLabel((Label)insn);
                    continue;
                }
                ((AbstractInsnNode)insn).accept(mv);
            }
            for (i = 0; i < this.tryCatchBlocks.size(); ++i) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(i)).accept(mv);
            }
            mv.visitMaxs(this.maxStack, this.maxLocals);
            for (i = 0; i < this.localVariables.size(); ++i) {
                ((LocalVariableNode)this.localVariables.get(i)).accept(mv);
            }
            for (i = 0; i < this.lineNumbers.size(); ++i) {
                ((LineNumberNode)this.lineNumbers.get(i)).accept(mv);
            }
            Attribute attrs = this.codeAttrs;
            while (attrs != null) {
                mv.visitAttribute(attrs);
                attrs = attrs.next;
            }
        }
    }
}

