/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.org.objectweb.asm.util;

import java.util.ArrayList;
import java.util.List;
import org.operamasks.org.objectweb.asm.Attribute;
import org.operamasks.org.objectweb.asm.CodeVisitor;
import org.operamasks.org.objectweb.asm.Label;

public abstract class PrintCodeVisitor
implements CodeVisitor {
    protected final List text;
    protected final StringBuffer buf = new StringBuffer();
    public static final String[] OPCODES = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "BIPUSH", "SIPUSH", "LDC", null, null, "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", null, "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", null, "MULTIANEWARRAY", "IFNULL", "IFNONNULL", null, null};

    protected PrintCodeVisitor() {
        this.text = new ArrayList();
    }

    public void visitInsn(int opcode) {
        this.buf.setLength(0);
        this.printInsn(opcode);
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int opcode, int operand) {
        this.buf.setLength(0);
        this.printIntInsn(opcode, operand);
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int opcode, int var) {
        this.buf.setLength(0);
        this.printVarInsn(opcode, var);
        this.text.add(this.buf.toString());
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.buf.setLength(0);
        this.printTypeInsn(opcode, desc);
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.buf.setLength(0);
        this.printFieldInsn(opcode, owner, name, desc);
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.buf.setLength(0);
        this.printMethodInsn(opcode, owner, name, desc);
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.buf.setLength(0);
        this.printJumpInsn(opcode, label);
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.printLabel(label);
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object cst) {
        this.buf.setLength(0);
        this.printLdcInsn(cst);
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int var, int increment) {
        this.buf.setLength(0);
        this.printIincInsn(var, increment);
        this.text.add(this.buf.toString());
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.buf.setLength(0);
        this.printTableSwitchInsn(min, max, dflt, labels);
        this.text.add(this.buf.toString());
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.buf.setLength(0);
        this.printLookupSwitchInsn(dflt, keys, labels);
        this.text.add(this.buf.toString());
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.buf.setLength(0);
        this.printMultiANewArrayInsn(desc, dims);
        this.text.add(this.buf.toString());
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.buf.setLength(0);
        this.printTryCatchBlock(start, end, handler, type);
        this.text.add(this.buf.toString());
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.buf.setLength(0);
        this.printMaxs(maxStack, maxLocals);
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.buf.setLength(0);
        this.printLocalVariable(name, desc, start, end, index);
        this.text.add(this.buf.toString());
    }

    public void visitLineNumber(int line, Label start) {
        this.buf.setLength(0);
        this.printLineNumber(line, start);
        this.text.add(this.buf.toString());
    }

    public void visitAttribute(Attribute attr) {
        this.buf.setLength(0);
        this.printAttribute(attr);
        this.text.add(this.buf.toString());
    }

    public List getText() {
        return this.text;
    }

    public abstract void printInsn(int var1);

    public abstract void printIntInsn(int var1, int var2);

    public abstract void printVarInsn(int var1, int var2);

    public abstract void printTypeInsn(int var1, String var2);

    public abstract void printFieldInsn(int var1, String var2, String var3, String var4);

    public abstract void printMethodInsn(int var1, String var2, String var3, String var4);

    public abstract void printJumpInsn(int var1, Label var2);

    public abstract void printLabel(Label var1);

    public abstract void printLdcInsn(Object var1);

    public abstract void printIincInsn(int var1, int var2);

    public abstract void printTableSwitchInsn(int var1, int var2, Label var3, Label[] var4);

    public abstract void printLookupSwitchInsn(Label var1, int[] var2, Label[] var3);

    public abstract void printMultiANewArrayInsn(String var1, int var2);

    public abstract void printTryCatchBlock(Label var1, Label var2, Label var3, String var4);

    public abstract void printMaxs(int var1, int var2);

    public abstract void printLocalVariable(String var1, String var2, Label var3, Label var4, int var5);

    public abstract void printLineNumber(int var1, Label var2);

    public abstract void printAttribute(Attribute var1);
}

