/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.operamasks.el.eval.TypeCoercion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final Class[] PRIMITIVE_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";

    private Utils() {
    }

    public static Class getWrapperClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return Boolean.class;
            }
            if (c == Byte.TYPE) {
                return Byte.class;
            }
            if (c == Character.TYPE) {
                return Character.class;
            }
            if (c == Short.TYPE) {
                return Short.class;
            }
            if (c == Integer.TYPE) {
                return Integer.class;
            }
            if (c == Long.TYPE) {
                return Long.class;
            }
            if (c == Float.TYPE) {
                return Float.class;
            }
            if (c == Double.TYPE) {
                return Double.class;
            }
            return null;
        }
        return c;
    }

    public static Class findClass(String name) throws ClassNotFoundException {
        return Utils.findClass(name, null);
    }

    public static Class findClass(String name, ClassLoader loader) throws ClassNotFoundException {
        int enhanceFlagIndex;
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        if ((enhanceFlagIndex = name.indexOf("$$")) != -1) {
            name = name.substring(0, name.indexOf("$$"));
        }
        int dim = 0;
        while (name.endsWith("[]")) {
            ++dim;
            name = name.substring(0, name.length() - 2);
        }
        Class<?> type = Utils.findPrimitiveClass(name);
        if (type == null) {
            try {
                type = loader != null ? Class.forName(name, true, loader) : Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                type = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
        }
        if (dim == 0) {
            return type;
        }
        return Array.newInstance(type, new int[dim]).getClass();
    }

    private static Class findPrimitiveClass(String name) {
        int i = Arrays.binarySearch(PRIMITIVE_NAMES, name);
        if (i >= 0) {
            return PRIMITIVE_TYPES[i];
        }
        return null;
    }

    public static Field checkField(Class<?> targetClass, Field field) {
        Class declClass = field.getDeclaringClass();
        if (!declClass.isAssignableFrom(targetClass)) {
            try {
                ClassLoader loader = targetClass.getClassLoader();
                declClass = Utils.findClass(declClass.getName(), loader);
                field = declClass.getDeclaredField(field.getName());
            }
            catch (NoSuchFieldException ex) {
                field = null;
            }
            catch (ClassNotFoundException ex) {
                field = null;
            }
        }
        return field;
    }

    public static Method checkMethod(Class<?> targetClass, Method method) {
        Class declClass = method.getDeclaringClass();
        if (!declClass.isAssignableFrom(targetClass)) {
            try {
                ClassLoader loader = targetClass.getClassLoader();
                String name = method.getName();
                Class<?>[] params = method.getParameterTypes();
                declClass = Utils.findClass(declClass.getName(), loader);
                for (int i = 0; i < params.length; ++i) {
                    params[i] = Utils.findClass(params[i].getName(), loader);
                }
                method = declClass.getDeclaredMethod(name, params);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException ex) {
                method = null;
            }
            catch (ClassNotFoundException ex) {
                method = null;
            }
        }
        return method;
    }

    public static Object[] buildParameterList(Class[] types, Object[] params, boolean isVarArgs) {
        int nargs = types.length;
        Object[] values = new Object[nargs];
        if (isVarArgs) {
            int vargc;
            if ((vargc = params.length - --nargs) < 0) {
                vargc = 0;
            }
            assert (types[nargs].isArray());
            Class<?> argtype = types[nargs].getComponentType();
            Object vargs = Array.newInstance(argtype, vargc);
            for (int i = 0; i < vargc; ++i) {
                Array.set(vargs, i, TypeCoercion.coerce(params[i + nargs], argtype));
            }
            values[nargs] = vargs;
        }
        for (int i = 0; i < nargs; ++i) {
            values[i] = i < params.length ? TypeCoercion.coerce(params[i], types[i]) : TypeCoercion.coerce(null, types[i]);
        }
        return values;
    }

    public static boolean isAbsoluteURL(String url) {
        if (url == null) {
            return false;
        }
        int colon = url.indexOf(58);
        if (colon == -1) {
            return false;
        }
        for (int i = 0; i < colon; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

