/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.fields;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.GFp;
import com.entrust.toolkit.security.arithmetic.fields.PolynomialField;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;

public class FieldFactory {
    public static ObjectID PP_BASIS_OID;
    public static ObjectID TP_BASIS_OID;
    public static ObjectID GN_BASIS_OID;
    public static ObjectID CHARACTERISTIC_TWO_FIELD_OID;
    public static ObjectID PRIME_FIELD_OID;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Field getInstance(ASN1Object aSN1Object) throws CodingException {
        void var1_4;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("not a field");
        }
        Object var1_1 = null;
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
        ASN1Object aSN1Object2 = sEQUENCE.getComponentAt(0);
        if (!aSN1Object2.isA(ASN.ObjectID)) {
            throw new CodingException("field parameter type missing");
        }
        ObjectID objectID = (ObjectID)aSN1Object2;
        ASN1Object aSN1Object3 = sEQUENCE.getComponentAt(1);
        if (objectID.equals(PRIME_FIELD_OID)) {
            if (!aSN1Object3.getAsnType().equals(ASN.INTEGER)) throw new CodingException("wrong field parameter");
            INTEGER iNTEGER = (INTEGER)aSN1Object3;
            BigInteger bigInteger = (BigInteger)iNTEGER.getValue();
            GFp gFp = new GFp(bigInteger);
            return var1_4;
        } else {
            if (!objectID.equals(CHARACTERISTIC_TWO_FIELD_OID)) throw new CodingException("unknown field parameters");
            if (!aSN1Object3.isA(ASN.SEQUENCE) || aSN1Object3.countComponents() != 3) {
                throw new CodingException("wrong field parameters");
            }
            ASN1Object aSN1Object4 = aSN1Object3.getComponentAt(0);
            if (!aSN1Object4.isA(ASN.INTEGER)) {
                throw new CodingException("wrong field parameter format");
            }
            BigInteger bigInteger = (BigInteger)aSN1Object4.getValue();
            aSN1Object4 = aSN1Object3.getComponentAt(1);
            if (!aSN1Object4.isA(ASN.ObjectID)) {
                throw new CodingException("field parameter OID missing");
            }
            if (aSN1Object4.equals(GN_BASIS_OID)) {
                throw new IllegalArgumentException("GNB not supported");
            }
            BigInteger bigInteger2 = BigInteger.valueOf(1L);
            bigInteger2 = bigInteger2.shiftLeft(bigInteger.intValue()).add(bigInteger2);
            if (aSN1Object4.equals(TP_BASIS_OID)) {
                aSN1Object4 = aSN1Object3.getComponentAt(2);
                if (!aSN1Object4.isA(ASN.INTEGER)) {
                    throw new CodingException("invalid trinomial parameter");
                }
                bigInteger2 = bigInteger2.setBit(((BigInteger)aSN1Object4.getValue()).intValue());
            } else {
                if (!aSN1Object4.equals(PP_BASIS_OID)) throw new CodingException("unknown polynomial type");
                aSN1Object4 = aSN1Object3.getComponentAt(2);
                if (!aSN1Object4.isA(ASN.SEQUENCE) && aSN1Object4.countComponents() != 3) {
                    throw new CodingException("invalid pentanomial parameter");
                }
                int n2 = -1;
                while (++n2 < 3) {
                    ASN1Object aSN1Object5 = aSN1Object4.getComponentAt(n2);
                    if (!aSN1Object5.isA(ASN.INTEGER)) {
                        throw new CodingException("invalid pentanomial parameter");
                    }
                    bigInteger2 = bigInteger2.setBit(((BigInteger)aSN1Object5.getValue()).intValue());
                }
            }
            PolynomialField polynomialField = new PolynomialField(bigInteger2);
        }
        return var1_4;
    }

    static {
        PRIME_FIELD_OID = new ObjectID("1.2.840.10045.1.1");
        CHARACTERISTIC_TWO_FIELD_OID = new ObjectID("1.2.840.10045.1.2");
        GN_BASIS_OID = new ObjectID("1.2.840.10045.1.2.3.1");
        TP_BASIS_OID = new ObjectID("1.2.840.10045.1.2.3.2");
        PP_BASIS_OID = new ObjectID("1.2.840.10045.1.2.3.3");
    }
}

