/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.fields;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.FieldFactory;
import com.entrust.toolkit.security.arithmetic.fields.GFpElement;
import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;

public class GFp
implements Field {
    private BigInteger a;

    public String toString() {
        return "prime field, the prime is: " + this.a.toString(16);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(FieldFactory.PRIME_FIELD_OID);
        sEQUENCE.addComponent(new INTEGER(this.a));
        return sEQUENCE;
    }

    public FieldElement getZeroElement() {
        return new GFpElement(BigInteger.valueOf(0L), this);
    }

    public FieldElement getOneElement() {
        return new GFpElement(BigInteger.valueOf(1L), this);
    }

    public BigInteger getNumberOfElements() {
        return this.a;
    }

    public String getFieldType() {
        return new String("prime field");
    }

    public boolean equals(Object object) {
        GFp gFp = null;
        if (!(object instanceof GFp)) {
            return false;
        }
        gFp = (GFp)object;
        return this.a.equals(gFp.getNumberOfElements());
    }

    public GFp(BigInteger bigInteger) {
        this.a = bigInteger;
    }
}

