/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.fields;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.GFp;
import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import java.math.BigInteger;

public class GFpElement
implements FieldElement {
    static BigInteger e;
    static BigInteger d;
    private GFp c;
    private BigInteger a;
    private BigInteger b;

    public String toString() {
        String string = "Number is: " + this.b.toString(16) + "\n";
        string = String.valueOf(string) + "Field is: " + this.c.toString();
        return string;
    }

    public ASN1Object toASN1Object() {
        Object object;
        Object object2 = this.b.toByteArray();
        if (object2[0] == 0) {
            object = new byte[((byte[])object2).length - 1];
            System.arraycopy(object2, 1, object, 0, ((Object)object).length);
            object2 = object;
        }
        object = new OCTET_STRING((byte[])object2);
        return object;
    }

    public FieldElement subtract(FieldElement fieldElement) throws IllegalArgumentException {
        GFpElement gFpElement = null;
        Field field = fieldElement.getField();
        if (!this.c.equals(field)) {
            throw new IllegalArgumentException("Can't substract elements as they are not in the same field.");
        }
        BigInteger bigInteger = fieldElement.getBigInteger();
        BigInteger bigInteger2 = this.b.subtract(bigInteger);
        gFpElement = new GFpElement(bigInteger2, this.c);
        return gFpElement;
    }

    public FieldElement multiply(FieldElement fieldElement) throws IllegalArgumentException {
        GFpElement gFpElement = null;
        Field field = fieldElement.getField();
        if (!this.c.equals(field)) {
            throw new IllegalArgumentException("Can't multiply elements as they are not in the same field.");
        }
        BigInteger bigInteger = fieldElement.getBigInteger();
        BigInteger bigInteger2 = this.b.multiply(bigInteger);
        gFpElement = new GFpElement(bigInteger2, this.c);
        return gFpElement;
    }

    public FieldElement multiplicativeInverse() throws ArithmeticException {
        if (this.b.equals(d)) {
            throw new ArithmeticException("Can't compute an multiplicative inverse for zero.");
        }
        BigInteger bigInteger = this.b.modInverse(this.a);
        GFpElement gFpElement = new GFpElement(bigInteger, this.c);
        return gFpElement;
    }

    public Field getField() {
        return this.c;
    }

    public BigInteger getBigInteger() {
        return this.b;
    }

    public FieldElement exponentiate(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.b.modPow(bigInteger, this.a);
        GFpElement gFpElement = new GFpElement(bigInteger2, this.c);
        return gFpElement;
    }

    public boolean equals(Object object) {
        GFpElement gFpElement = null;
        if (!(object instanceof GFpElement)) {
            return false;
        }
        gFpElement = (GFpElement)object;
        boolean bl = false;
        if (!gFpElement.getField().equals(this.c)) {
            return false;
        }
        BigInteger bigInteger = gFpElement.getBigInteger();
        bl = this.b.compareTo(bigInteger) == 0;
        return bl;
    }

    public FieldElement add(FieldElement fieldElement) throws IllegalArgumentException {
        GFpElement gFpElement = null;
        Field field = fieldElement.getField();
        if (!this.c.equals(field)) {
            throw new IllegalArgumentException("Can't add elements if they are not in the same field.");
        }
        BigInteger bigInteger = fieldElement.getBigInteger();
        BigInteger bigInteger2 = this.b.add(bigInteger);
        gFpElement = new GFpElement(bigInteger2, this.c);
        return gFpElement;
    }

    public GFpElement(BigInteger bigInteger, Field field) throws IllegalArgumentException {
        if (!(field instanceof GFp)) {
            throw new IllegalArgumentException("The given field is not of the right type.");
        }
        this.c = (GFp)field;
        this.a = this.c.getNumberOfElements();
        this.b = bigInteger.mod(this.a);
        if (this.b.compareTo(d) == -1) {
            this.b = this.b.add(this.a);
        }
    }

    static {
        d = BigInteger.valueOf(0L);
        e = BigInteger.valueOf(1L);
    }
}

