/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.fields;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.FieldFactory;
import com.entrust.toolkit.security.arithmetic.fields.Polynomial;
import iaik.asn1.ASN1Object;
import iaik.asn1.ConstructedType;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;

public class PolynomialField
implements Field {
    static final BigInteger a;
    static final BigInteger b;
    int[] c;
    int d;
    long[] f;
    BigInteger g;
    int e;

    public String toString() {
        return this.g.toString(16);
    }

    public ASN1Object toASN1Object() throws IllegalStateException {
        Object object;
        int n2 = this.g.bitCount();
        BigInteger bigInteger = this.g.clearBit(this.e);
        ASN1Object aSN1Object = null;
        ObjectID objectID = null;
        if (n2 == 5) {
            objectID = FieldFactory.PP_BASIS_OID;
            object = new int[3];
            int n3 = 3;
            while (--n3 >= 0) {
                object[n3] = bigInteger.bitLength() - 1;
                bigInteger = bigInteger.clearBit(object[n3]);
            }
            SEQUENCE sEQUENCE = new SEQUENCE();
            n3 = -1;
            while (++n3 < 3) {
                sEQUENCE.addComponent(new INTEGER((int)object[n3]));
            }
            aSN1Object = sEQUENCE;
        } else if (n2 == 3) {
            objectID = FieldFactory.TP_BASIS_OID;
            aSN1Object = new INTEGER(bigInteger.bitLength() - 1);
        } else {
            throw new IllegalStateException("basis is neither trinomial nor pentanomial");
        }
        object = new SEQUENCE();
        ((ConstructedType)object).addComponent(new INTEGER(this.e));
        ((ConstructedType)object).addComponent(objectID);
        ((ConstructedType)object).addComponent(aSN1Object);
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(FieldFactory.CHARACTERISTIC_TWO_FIELD_OID);
        sEQUENCE.addComponent((ASN1Object)object);
        return sEQUENCE;
    }

    public FieldElement getZeroElement() {
        return new Polynomial(a, this);
    }

    public FieldElement getOneElement() {
        return new Polynomial(b, this);
    }

    public BigInteger getNumberOfElements() {
        return b.shiftLeft(this.e);
    }

    public String getFieldType() {
        return "polynomial_field";
    }

    public BigInteger getBasis() {
        return this.g;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PolynomialField)) {
            return false;
        }
        PolynomialField polynomialField = (PolynomialField)object;
        return this.g.compareTo(polynomialField.g) == 0;
    }

    public PolynomialField(BigInteger bigInteger) {
        if (bigInteger.compareTo(a) <= 0) {
            throw new IllegalArgumentException();
        }
        this.g = bigInteger;
        this.e = this.g.bitLength() - 1;
        this.d = this.e / 64 + 1;
        this.f = new long[this.d];
        int n2 = 0;
        while (bigInteger.bitLength() != 0) {
            this.f[n2] = bigInteger.longValue();
            ++n2;
            bigInteger = bigInteger.shiftRight(64);
        }
        bigInteger = this.g;
        this.c = new int[this.g.bitCount()];
        n2 = 0;
        do {
            this.c[n2] = bigInteger.bitLength() - 1;
            bigInteger = bigInteger.clearBit(this.c[n2]);
            ++n2;
        } while (bigInteger.bitLength() != 0);
    }

    static {
        b = BigInteger.valueOf(1L);
        a = BigInteger.valueOf(0L);
    }
}

