/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.groups.ellipticCurve;

import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPointFactory;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.EllipticCurve;
import iaik.asn1.ASN1Object;
import java.math.BigInteger;

public abstract class ECPoint {
    static BigInteger b;
    static BigInteger a;

    public abstract String toString();

    public abstract ASN1Object toASN1Object();

    public ECPoint multiply(BigInteger bigInteger) throws IllegalArgumentException {
        if (bigInteger.compareTo(a) < 0) {
            throw new IllegalArgumentException("Given integer must not be negative.");
        }
        if (this.isPointAtInfinity()) {
            return this;
        }
        if (bigInteger.compareTo(a) == 0) {
            return ECPointFactory.getInstance(this.getCurve());
        }
        if (bigInteger.compareTo(b) == 0) {
            return this;
        }
        int n2 = -1;
        int n3 = bigInteger.bitLength();
        while (n3 > 0) {
            if (bigInteger.testBit(n3)) {
                n2 = n3;
                break;
            }
            --n3;
        }
        ECPoint eCPoint = this;
        ECPoint eCPoint2 = this;
        int n4 = n2 - 1;
        while (n4 > -1) {
            eCPoint = eCPoint.doublePoint();
            if (bigInteger.testBit(n4)) {
                eCPoint = eCPoint.add(eCPoint2);
            }
            --n4;
        }
        return eCPoint;
    }

    public abstract boolean isPointAtInfinity();

    public abstract FieldElement getYCoordinate();

    public abstract FieldElement getXCoordinate();

    public abstract EllipticCurve getCurve();

    public abstract boolean equals(Object var1);

    public abstract ECPoint doublePoint();

    public abstract ECPoint add(ECPoint var1);

    static {
        a = BigInteger.valueOf(0L);
        b = BigInteger.valueOf(1L);
    }
}

