/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.groups.ellipticCurve;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.EllipticCurve;
import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import java.math.BigInteger;

public class ECPointGFp
extends ECPoint {
    private Field d;
    private boolean c;
    private EllipticCurve e;
    private FieldElement a;
    private FieldElement b;

    public String toString() {
        if (this.b == null) {
            return "( 0 )";
        }
        return "(" + this.b.getBigInteger().toString(16) + "," + this.a.getBigInteger().toString(16) + ")";
    }

    public ASN1Object toASN1Object() {
        byte[] byArray = null;
        byte[] byArray2 = new byte[1];
        if (this.isPointAtInfinity()) {
            return new OCTET_STRING(new byte[1]);
        }
        int n2 = (this.d.getNumberOfElements().bitLength() + 7) / 8;
        BigInteger bigInteger = this.b.getBigInteger();
        byte[] byArray3 = this.b.getBigInteger().toByteArray();
        BigInteger bigInteger2 = this.a.getBigInteger();
        byte[] byArray4 = this.a.getBigInteger().toByteArray();
        byArray2[0] = 4;
        byArray = new byte[2 * n2 + 1];
        System.arraycopy(byArray4, 0, byArray, 2 * n2 + 1 - byArray4.length, byArray4.length);
        System.arraycopy(byArray3, 0, byArray, n2 + 1 - byArray3.length, byArray3.length);
        System.arraycopy(byArray2, 0, byArray, 0, 1);
        OCTET_STRING oCTET_STRING = new OCTET_STRING(byArray);
        return oCTET_STRING;
    }

    public boolean isPointAtInfinity() {
        return this.c;
    }

    private boolean a() {
        try {
            FieldElement fieldElement;
            FieldElement fieldElement2;
            FieldElement fieldElement3;
            if (this.isPointAtInfinity()) {
                return true;
            }
            FieldElement fieldElement4 = this.e.getA();
            FieldElement fieldElement5 = this.e.getB();
            FieldElement fieldElement6 = this.a;
            FieldElement fieldElement7 = this.b;
            FieldElement fieldElement8 = fieldElement6.multiply(fieldElement6);
            return fieldElement8.equals(fieldElement3 = (fieldElement2 = fieldElement7.exponentiate(BigInteger.valueOf(3L))).add(fieldElement = fieldElement7.multiply(fieldElement4).add(fieldElement5)));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void a(FieldElement fieldElement, FieldElement fieldElement2, EllipticCurve ellipticCurve, boolean bl) throws IllegalArgumentException {
        if (!fieldElement.getField().equals(fieldElement2.getField())) {
            throw new IllegalArgumentException("Fatal Error. The field elements are not linked to the same field.");
        }
        if (!fieldElement.getField().equals(ellipticCurve.getField())) {
            throw new IllegalArgumentException("Fatal Error. The field elements and the curve are not linked to the same field.");
        }
        this.c = false;
        this.b = fieldElement;
        this.a = fieldElement2;
        this.e = ellipticCurve;
        this.d = this.e.getField();
        if (bl && !this.a()) {
            throw new IllegalArgumentException("Fatal Error. This is not a valid point on this curve.");
        }
    }

    public FieldElement getYCoordinate() {
        return this.a;
    }

    public FieldElement getXCoordinate() {
        return this.b;
    }

    public EllipticCurve getCurve() {
        return this.e;
    }

    public boolean equals(Object object) {
        ECPoint eCPoint = null;
        if (!(object instanceof ECPoint)) {
            return false;
        }
        eCPoint = (ECPoint)object;
        if (!this.e.equals(eCPoint.getCurve())) {
            return false;
        }
        return this.b.equals(eCPoint.getXCoordinate()) & this.b.equals(eCPoint.getXCoordinate());
    }

    public ECPoint doublePoint() {
        ECPointGFp eCPointGFp = null;
        if (this.isPointAtInfinity()) {
            return this;
        }
        FieldElement fieldElement = this.getXCoordinate();
        FieldElement fieldElement2 = this.getYCoordinate();
        if (fieldElement2.equals(this.d.getZeroElement())) {
            return new ECPointGFp(this.e);
        }
        FieldElement fieldElement3 = fieldElement2.add(fieldElement2).multiplicativeInverse();
        FieldElement fieldElement4 = fieldElement.multiply(fieldElement);
        FieldElement fieldElement5 = fieldElement4.add(fieldElement4).add(fieldElement4).add(this.e.getA());
        FieldElement fieldElement6 = fieldElement5.multiply(fieldElement3);
        FieldElement fieldElement7 = fieldElement6.multiply(fieldElement6).subtract(fieldElement).subtract(fieldElement);
        FieldElement fieldElement8 = fieldElement.subtract(fieldElement7).multiply(fieldElement6).subtract(fieldElement2);
        eCPointGFp = new ECPointGFp(fieldElement7, fieldElement8, this.e, false);
        return eCPointGFp;
    }

    public ECPoint add(ECPoint eCPoint) {
        ECPoint eCPoint2 = null;
        if (this.isPointAtInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isPointAtInfinity()) {
            return this;
        }
        FieldElement fieldElement = eCPoint.getXCoordinate();
        FieldElement fieldElement2 = eCPoint.getYCoordinate();
        FieldElement fieldElement3 = this.getXCoordinate();
        FieldElement fieldElement4 = this.getYCoordinate();
        if (fieldElement3.equals(fieldElement)) {
            eCPoint2 = fieldElement4.equals(fieldElement2) ? this.doublePoint() : new ECPointGFp(this.e);
        } else {
            FieldElement fieldElement5 = fieldElement2.subtract(fieldElement4);
            FieldElement fieldElement6 = fieldElement.subtract(fieldElement3).multiplicativeInverse();
            FieldElement fieldElement7 = fieldElement5.multiply(fieldElement6);
            FieldElement fieldElement8 = fieldElement7.multiply(fieldElement7).subtract(fieldElement3).subtract(fieldElement);
            FieldElement fieldElement9 = fieldElement3.subtract(fieldElement8).multiply(fieldElement7).subtract(fieldElement4);
            eCPoint2 = new ECPointGFp(fieldElement8, fieldElement9, this.e, false);
        }
        return eCPoint2;
    }

    protected ECPointGFp(EllipticCurve ellipticCurve) {
        this.c = true;
        this.b = null;
        this.a = null;
        this.a = null;
        this.e = ellipticCurve;
        this.d = ellipticCurve.getField();
    }

    ECPointGFp(FieldElement fieldElement, FieldElement fieldElement2, EllipticCurve ellipticCurve, boolean bl) throws IllegalArgumentException {
        this.a(fieldElement, fieldElement2, ellipticCurve, bl);
    }

    public ECPointGFp(FieldElement fieldElement, FieldElement fieldElement2, EllipticCurve ellipticCurve) throws IllegalArgumentException {
        this.a(fieldElement, fieldElement2, ellipticCurve, true);
    }
}

