/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.fips;

import com.entrust.toolkit.util.MacGenerator;
import iaik.security.cipher.SecretKey;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarAuthenticator {
    protected static int TRACE_LEVEL;
    protected static boolean DEBUG;
    private String a;

    private void a(JarFile jarFile, Manifest manifest) throws IOException {
        File file = new File(jarFile.getName());
        File file2 = new File(String.valueOf(jarFile.getName()) + ".tmp");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            byte[] byArray = new byte[1024];
            while (enumeration.hasMoreElements()) {
                int n2;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                JarEntry jarEntry2 = new JarEntry(jarEntry.getName());
                jarOutputStream.putNextEntry(jarEntry2);
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                while ((n2 = inputStream.read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n2);
                }
                jarOutputStream.closeEntry();
            }
            ((FilterOutputStream)jarOutputStream).flush();
            jarOutputStream.close();
            jarFile.close();
            if (!file.delete()) {
                throw new IOException("Unable to delete the old JAR file");
            }
            if (!file2.renameTo(file)) {
                throw new IOException("Unable to rename the new JAR file");
            }
        }
        catch (IOException iOException) {
            if (DEBUG) {
                throw new IOException("Error occured while updating '" + jarFile.getName() + "': " + iOException.getMessage());
            }
            throw new IOException("Error occured while updating '" + jarFile.getName() + "'");
        }
    }

    public void setMacAlgorithm(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("'macAlgorithm' cannot be null");
        }
        if (!(string.equalsIgnoreCase("3DES") || string.equalsIgnoreCase("DES") || string.equalsIgnoreCase("IDEA") || string.equalsIgnoreCase("CAST128"))) {
            throw new IllegalArgumentException("'macAlgorithm' is not a supported algorithm");
        }
        this.a = string;
    }

    public void mac(JarFile jarFile, byte[] byArray) throws GeneralSecurityException, IOException, IllegalArgumentException {
        if (jarFile == null || byArray == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        Manifest manifest = this.b(jarFile);
        byte[] byArray2 = Util.Base64Encode(this.a(jarFile, byArray));
        manifest.getMainAttributes().putValue("MACValue", new String(byArray2));
        this.a(jarFile, manifest);
    }

    private Manifest b(JarFile jarFile) throws IOException {
        Object object;
        JarEntry jarEntry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
        if (jarEntry == null) {
            object = jarFile.entries();
            while (object.hasMoreElements()) {
                jarEntry = (JarEntry)object.nextElement();
                if (jarEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) break;
                jarEntry = null;
            }
        }
        object = new Manifest();
        if (jarEntry != null) {
            try {
                object = new Manifest(jarFile.getInputStream(jarEntry));
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    throw new IOException("Unable to extract the manifest from '" + jarFile.getName() + "': " + iOException.toString());
                }
                throw new IOException("Unable to extract the manifest from '" + jarFile.getName() + "'");
            }
        } else {
            Attributes attributes = ((Manifest)object).getMainAttributes();
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            attributes.putValue("Created-By", String.valueOf(System.getProperty("java.version")) + " ( " + System.getProperty("java.vendor") + ")");
        }
        return object;
    }

    public String getMacAlgorithm() {
        return this.a;
    }

    private byte[] a(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        try {
            while (enumeration.hasMoreElements()) {
                int n2;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.getName().substring(0, 8).equalsIgnoreCase("META-INF")) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                while ((n2 = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new IOException("Error occured while reading the JAR file: " + iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] a(JarFile jarFile, byte[] byArray) throws GeneralSecurityException, IOException {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = this.a(jarFile);
            SecretKey secretKey = new SecretKey(byArray, this.a);
            byArray2 = this.a.equalsIgnoreCase("3DES") ? MacGenerator.generate("pbeWithSHA1AndDES-EDE3-CBC", secretKey, byArray3) : (this.a.equalsIgnoreCase("DES") ? MacGenerator.generate("pbeWithSHA1AndDES-CBC", secretKey, byArray3) : (this.a.equalsIgnoreCase("IDEA") ? MacGenerator.generate("pbeWithSHA1AndIDEA-CBC", secretKey, byArray3) : MacGenerator.generate("pbeWithSHA1AndCAST5-CBC", secretKey, byArray3)));
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (DEBUG) {
                throw new GeneralSecurityException("Error occured while calculating the MAC on '" + jarFile.getName() + "': " + generalSecurityException.toString());
            }
            throw new GeneralSecurityException("Error occured while calculating the MAC on '" + jarFile.getName() + "'");
        }
        return byArray2;
    }

    public boolean authenticate(JarFile jarFile, byte[] byArray) throws GeneralSecurityException, IOException, IllegalArgumentException {
        if (jarFile == null || byArray == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        Manifest manifest = this.b(jarFile);
        byte[] byArray2 = Util.Base64Encode(this.a(jarFile, byArray));
        String string = manifest.getMainAttributes().getValue("MACValue");
        if (string == null) {
            return false;
        }
        return CryptoUtils.equalsBlock(byArray2, string.getBytes());
    }

    public JarAuthenticator(String string) throws IllegalArgumentException {
        this.setMacAlgorithm(string);
    }

    public JarAuthenticator() {
        this.a = "3DES";
    }

    static {
        try {
            TRACE_LEVEL = Integer.getInteger("com.entrust.toolkit.security.fips.JarAuthenticator.trace", 0);
            DEBUG = TRACE_LEVEL > 0;
        }
        catch (Throwable throwable) {}
    }
}

