/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.spec;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import java.security.spec.AlgorithmParameterSpec;

public class IDEAParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a = null;

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new OCTET_STRING(this.a));
        }
        return sEQUENCE;
    }

    public byte[] getIV() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            if (aSN1Object.isA(ASN.SEQUENCE)) {
                if (((SEQUENCE)aSN1Object).countComponents() == 1) {
                    this.a = (byte[])aSN1Object.getComponentAt(0).getValue();
                }
            } else {
                throw new CodingException("IDEA-CBCPar must be a SEQUENCE");
            }
            if (this.a != null && this.a.length != 8) {
                throw new CodingException("invalid iv - it must be 8 octets long");
            }
        }
        catch (CodingException codingException) {
            throw new CodingException("Cannot decode IDEA-CBCPar structure: " + codingException.getMessage());
        }
    }

    public IDEAParameterSpec(byte[] byArray, int n2) {
        if (byArray != null) {
            if (byArray.length < n2 + 8) {
                throw new IllegalArgumentException("'iv' must contain at least 8-bytes of data starting from index 'offset'");
            }
            this.a = new byte[8];
            System.arraycopy(byArray, n2, this.a, 0, 8);
        }
    }

    public IDEAParameterSpec(byte[] byArray) {
        this(byArray, 0);
    }

    public IDEAParameterSpec(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public IDEAParameterSpec() {
    }
}

