/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.spec;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import java.security.spec.AlgorithmParameterSpec;

public class RSAOAEPParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a = null;

    public void setPParameter(byte[] byArray) {
        this.a = byArray;
    }

    public byte[] getPParameter() {
        if (this.a == null) {
            return new byte[0];
        }
        return this.a;
    }

    public ASN1Object getEncoded() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        ((ASN1Object)sEQUENCE).addComponent(new CON_SPEC(0, AlgorithmID.sha1.toASN1Object()));
        ((ASN1Object)sEQUENCE).addComponent(new CON_SPEC(1, AlgorithmID.mgf1.toASN1Object()));
        AlgorithmID algorithmID = new AlgorithmID("1.2.840.113549.1.1.9", "pSourceAlg", "pSourceAlg");
        algorithmID.setParameter(new OCTET_STRING(this.getPParameter()));
        ((ASN1Object)sEQUENCE).addComponent(new CON_SPEC(2, algorithmID.toASN1Object()));
        return sEQUENCE;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (!(aSN1Object instanceof SEQUENCE)) {
            throw new CodingException("Expected a sequence for a parameter spec!");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
        this.a = null;
        int n2 = sEQUENCE.countComponents();
        int n3 = 0;
        while (n3 < n2) {
            AlgorithmID algorithmID;
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(n3);
            if (cON_SPEC.getAsnType().getTag() == 0) {
                algorithmID = new AlgorithmID((SEQUENCE)cON_SPEC.getValue());
                if (!algorithmID.equals(AlgorithmID.sha1)) {
                    throw new CodingException("We can only handle SHA-1 as a hash algorithm!");
                }
            } else if (cON_SPEC.getAsnType().getTag() == 1) {
                algorithmID = new AlgorithmID((SEQUENCE)cON_SPEC.getValue());
                if (!algorithmID.equals(AlgorithmID.mgf1)) {
                    throw new CodingException("We can only handle MGF-1 as a mask generation function!");
                }
            } else if (cON_SPEC.getAsnType().getTag() == 2) {
                algorithmID = new AlgorithmID((SEQUENCE)cON_SPEC.getValue());
                ObjectID objectID = algorithmID.getAlgorithm();
                if (!objectID.equals(new ObjectID("1.2.840.113549.1.1.9", "pSourceAlg", "pSourceAlg"))) {
                    throw new CodingException("Incorrect P source algorithm!");
                }
                ASN1Object aSN1Object2 = algorithmID.getParameter();
                if (!(aSN1Object2 instanceof OCTET_STRING)) {
                    throw new CodingException("P parameter is not an octet string!");
                }
                try {
                    this.a = (byte[])((OCTET_STRING)aSN1Object2).getValue();
                }
                catch (Exception exception) {
                    throw new CodingException(exception.getMessage());
                }
            } else {
                throw new CodingException("Unexpected type in OAEP parameters.");
            }
            ++n3;
        }
    }

    public RSAOAEPParameterSpec(byte[] byArray) {
        this.setPParameter(byArray);
    }

    public RSAOAEPParameterSpec(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public RSAOAEPParameterSpec(RSAOAEPParameterSpec rSAOAEPParameterSpec) {
        this.a = rSAOAEPParameterSpec.getPParameter();
    }

    public RSAOAEPParameterSpec() {
    }
}

