/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.PrivateKeyUsagePeriod;
import iaik.x509.extensions.SubjectKeyIdentifier;

public class KeyAttributes
extends V3Extension {
    private PrivateKeyUsagePeriod b = null;
    private KeyUsage c = null;
    private SubjectKeyIdentifier a = null;
    public static final ObjectID oid = new ObjectID("2.5.29.2", "KeyAttributes");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("keyIdentifier: " + this.a.toString() + "\n");
        }
        if (this.c != null) {
            stringBuffer.append("keyUsage: " + this.c.toString() + "\n");
        }
        if (this.b != null) {
            stringBuffer.append("keyUsagePeriod: " + this.b.toString());
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        return null;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
                ASN aSN = aSN1Object2.getAsnType();
                if (aSN.equals(ASN.OCTET_STRING)) {
                    this.a = new SubjectKeyIdentifier();
                    this.a.init(aSN1Object2);
                } else if (aSN.equals(ASN.BIT_STRING)) {
                    this.c = new KeyUsage();
                    this.c.init(aSN1Object2);
                } else if (aSN.equals(ASN.SEQUENCE)) {
                    this.b = new PrivateKeyUsagePeriod();
                    this.b.init(aSN1Object2);
                } else {
                    this.c = new KeyUsage();
                    CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
                    byte[] byArray = (byte[])cON_SPEC.getValue();
                    BIT_STRING bIT_STRING = new BIT_STRING(byArray);
                    this.c.init(bIT_STRING);
                }
                ++n2;
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return this.a;
    }

    public PrivateKeyUsagePeriod getPrivateKeyUsagePeriod() {
        return this.b;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public KeyUsage getKeyUsage() {
        return this.c;
    }
}

