/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.security.provider.IAIK;
import iaik.utils.Base64InputStream;
import iaik.utils.TracedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.MessageDigest;

public class ASN1 {
    private int a = 1;
    private byte[] c = null;
    private ASN1Object b = null;
    public static String startLine = "-----BEGIN";
    public static final int PEM = 2;
    public static final int DER = 1;

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    public String toString() {
        return ASN1.a(this.b, "");
    }

    public byte[] toByteArray() {
        return this.c;
    }

    public ASN1Object toASN1Object() {
        return this.b;
    }

    private static String a(ASN1Object aSN1Object, String string) {
        string = string.concat("  ");
        if (aSN1Object == null) {
            string = string.substring(2);
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(aSN1Object.toString());
        stringBuffer.append("\n");
        if (aSN1Object instanceof ConstructedType) {
            try {
                int n2 = 0;
                while (n2 < aSN1Object.countComponents()) {
                    stringBuffer.append(string);
                    stringBuffer.append(ASN1.a(aSN1Object.getComponentAt(n2), string));
                    ++n2;
                }
            }
            catch (CodingException codingException) {}
        }
        string = string.substring(2);
        return stringBuffer.toString();
    }

    public static String print(ASN1Object aSN1Object) {
        return ASN1.a(aSN1Object, "");
    }

    public int getFormat() {
        return this.a;
    }

    public byte[] getFirstObject() throws CodingException {
        if (this.c == null) {
            throw new CodingException("Cannot parse data from a null object!");
        }
        int n2 = 0;
        if (this.c[n2++] != 48) {
            throw new CodingException("getFirstObject: No SEQUENCE!");
        }
        int[] nArray = new int[1];
        int n3 = this.a(this.c, n2, nArray);
        n2 = nArray[0];
        if (this.c[n2] != 48) {
            throw new CodingException("getFirstObject: No SEQUENCE in a SEQUENCE!");
        }
        n3 = this.a(this.c, n2 + 1, nArray);
        byte[] byArray = new byte[n3 + nArray[0] - n2];
        System.arraycopy(this.c, n2, byArray, 0, n3 + nArray[0] - n2);
        return byArray;
    }

    public ASN1Object getComponentAt(int n2) throws CodingException {
        if (this.b == null) {
            throw new CodingException("Cannot get component since no ASN1Object is set!");
        }
        try {
            return this.b.getComponentAt(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CodingException("Error in getting component at index=" + n2 + ". Array index out of bounds.");
        }
    }

    private void a(InputStream inputStream) throws IOException, CodingException {
        FilterInputStream filterInputStream;
        int n2;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 20);
        byte[] byArray = new byte[10];
        boolean bl = false;
        int n3 = pushbackInputStream.read(byArray);
        if (n3 == -1) {
            throw new CodingException("Unexpected EOF.");
        }
        boolean bl2 = false;
        try {
            bl2 = new String(byArray).equals("-----BEGIN");
        }
        catch (Exception exception) {}
        if (bl2) {
            bl = true;
            do {
                if ((n2 = pushbackInputStream.read()) != -1) continue;
                throw new CodingException("Unexpected EOF.");
            } while (n2 != 13 && n2 != 10);
            if (n2 == 13) {
                pushbackInputStream.read();
            }
            this.a = 2;
            filterInputStream = new Base64InputStream(pushbackInputStream);
        } else {
            pushbackInputStream.unread(byArray);
            n2 = pushbackInputStream.read();
            pushbackInputStream.unread(n2);
            if (n2 >= 65 && n2 <= 77 || n2 >= 103 && n2 <= 122) {
                this.a = 2;
                filterInputStream = new Base64InputStream(pushbackInputStream);
            } else {
                this.a = 1;
                filterInputStream = pushbackInputStream;
            }
        }
        try {
            TracedInputStream tracedInputStream = new TracedInputStream(filterInputStream);
            this.b = DerCoder.decode(tracedInputStream);
            this.c = tracedInputStream.getTracedData();
        }
        catch (CodingException codingException) {
            this.b = null;
            this.c = null;
            throw codingException;
        }
        if (bl) {
            pushbackInputStream.skip(10L);
            while ((n2 = pushbackInputStream.read()) != 13 && n2 != 10 && n2 != -1) {
            }
            if (n2 == 13) {
                pushbackInputStream.read();
            }
        }
    }

    public byte[] fingerprint() {
        MessageDigest messageDigest = IAIK.getMd5();
        messageDigest.update(this.c);
        return messageDigest.digest();
    }

    private int a(byte[] byArray, int n2, int[] nArray) throws CodingException {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) <= 127) {
            nArray[0] = n2;
            return n3;
        }
        if (n3 == 128) {
            nArray[0] = n2;
            int n4 = n2;
            try {
                while (true) {
                    if (byArray[n4] != 0) {
                        ++n4;
                        continue;
                    }
                    if (byArray[n4 + 1] == 0) {
                        return n4 - n2;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                throw new CodingException("Error decoding ASN1 indefinite format!");
            }
        }
        if ((n3 &= 0x7F) > 4) {
            throw new CodingException("Too large ASN.1 object");
        }
        int n5 = 0;
        while (--n3 >= 0) {
            n5 = n5 << 8 | byArray[n2++] & 0xFF;
        }
        nArray[0] = n2;
        return n5;
    }

    public int countComponents() throws CodingException {
        if (this.b == null) {
            throw new CodingException("Cannot count components since no ASN1 object is set!");
        }
        return this.b.countComponents();
    }

    public ASN1(byte[] byArray) throws CodingException {
        if (byArray == null) {
            throw new CodingException("Cannot parse an ASN1 object from a null byte array!");
        }
        try {
            this.a(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new CodingException("Unexpected end of ASN.1 object.");
        }
    }

    public ASN1(InputStream inputStream) throws CodingException, IOException {
        if (inputStream == null) {
            throw new IOException("Cannot parse an ASN1 object from a null input stream!");
        }
        this.a(inputStream);
    }

    public ASN1(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot parse an ASN1 object from a null object.");
        }
        this.b = aSN1Object;
        try {
            this.c = DerCoder.encode(this.b);
        }
        catch (RuntimeException runtimeException) {
            throw new CodingException(runtimeException.getMessage());
        }
    }

    public ASN1() {
    }
}

