/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.EncodeListener;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1Object {
    protected boolean stream_mode = false;
    int a;
    protected EncodeListener[] encode_listener;
    protected ASN asnType;
    boolean b = false;
    boolean c = false;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asnType.getName());
        if (this.c) {
            stringBuffer.append("[C]");
        }
        if (this.b) {
            stringBuffer.append("[I]");
        }
        stringBuffer.append(" = ");
        return stringBuffer.toString();
    }

    public abstract void setValue(Object var1);

    public void setIndefiniteRecursive(boolean bl) {
        block3: {
            this.b = bl;
            if (!this.c) break block3;
            try {
                int n2 = 0;
                while (n2 < this.countComponents()) {
                    this.getComponentAt(n2).setIndefiniteRecursive(bl);
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setIndefiniteLength(boolean bl) {
        this.b = bl;
    }

    public boolean isConstructed() {
        return this.c;
    }

    public boolean isA(ASN aSN) {
        if (aSN.equals(ASN.CON_SPEC)) {
            return this instanceof CON_SPEC;
        }
        return this.asnType.equals(aSN);
    }

    public boolean indefiniteLength() {
        return this.b;
    }

    public abstract Object getValue();

    public ASN1Object getComponentAt(int n2) throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support getComponentAt(int)!");
    }

    public ASN getAsnType() {
        return this.asnType;
    }

    protected void encodeObject(OutputStream outputStream, boolean bl) throws IOException {
        if (this.encode_listener != null) {
            try {
                int n2 = 0;
                while (n2 < this.encode_listener.length) {
                    this.encode_listener[n2].encodeCalled(this, this.a);
                    ++n2;
                }
            }
            catch (CodingException codingException) {
                throw new IOException("Error from EncodeListener: " + codingException.getMessage());
            }
        }
        this.stream_mode = bl;
        this.encode(outputStream);
    }

    protected abstract void encode(OutputStream var1) throws IOException;

    protected abstract void decode(int var1, InputStream var2) throws IOException, CodingException;

    public int countComponents() throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support countComponents()!");
    }

    public void addEncodeListener(EncodeListener encodeListener, int n2) {
        this.a = n2;
        if (this.encode_listener == null) {
            this.encode_listener = new EncodeListener[]{encodeListener};
            return;
        }
        this.encode_listener = (EncodeListener[])Util.resizeArray(this.encode_listener, this.encode_listener.length + 1);
        this.encode_listener[this.encode_listener.length - 1] = encodeListener;
    }

    public void addComponent(ASN1Object aSN1Object) throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support addComponent()!");
    }
}

