/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BMPString
extends ASN1Object {
    String a = null;

    public String toString() {
        return String.valueOf(super.toString()) + "\"" + this.a + "\"";
    }

    public void setValue(Object object) {
        this.a = (String)object;
    }

    public Object getValue() {
        return this.a;
    }

    protected void encode(OutputStream outputStream) throws IOException {
        byte[] byArray = Util.toASCIIBytes(this.a);
        byte[] byArray2 = new byte[byArray.length * 2];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray2[2 * n2 + 1] = byArray[n2];
            ++n2;
        }
        outputStream.write(byArray2);
    }

    protected void decode(int n2, InputStream inputStream) throws CodingException, IOException {
        byte[] byArray;
        try {
            byArray = new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Fail to decode BMPString. Out of memory: length=" + n2);
        }
        Util.fillArray(byArray, inputStream);
        try {
            byte[] byArray2 = new byte[n2 >> 1];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if (byArray[n4] == 0) {
                    byArray2[n3++] = byArray[n4 + 1];
                }
                n4 += 2;
            }
            this.a = Util.toASCIIString(byArray2, 0, n3);
        }
        catch (Exception exception) {
            throw new CodingException("Fail to decode BMPString. length=" + byArray.length);
        }
    }

    public BMPString(String string) {
        this();
        this.a = string;
    }

    protected BMPString() {
        this.asnType = ASN.BMPString;
    }
}

