/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.utils.InternalErrorException;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import java.util.Hashtable;

public class AVA
implements ASN1Type {
    private ASN1Object f;
    private Object a;
    private ObjectID b;
    ASN c = null;
    static ASN e;
    static Hashtable d;

    public String toString(boolean bl) {
        Object object = this.a;
        if (!(object instanceof String)) {
            try {
                if (this.f == null) {
                    this.f = this.a(object);
                }
                if (this.f != null) {
                    object = this.a(this.f, true, ":");
                }
            }
            catch (Exception exception) {
                object = this.a;
            }
        }
        return String.valueOf(bl ? this.b.getName() : this.b.getShortName()) + "=" + object;
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b);
        if (this.f != null) {
            sEQUENCE.addComponent(this.f);
        } else {
            try {
                this.f = this.a(this.a);
                sEQUENCE.addComponent(this.f);
            }
            catch (Exception exception) {
                throw new InternalErrorException(exception);
            }
        }
        return sEQUENCE;
    }

    public void setEncoding(ASN aSN) {
        this.c = aSN;
    }

    public static void setDefaultEncoding(ASN aSN) {
        e = aSN;
    }

    private void a(ObjectID objectID, ASN1Object aSN1Object) {
        this.b = objectID;
        this.f = aSN1Object;
        this.a = this.f.getValue();
        this.c = this.f.getAsnType();
    }

    private ASN1Object a(Object object) throws CodingException {
        try {
            ASN aSN = this.c;
            if (aSN == null) {
                aSN = (ASN)d.get(this.b);
            }
            if (aSN == null) {
                aSN = e;
            }
            if (this.b == ObjectID.uniqueIdentifier && object instanceof String && aSN.equals(ASN.BIT_STRING)) {
                PrintableString printableString = new PrintableString((String)object);
                BIT_STRING bIT_STRING = new BIT_STRING(DerCoder.encode(printableString));
                return bIT_STRING;
            }
            return ASN.create(aSN, object);
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    public Object getValue() {
        return this.a;
    }

    public ObjectID getType() {
        return this.b;
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        Object object = this.a;
        ASN aSN = this.c;
        if (aSN == null) {
            aSN = (ASN)d.get(this.b);
        }
        boolean bl = false;
        if (aSN != null) {
            bl = aSN.equals(ASN.BIT_STRING);
        }
        if (!(object instanceof String) || bl || !ObjectID.hasRegisteredName(this.b.getID())) {
            try {
                if (this.f == null) {
                    this.f = this.a(object);
                }
                object = this.a(this.f, false, "");
            }
            catch (Exception exception) {
                throw new RFC2253NameParserException("Cannot write this AVA: " + exception.getMessage());
            }
        } else if (object instanceof String) {
            try {
                object = UTF8String.getRFC2253String((String)object);
            }
            catch (CodingException codingException) {
                throw new RFC2253NameParserException("Cannot write this AVA: " + codingException.getMessage());
            }
        } else {
            throw new RFC2253NameParserException("Cannot write this AVA: unknown representation.");
        }
        return String.valueOf(this.b.getShortName()) + "=" + object;
    }

    private String a(ASN1Object aSN1Object, boolean bl, String string) {
        String string2;
        if (aSN1Object.isA(ASN.BIT_STRING) && bl) {
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object;
            string2 = "#'" + bIT_STRING.getBinaryString() + "'B";
        } else {
            byte[] byArray = DerCoder.encode(aSN1Object);
            String string3 = Util.toString(byArray, string);
            string2 = "#" + string3;
        }
        return string2;
    }

    public ASN1Object getASN1Value() throws CodingException {
        if (this.f == null) {
            this.f = this.a(this.a);
        }
        return this.f;
    }

    public boolean equals(Object object) {
        block12: {
            AVA aVA = null;
            try {
                aVA = (AVA)object;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            if (!this.b.equals(aVA.getType())) {
                return false;
            }
            try {
                String string = (String)this.a;
                String string2 = (String)aVA.getValue();
                string = string.trim();
                string2 = string2.trim();
                StringBuffer stringBuffer = new StringBuffer(string);
                int n2 = 0;
                while (n2 < stringBuffer.length()) {
                    if (stringBuffer.charAt(n2) == ' ') {
                        while (stringBuffer.charAt(n2 + 1) == ' ') {
                            stringBuffer.deleteCharAt(n2 + 1);
                        }
                    }
                    ++n2;
                }
                string = stringBuffer.toString();
                stringBuffer = new StringBuffer(string2);
                int n3 = 0;
                while (n3 < stringBuffer.length()) {
                    if (stringBuffer.charAt(n3) == ' ') {
                        while (stringBuffer.charAt(n3 + 1) == ' ') {
                            stringBuffer.deleteCharAt(n3 + 1);
                        }
                    }
                    ++n3;
                }
                string2 = stringBuffer.toString();
                if (!string.equalsIgnoreCase(string2)) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                if (this.a.equals(aVA.getValue())) break block12;
                return false;
            }
        }
        return true;
    }

    public static void defineEncoding(ObjectID objectID, ASN aSN) {
        d.put(objectID, aSN);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.b = (ObjectID)aSN1Object.getComponentAt(0);
            this.f = aSN1Object.getComponentAt(1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CodingException("Error decoding AVA. Missing component(s).");
        }
        catch (ClassCastException classCastException) {
            throw new CodingException("Error decoding AVA. ClassCastException: " + classCastException.getMessage());
        }
        this.c = this.f.getAsnType();
        if (this.b.equals(ObjectID.uniqueIdentifier) && !this.f.isA(ASN.PrintableString)) {
            try {
                ASN1Object aSN1Object2 = DerCoder.decode((byte[])this.f.getValue());
                this.a = aSN1Object2.getValue();
            }
            catch (Exception exception) {
                this.a = this.f.getValue();
            }
        } else {
            this.a = this.f.getValue();
        }
        if (this.a == null) {
            throw new CodingException("Error parsing AVA: missing Attribute Value.");
        }
    }

    public AVA(String string) throws IllegalArgumentException {
        int n2 = string.indexOf(61);
        String string2 = string.substring(0, n2).trim();
        this.b = ObjectID.getInstance(string2);
        if (this.b == null) {
            throw new IllegalArgumentException("Unrecognized ObjectID name.");
        }
        this.a = string.substring(n2 + 1).trim();
    }

    public AVA(ObjectID objectID, Object object) throws IllegalArgumentException {
        if (objectID == null || object == null) {
            throw new IllegalArgumentException("Type and value have to be not null for creating an AVA!");
        }
        if (object instanceof ASN1Object) {
            this.a(objectID, (ASN1Object)object);
        } else {
            this.b = objectID;
            this.a = object;
        }
    }

    public AVA(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot create an AVA from a null object!");
        }
        this.decode(aSN1Object);
    }

    static {
        d = new Hashtable();
        e = ASN.PrintableString;
        AVA.defineEncoding(ObjectID.emailAddress, ASN.IA5String);
        AVA.defineEncoding(ObjectID.uniqueIdentifier, ASN.BIT_STRING);
    }
}

