/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.NULL;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKeyFactory;

public class AlgorithmID
implements ASN1Type {
    private ASN1Object a;
    private ObjectID b;
    public static AlgorithmID cms_cast_wrap;
    public static AlgorithmID cms_cast5_wrap;
    public static AlgorithmID cms_idea_wrap;
    public static AlgorithmID cms_rc2_wrap;
    public static AlgorithmID cms_3DES_wrap;
    public static AlgorithmID sha1;
    public static AlgorithmID sha;
    public static AlgorithmID md5;
    public static AlgorithmID md4;
    public static AlgorithmID md2;
    public static AlgorithmID aes_256_CBC;
    public static AlgorithmID aes_256_ECB;
    public static AlgorithmID aes_192_CBC;
    public static AlgorithmID aes_192_ECB;
    public static AlgorithmID aes_128_CBC;
    public static AlgorithmID aes_128_ECB;
    public static AlgorithmID rc5_CBC;
    public static AlgorithmID cast5_CBC;
    public static AlgorithmID idea_CBC;
    public static AlgorithmID des_CBC;
    public static AlgorithmID des_EDE3_CBC;
    public static AlgorithmID rc4;
    public static AlgorithmID rc2_CBC;
    public static AlgorithmID rsa;
    public static AlgorithmID pbeWithSHAAnd40BitRC2_CBC;
    public static AlgorithmID pbeWithSHAAnd128BitRC2_CBC;
    public static AlgorithmID pbeWithSHAAnd2_KeyTripleDES_CBC;
    public static AlgorithmID pbeWithSHAAnd3_KeyTripleDES_CBC;
    public static AlgorithmID pbeWithSHAAnd40BitRC4;
    public static AlgorithmID pbeWithSHAAnd128BitRC4;
    public static AlgorithmID pbeWithMD5AndDES_CBC;
    public static AlgorithmID ecdsaWithSHA1;
    public static AlgorithmID dsa_With_SHA1;
    public static AlgorithmID dsaWithSHA1;
    public static AlgorithmID dsaWithSHA;
    public static AlgorithmID dsaX957;
    public static AlgorithmID dsa;
    public static AlgorithmID sha1WithRSAEncryption;
    public static AlgorithmID md5WithRSAEncryption;
    public static AlgorithmID md4WithRSAEncryption;
    public static AlgorithmID md2WithRSAEncryption;
    public static AlgorithmID mgf1;
    public static AlgorithmID rsaESOAEP;
    public static AlgorithmID rsaEncryption;
    public static AlgorithmID esdh;
    public static AlgorithmID esdhKeyAgreement;
    public static AlgorithmID dhKeyAgreement;
    protected static Hashtable implementations;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.b.getName());
        if (this.a != null && !this.a.isA(ASN.NULL)) {
            stringBuffer.append(" with parameter");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object(boolean bl) {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b);
        if (this.a != null) {
            sEQUENCE.addComponent(this.a);
        } else if (bl) {
            this.a = new NULL();
            sEQUENCE.addComponent(this.a);
        }
        return sEQUENCE;
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(true);
    }

    public void setParameter(ASN1Object aSN1Object) {
        this.a = aSN1Object;
    }

    public void setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        try {
            this.a = new ASN1(algorithmParameters.getEncoded()).toASN1Object();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public Signature getSignatureInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? Signature.getInstance(this.b.getID()) : Signature.getInstance(this.b.getID(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? Signature.getInstance(this.b.getName()) : Signature.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? Signature.getInstance(this.getImplementationName()) : Signature.getInstance(this.getImplementationName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public Signature getSignatureInstance() throws NoSuchAlgorithmException {
        return this.getSignatureInstance(null);
    }

    public SecretKeyFactory getSecretKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? SecretKeyFactory.getInstance(this.getRawImplementationName()) : SecretKeyFactory.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? SecretKeyFactory.getInstance(this.b.getName()) : SecretKeyFactory.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? SecretKeyFactory.getInstance(this.b.getID()) : SecretKeyFactory.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? SecretKeyFactory.getInstance(this.getImplementationName()) : SecretKeyFactory.getInstance(this.getImplementationName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                    }
                }
            }
        }
    }

    public SecretKeyFactory getSecretKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getSecretKeyFactoryInstance(null);
    }

    public String getRawImplementationName() throws NoSuchAlgorithmException {
        String string = this.getImplementationName();
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public ASN1Object getParameter() {
        return this.a;
    }

    public String getName() {
        return this.b.getName();
    }

    public MessageDigest getMessageDigestInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? MessageDigest.getInstance(this.getImplementationName()) : MessageDigest.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? MessageDigest.getInstance(this.b.getName()) : MessageDigest.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? MessageDigest.getInstance(this.b.getID()) : MessageDigest.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        return this.getMessageDigestInstance(null);
    }

    public KeyPairGenerator getKeyPairGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyPairGenerator.getInstance(this.getImplementationName()) : KeyPairGenerator.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyPairGenerator.getInstance(this.b.getName()) : KeyPairGenerator.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyPairGenerator.getInstance(this.b.getID()) : KeyPairGenerator.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public KeyPairGenerator getKeyPairGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyPairGeneratorInstance(null);
    }

    public KeyGenerator getKeyGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyGenerator.getInstance(this.getRawImplementationName()) : KeyGenerator.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyGenerator.getInstance(this.b.getName()) : KeyGenerator.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyGenerator.getInstance(this.b.getID()) : KeyGenerator.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? KeyGenerator.getInstance(this.getImplementationName()) : KeyGenerator.getInstance(this.getImplementationName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                    }
                }
            }
        }
    }

    public KeyGenerator getKeyGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyGeneratorInstance(null);
    }

    public KeyFactory getKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyFactory.getInstance(this.getImplementationName()) : KeyFactory.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyFactory.getInstance(this.b.getName()) : KeyFactory.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyFactory.getInstance(this.b.getID()) : KeyFactory.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public KeyFactory getKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getKeyFactoryInstance(null);
    }

    public KeyAgreement getKeyAgreementInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyAgreement.getInstance(this.getImplementationName()) : KeyAgreement.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyAgreement.getInstance(this.b.getName()) : KeyAgreement.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyAgreement.getInstance(this.b.getID()) : KeyAgreement.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public KeyAgreement getKeyAgreementInstance() throws NoSuchAlgorithmException {
        return this.getKeyAgreementInstance(null);
    }

    public Object getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? this.getMessageDigestInstance() : this.getMessageDigestInstance(string);
        }
        catch (Exception exception) {
            try {
                return string == null ? this.getSignatureInstance() : this.getSignatureInstance(string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? this.getCipherInstance() : this.getCipherInstance(string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? this.getKeyAgreementInstance() : this.getKeyAgreementInstance(string);
                    }
                    catch (Exception exception4) {
                        try {
                            return string == null ? this.getKeyFactoryInstance() : this.getKeyFactoryInstance(string);
                        }
                        catch (Exception exception5) {
                            throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                        }
                    }
                }
            }
        }
    }

    public Object getInstance() throws NoSuchAlgorithmException {
        return this.getInstance(null);
    }

    public String getImplementationName() throws NoSuchAlgorithmException {
        String string = (String)implementations.get(this.b);
        if (string == null) {
            throw new NoSuchAlgorithmException("No implementation for: " + this.getName());
        }
        return string;
    }

    public Cipher getCipherInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? Cipher.getInstance(this.getImplementationName()) : Cipher.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? Cipher.getInstance(this.b.getName()) : Cipher.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? Cipher.getInstance(this.b.getID()) : Cipher.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public Cipher getCipherInstance() throws NoSuchAlgorithmException {
        return this.getCipherInstance(null);
    }

    private AlgorithmParameters a(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? AlgorithmParameters.getInstance(this.getRawImplementationName()) : AlgorithmParameters.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? AlgorithmParameters.getInstance(this.b.getName()) : AlgorithmParameters.getInstance(this.b.getName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? AlgorithmParameters.getInstance(this.b.getID()) : AlgorithmParameters.getInstance(this.b.getID(), string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? AlgorithmParameters.getInstance(this.getImplementationName()) : AlgorithmParameters.getInstance(this.getImplementationName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                    }
                }
            }
        }
    }

    private AlgorithmParameters a() throws NoSuchAlgorithmException {
        return this.a(null);
    }

    public AlgorithmParameters getAlgorithmParameters(String string, String string2) throws NoSuchAlgorithmException {
        try {
            if (this.a == null || this.a.isA(ASN.NULL)) {
                throw new NoSuchAlgorithmException("No algorithm parameters.");
            }
            AlgorithmParameters algorithmParameters = null;
            algorithmParameters = string != null ? (string2 == null ? AlgorithmParameters.getInstance(string) : AlgorithmParameters.getInstance(string, string2)) : this.a(string2);
            algorithmParameters.init(DerCoder.encode(this.a));
            return algorithmParameters;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("No such provider: " + string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public AlgorithmParameters getAlgorithmParameters(String string) throws NoSuchAlgorithmException {
        return this.getAlgorithmParameters(string, null);
    }

    public AlgorithmParameters getAlgorithmParameters() throws NoSuchAlgorithmException {
        if (this.a == null || this.a.isA(ASN.NULL)) {
            return null;
        }
        return this.getAlgorithmParameters(null, null);
    }

    public ObjectID getAlgorithm() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlgorithmID)) {
            return false;
        }
        return this.b.equals(((AlgorithmID)object).b);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.b = (ObjectID)aSN1Object.getComponentAt(0);
            try {
                this.a = aSN1Object.getComponentAt(1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.a = null;
            }
        }
        catch (Exception exception) {
            throw new CodingException("No ASN.1 AlgorithmID type!");
        }
    }

    public Object clone() {
        AlgorithmID algorithmID = new AlgorithmID();
        algorithmID.b = this.b;
        algorithmID.a = this.a;
        return algorithmID;
    }

    public static boolean changeObjectID(AlgorithmID algorithmID, ObjectID objectID) {
        try {
            String string = (String)implementations.get(algorithmID.b);
            algorithmID.b = objectID;
            implementations.put(objectID, string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean changeOIDString(AlgorithmID algorithmID, String string) {
        try {
            String string2 = algorithmID.b.getID();
            String string3 = algorithmID.b.getName();
            String string4 = algorithmID.b.getShortName();
            String string5 = (String)implementations.get(algorithmID.b);
            ObjectID objectID = null;
            objectID = string3.equals(string2) ? (string4.equals(string2) ? new ObjectID(string) : new ObjectID(string, "", string4)) : (string4.equals(string2) ? new ObjectID(string, string3) : new ObjectID(string, string3, string4));
            algorithmID.b = objectID;
            implementations.put(objectID, string5);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public AlgorithmID(String string, String string2, String string3) {
        this.b = new ObjectID(string, string2);
        implementations.put(this.b, string3);
    }

    public AlgorithmID(String string, String string2) {
        this.b = new ObjectID(string, string2);
    }

    public AlgorithmID(ObjectID objectID, ASN1Object aSN1Object) {
        this.b = objectID;
        this.a = aSN1Object;
    }

    public AlgorithmID(ObjectID objectID) {
        this.b = objectID;
        this.a = null;
    }

    public AlgorithmID(DerInputStream derInputStream) throws IOException {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.b = derInputStream2.readObjectID();
        try {
            this.a = DerCoder.decode(derInputStream);
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding algorithm parameter.");
        }
    }

    public AlgorithmID(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public AlgorithmID() {
        this.b = null;
        this.a = null;
    }

    static {
        implementations = new Hashtable();
        dhKeyAgreement = new AlgorithmID("1.2.840.113549.1.3.1", "DH Key Agreement", "DH");
        esdhKeyAgreement = new AlgorithmID("1.2.840.113549.1.9.16.3.5", "ESDH Key Agreement", "ESDH");
        esdh = new AlgorithmID("1.2.840.10046.2.1", "ESDH", "ESDH");
        rsaEncryption = new AlgorithmID("1.2.840.113549.1.1.1", "rsaEncryption", "RSA");
        rsaESOAEP = new AlgorithmID("1.2.840.113549.1.1.7", "rsaESOAEP", "RSA-OAEP");
        mgf1 = new AlgorithmID("1.2.840.113549.1.1.8", "MGF1", "MGF1");
        md2WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.2", "md2WithRSAEncryption", "MD2/RSA");
        md4WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.3", "md4WithRSAEncryption");
        md5WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.4", "md5WithRSAEncryption", "MD5/RSA");
        sha1WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.5", "sha1WithRSAEncryption", "SHA/RSA");
        dsa = new AlgorithmID("1.3.14.3.2.12", "DSA", "DSA");
        dsaX957 = new AlgorithmID("1.2.840.10040.4.1", "DSA", "DSAX957");
        dsaWithSHA = new AlgorithmID("1.3.14.3.2.13", "dsaWithSHA", "DSA");
        dsaWithSHA1 = new AlgorithmID("1.3.14.3.2.27", "dsaWithSHA1", "DSA");
        dsa_With_SHA1 = new AlgorithmID("1.2.840.10040.4.3", "dsa-with-sha1", "DSA");
        ecdsaWithSHA1 = new AlgorithmID("1.2.840.10045.4.1", "ecdsaWithSHA1", "ECDSA");
        pbeWithMD5AndDES_CBC = new AlgorithmID("1.2.840.113549.1.5.3", "PbeWithMD5AndDES-CBC", "PbeWithMD5AndDES_CBC");
        pbeWithSHAAnd128BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.1", "PbeWithSHAAnd128BitRC4");
        pbeWithSHAAnd40BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.2", "PbeWithSHAAnd40BitRC4");
        pbeWithSHAAnd3_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.3", "PbeWithSHAAnd3-KeyTripleDES-CBC", "PbeWithSHAAnd3_KeyTripleDES_CBC");
        pbeWithSHAAnd2_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.4", "PbeWithSHAAnd2-KeyTripleDES-CBC");
        pbeWithSHAAnd128BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.5", "PbeWithSHAAnd128BitRC2-CBC");
        pbeWithSHAAnd40BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.6", "PbeWithSHAAnd40BitRC2-CBC", "PbeWithSHAAnd40BitRC2_CBC");
        rsa = new AlgorithmID("2.5.8.1.1", "RSA", "RSA");
        rc2_CBC = new AlgorithmID("1.2.840.113549.3.2", "RC2-CBC", "RC2/CBC/PKCS5Padding");
        rc4 = new AlgorithmID("1.2.840.113549.3.4", "RC4", "RC4/ECB/NoPadding");
        des_EDE3_CBC = new AlgorithmID("1.2.840.113549.3.7", "DES-EDE3-CBC", "3DES/CBC/PKCS5Padding");
        des_CBC = new AlgorithmID("1.3.14.3.2.7", "DES-CBC", "DES/CBC/PKCS5Padding");
        idea_CBC = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.2", "IDEA-CBC", "IDEA/CBC/PKCS5Padding");
        cast5_CBC = new AlgorithmID("1.2.840.113533.7.66.10", "CAST5-CBC", "CAST5/CBC/PKCS5Padding");
        rc5_CBC = new AlgorithmID("1.2.840.113549.3.8", "RC5-CBC", "RC5/CBC/PKCS5Padding");
        aes_128_ECB = new AlgorithmID("2.16.840.1.101.3.4.1.1", "AES-128-ECB", "AES/ECB/PKCS5Padding");
        aes_128_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.2", "AES-128-CBC", "AES/CBC/PKCS5Padding");
        aes_192_ECB = new AlgorithmID("2.16.840.1.101.3.4.1.21", "AES-192-ECB", "AES/ECB/PKCS5Padding");
        aes_192_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.22", "AES-192-CBC", "AES/CBC/PKCS5Padding");
        aes_256_ECB = new AlgorithmID("2.16.840.1.101.3.4.1.41", "AES-256-ECB", "AES/ECB/PKCS5Padding");
        aes_256_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.42", "AES-256-CBC", "AES/CBC/PKCS5Padding");
        md2 = new AlgorithmID("1.2.840.113549.2.2", "MD2", "MD2");
        md4 = new AlgorithmID("1.2.840.113549.2.4", "MD4");
        md5 = new AlgorithmID("1.2.840.113549.2.5", "MD5", "MD5");
        sha1 = sha = new AlgorithmID("1.3.14.3.2.26", "SHA", "SHA");
        cms_3DES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.6", "CMS-3DES-Wrap", "3DESWrap3DES");
        cms_rc2_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.7", "CMS-RC2-Wrap", "RC2WrapRC2");
        cms_idea_wrap = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.6", "CMS-IDEA-Wrap", "IDEAWrapIDEA");
        cms_cast5_wrap = new AlgorithmID("1.2.840.113533.7.66.15", "CMS-CAST128-Wrap", "CAST128WrapCAST128");
        cms_cast_wrap = new AlgorithmID("1.2.840.113533.7.66.15", "CMS-CAST-Wrap", "CASTWrapCAST");
        new AlgorithmID("1.2.840.113549.1.1.5", "sha1WithRSAEncryption", "SHA/RSA");
        new AlgorithmID("1.2.840.10040.4.1", "DSA", "DSA");
        new AlgorithmID("1.2.840.10040.4.3", "DSAWithSHA1", "DSA");
    }
}

