/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Name;
import iaik.utils.Util;
import java.security.Principal;

public class GeneralName {
    private Object b;
    private int a = -1;
    public static int registeredID;
    public static int iPAddress;
    public static int uniformResourceIdentifier;
    public static int ediPartyName;
    public static int directoryName;
    public static int x400Address;
    public static int dNSName;
    public static int rfc822Name;
    public static int otherName;
    private static final boolean c = false;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.a) {
            case 0: {
                stringBuffer.append("otherName");
                break;
            }
            case 1: {
                stringBuffer.append("rfc822Name: ");
                break;
            }
            case 2: {
                stringBuffer.append("dNSName: ");
                break;
            }
            case 3: {
                stringBuffer.append("x400Address: ");
                break;
            }
            case 4: {
                stringBuffer.append("directoryName: ");
                break;
            }
            case 5: {
                stringBuffer.append("ediPartyName: ");
                break;
            }
            case 6: {
                stringBuffer.append("uniformResourceIdentifier: ");
                break;
            }
            case 7: {
                stringBuffer.append("iPAddress: ");
                break;
            }
            case 8: {
                stringBuffer.append("registeredID: ");
                break;
            }
            default: {
                stringBuffer.append("undefined");
            }
        }
        if (this.a > 0) {
            stringBuffer.append(this.b.toString());
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        ASN1Object aSN1Object = null;
        boolean bl = false;
        switch (this.a) {
            case 0: {
                bl = true;
                if (this.b instanceof ASN1Object[]) {
                    aSN1Object = new SEQUENCE();
                    aSN1Object.addComponent(((ASN1Object[])this.b)[0]);
                    aSN1Object.addComponent(((ASN1Object[])this.b)[1]);
                    break;
                }
                aSN1Object = (ASN1Object)this.b;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                aSN1Object = new OCTET_STRING(Util.toASCIIBytes((String)this.b));
                bl = true;
                break;
            }
            case 7: {
                aSN1Object = new OCTET_STRING(((String)this.b).getBytes());
                bl = true;
                break;
            }
            case 4: {
                aSN1Object = ((Name)this.b).toASN1Object();
                break;
            }
            case 8: {
                aSN1Object = (ObjectID)this.b;
                break;
            }
            default: {
                throw new CodingException("GeneralName: type " + this.a + " not implemented yet!");
            }
        }
        return new CON_SPEC(this.a, aSN1Object, bl);
    }

    public int getType() {
        return this.a;
    }

    public Object getName() {
        return this.b;
    }

    public GeneralName(ASN1Object aSN1Object) throws CodingException {
        ASN1Object aSN1Object2 = null;
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("No GeneralName structure!");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        this.a = aSN1Object.getAsnType().getTag();
        switch (this.a) {
            case 0: {
                this.b = cON_SPEC.getValue();
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof OCTET_STRING)) {
                    throw new CodingException("Cannot parse GeneralName. Expected OCTET_STRING!");
                }
                this.b = Util.toASCIIString((byte[])aSN1Object2.getValue());
                break;
            }
            case 7: {
                cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof OCTET_STRING)) {
                    throw new CodingException("Cannot parse GeneralName. Expected OCTET_STRING!");
                }
                this.b = new String((byte[])aSN1Object2.getValue());
                break;
            }
            case 3: {
                throw new CodingException("Cannot parse GeneralName. GeneralType x400Address not supported!");
            }
            case 4: {
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof SEQUENCE)) {
                    throw new CodingException("Cannot parse GeneralName of type directoryName!  Name has to be a SEQUENCE!");
                }
                this.b = new Name(aSN1Object2);
                break;
            }
            case 5: {
                throw new CodingException("Cannot parse GeneralName. GeneralType ediPartyName not supported!");
            }
            case 8: {
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof ObjectID)) {
                    throw new CodingException("Cannot parse GeneralName of type registeredID. Expected an ObjectID instance!");
                }
                this.b = (ObjectID)aSN1Object2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot parse GeneralName! Illegal type specification! Type has to be in the range of 0...8!");
            }
        }
    }

    public GeneralName(int n2, Object object) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                if (object instanceof ASN1Object || object instanceof ASN1Object[]) break;
                throw new IllegalArgumentException("Cannot create GeneralName! Expecting ASN1Object or an array of ASN1Objectfor type otherName!");
            }
            case 3: {
                throw new IllegalArgumentException("Cannot create GeneralName! GeneralName type x400Address not supported!");
            }
            case 5: {
                throw new IllegalArgumentException("Cannot create GeneralName! GeneralName type ediPartyName not supported!");
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                if (object instanceof String) break;
                throw new IllegalArgumentException("Cannot create GeneralName! Wrong generalName argument! Expected a String instance!");
            }
            case 4: {
                if (object instanceof Principal) break;
                throw new IllegalArgumentException("Cannot create GeneralName type directoryName! Wrong generalName argument! Expected a Name instance!");
            }
            case 8: {
                if (object instanceof ObjectID) break;
                throw new IllegalArgumentException("Cannot create GeneralName type registeredID! Wrong generalName argument! Expected an ObjectID instance!");
            }
            default: {
                throw new IllegalArgumentException("Cannot create GeneralName! Illegal type specification: " + n2 + "!. " + "Type has to be in the range of 0...8!");
            }
        }
        this.b = object;
        this.a = n2;
    }

    static {
        otherName = 0;
        rfc822Name = 1;
        dNSName = 2;
        x400Address = 3;
        directoryName = 4;
        ediPartyName = 5;
        uniformResourceIdentifier = 6;
        iPAddress = 7;
        registeredID = 8;
    }
}

