/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AVA;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.utils.RFC2253NameParserException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class Name
implements ASN1Type,
Principal {
    private Vector a = new Vector();

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.a.size() - 1;
        while (n2 >= 0) {
            RDN rDN = (RDN)this.a.elementAt(n2);
            stringBuffer.append(rDN.toString(bl));
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            if (bl) {
                stringBuffer.append("\n");
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        int n2 = 0;
        while (n2 < this.a.size()) {
            sEQUENCE.addComponent(((RDN)this.a.elementAt(n2)).toASN1Object());
            ++n2;
        }
        return sEQUENCE;
    }

    public boolean removeRDN(ObjectID objectID) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.a.size()) {
            RDN rDN = (RDN)this.a.elementAt(n2);
            if (rDN.getAVA(objectID) != null) {
                this.a.removeElementAt(n2--);
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.a.size() - 1;
        while (n2 >= 0) {
            RDN rDN = (RDN)this.a.elementAt(n2);
            stringBuffer.append(rDN.getRFC2253String());
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    public String[] getRDNs(ObjectID objectID) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            AVA aVA = objectArray.getAVA(objectID);
            if (aVA == null) continue;
            vector.addElement((String)aVA.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object[] getRDNValues(ObjectID objectID) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            AVA aVA = objectArray.getAVA(objectID);
            if (aVA == null) continue;
            vector.addElement(aVA.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getRDNValue(ObjectID objectID) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN = (RDN)enumeration.nextElement();
            AVA aVA = rDN.getAVA(objectID);
            if (aVA == null) continue;
            return aVA.getValue();
        }
        return null;
    }

    public String getRDN(ObjectID objectID) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN = (RDN)enumeration.nextElement();
            AVA aVA = rDN.getAVA(objectID);
            if (aVA == null) continue;
            return (String)aVA.getValue();
        }
        return null;
    }

    public String getName() {
        return this.toString(false);
    }

    public byte[] getEncoded() {
        try {
            return new ASN1(this.toASN1Object()).toByteArray();
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception.toString());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        if (this.a.size() != name.a.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.a.size()) {
            RDN rDN;
            RDN rDN2 = (RDN)this.a.elementAt(n2);
            if (!rDN2.equals(rDN = (RDN)name.a.elementAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Enumeration elements() {
        return this.a.elements();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object.isA(ASN.SET)) {
            RDN rDN = new RDN(aSN1Object);
            this.a.addElement(rDN);
        } else {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                RDN rDN = new RDN(aSN1Object.getComponentAt(n2));
                this.a.addElement(rDN);
                ++n2;
            }
        }
    }

    public void addRDN(RDN rDN) {
        this.a.addElement(rDN);
    }

    public void addRDN(ObjectID objectID, Object object) {
        this.a.addElement(new RDN(objectID, object));
    }

    public Name(byte[] byArray) throws CodingException {
        this(new ASN1(byArray).toASN1Object());
    }

    public Name(String string) {
        int n2 = -1;
        String string2 = string;
        RDN rDN = null;
        do {
            n2 = string2.lastIndexOf(44);
            int n3 = string2.lastIndexOf(34);
            if (n3 > n2) {
                n3 = string2.lastIndexOf(34, n3 - 1);
                n2 = string2.lastIndexOf(44, n3);
            }
            if (n2 == -1) {
                rDN = new RDN(string2.trim());
            } else {
                rDN = new RDN(string2.substring(n2 + 1).trim());
                string2 = string2.substring(0, n2);
            }
            this.a.addElement(rDN);
        } while (n2 >= 0);
    }

    public Name(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public Name() {
    }
}

