/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.VisibleString;
import iaik.utils.InternalErrorException;
import java.math.BigInteger;

public class PolicyQualifierInfo {
    String d = null;
    int[] c = null;
    String b = null;
    String e = null;
    ObjectID a = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("policyQualifierId: " + this.a.getName() + "\n");
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            stringBuffer.append("CPS URI: " + this.e + "\n");
        } else {
            if (this.b != null) {
                stringBuffer.append("organization: " + this.b + "\n");
            }
            if (this.c != null) {
                int n2 = 0;
                while (n2 < this.c.length) {
                    stringBuffer.append("noticeNumber[" + n2 + "]: " + this.c[n2] + "\n");
                    ++n2;
                }
            }
            if (this.d != null) {
                stringBuffer.append("displayText: " + this.d + "\n");
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a);
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            sEQUENCE.addComponent(new IA5String(this.e));
        } else if (this.a.equals(ObjectID.id_pkix_unotice)) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            if (this.b != null) {
                SEQUENCE sEQUENCE3 = new SEQUENCE();
                sEQUENCE3.addComponent(new VisibleString(this.b));
                SEQUENCE sEQUENCE4 = new SEQUENCE();
                int n2 = 0;
                while (n2 < this.c.length) {
                    sEQUENCE4.addComponent(new INTEGER(this.c[n2]));
                    ++n2;
                }
                sEQUENCE3.addComponent(sEQUENCE4);
                sEQUENCE2.addComponent(sEQUENCE3);
            }
            if (this.d != null) {
                sEQUENCE2.addComponent(new VisibleString(this.d));
            }
            sEQUENCE.addComponent(sEQUENCE2);
        } else {
            throw new InternalErrorException("Unknown policyQualifierId");
        }
        return sEQUENCE;
    }

    public PolicyQualifierInfo(String string, int[] nArray, String string2) {
        this.a = ObjectID.id_pkix_unotice;
        this.b = string;
        this.c = nArray;
        if (this.b == null) {
            this.c = null;
        }
        if (this.c == null) {
            this.b = null;
        }
        this.d = string2;
    }

    public PolicyQualifierInfo(String string) {
        this.a = ObjectID.id_pkix_cps;
        this.e = string;
    }

    public PolicyQualifierInfo(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No PolicyQualifierInfo!");
        }
        if (aSN1Object.countComponents() != 2) {
            throw new CodingException("Invalid PolicyQualifierInfo!");
        }
        this.a = (ObjectID)aSN1Object.getComponentAt(0);
        if (this.a.equals(ObjectID.id_pkix_cps)) {
            this.e = (String)aSN1Object.getComponentAt(1).getValue();
        } else if (this.a.equals(ObjectID.id_pkix_unotice)) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(1);
            int n2 = 0;
            while (n2 < aSN1Object2.countComponents()) {
                ASN1Object aSN1Object3 = aSN1Object2.getComponentAt(n2);
                if (aSN1Object3.isA(ASN.SEQUENCE)) {
                    if (aSN1Object3.countComponents() != 2) {
                        throw new CodingException("Invalid NoticeReference!");
                    }
                    this.b = (String)aSN1Object3.getComponentAt(0).getValue();
                    ASN1Object aSN1Object4 = aSN1Object3.getComponentAt(1);
                    this.c = new int[aSN1Object4.countComponents()];
                    int n3 = 0;
                    while (n3 < aSN1Object4.countComponents()) {
                        this.c[n3] = ((BigInteger)aSN1Object4.getComponentAt(n3).getValue()).intValue();
                        ++n3;
                    }
                } else if (aSN1Object3.isA(ASN.VisibleString) || aSN1Object3.isA(ASN.GeneralString)) {
                    this.d = (String)aSN1Object3.getValue();
                } else {
                    throw new CodingException("Unknown UserNotice!");
                }
                ++n2;
            }
        } else {
            throw new CodingException("Unknown policyQualifierId!");
        }
    }
}

