/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs8;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public abstract class PrivateKeyInfo
implements PrivateKey,
ASN1Type,
Serializable {
    protected AlgorithmID private_key_algorithm;
    protected ASN1 private_key_info;
    int a = 0;

    public void writeTo(OutputStream outputStream) throws IOException {
        this.private_key_info.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This PrivateKeyInfo contains a ");
        stringBuffer.append(String.valueOf(this.private_key_algorithm.getName()) + " key.");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        return this.private_key_info.toASN1Object();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.private_key_info = new ASN1(objectInputStream);
            this.c();
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + invalidKeyException.toString());
        }
    }

    public static PrivateKey getPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            return PrivateKeyInfo.getPrivateKey(DerCoder.decode(byArray));
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo.");
        }
    }

    public static PrivateKey getPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        AlgorithmID algorithmID = null;
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(DerCoder.encode(aSN1Object));
            algorithmID = new AlgorithmID(aSN1Object.getComponentAt(1));
            KeyFactory keyFactory = algorithmID.toString().startsWith("DSA") ? algorithmID.getKeyFactoryInstance("Entrust") : algorithmID.getKeyFactoryInstance();
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("PublicKey algorithm not implemented: " + algorithmID.getName());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo.");
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo.");
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo.");
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        return this.private_key_info.toByteArray();
    }

    public abstract String getAlgorithm();

    public boolean equals(Object object) {
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        return CryptoUtils.equalsBlock(this.getEncoded(), ((PrivateKey)object).getEncoded());
    }

    protected abstract byte[] encode();

    protected abstract void decode(byte[] var1) throws InvalidKeyException;

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.private_key_info = new ASN1(aSN1Object);
        try {
            this.c();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException(invalidKeyException.toString());
        }
    }

    private void c() throws InvalidKeyException {
        try {
            this.a = ((BigInteger)this.private_key_info.getComponentAt(0).getValue()).intValue();
            this.private_key_algorithm = new AlgorithmID(this.private_key_info.getComponentAt(1));
            this.decode((byte[])this.private_key_info.getComponentAt(2).getValue());
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + exception.toString());
        }
    }

    protected void createPrivateKeyInfo() {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.a));
            sEQUENCE.addComponent(this.private_key_algorithm.toASN1Object());
            sEQUENCE.addComponent(new OCTET_STRING(this.encode()));
            this.private_key_info = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("CodingException!");
        }
    }

    public PrivateKeyInfo(byte[] byArray) throws InvalidKeyException {
        try {
            this.private_key_info = new ASN1(byArray);
            this.c();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public PrivateKeyInfo(InputStream inputStream) throws IOException, InvalidKeyException {
        try {
            this.private_key_info = new ASN1(inputStream);
            this.c();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public PrivateKeyInfo(ASN1Object aSN1Object) throws InvalidKeyException {
        try {
            this.private_key_info = new ASN1(aSN1Object);
            this.c();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    protected PrivateKeyInfo() {
    }
}

