/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import com.entrust.toolkit.security.fips.SecurityEngine;
import iaik.security.dsa.DSAParams;
import iaik.security.dsa.DSAPrivateKey;
import iaik.security.dsa.DSAPublicKey;
import iaik.security.md.SHA;
import iaik.security.random.SecRandom;
import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Hashtable;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private static final byte[] v;
    private static final BigInteger t;
    private static final BigInteger u;
    private static final BigInteger s;
    private boolean m;
    private DSAParams r;
    private int k;
    private MessageDigest l = new SHA();
    private SecureRandom a;
    private static Hashtable f;
    private static final byte[] p;
    private static final byte[] d;
    private static final byte[] i;
    private static final byte[] q;
    private static final byte[] e;
    private static final byte[] j;
    private static final byte[] n;
    private static final byte[] b;
    private static final byte[] g;
    private static final byte[] o;
    private static final byte[] c;
    private static final byte[] h;
    private static final boolean x = false;
    private static final boolean w = false;

    private void a(KeyPair keyPair) {
        try {
            Signature signature = Signature.getInstance("DSA", "Entrust");
            signature.initSign(keyPair.getPrivate());
            signature.update(v);
            byte[] byArray = signature.sign();
            signature.initVerify(keyPair.getPublic());
            signature.update(v);
            if (!signature.verify(byArray)) {
                SecurityEngine.setErrorState("DSA pair-wise consistency test failed");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SecurityEngine.setErrorState("Unable to perform pair-wise consistency test - please ensure all required Providers are registered");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            SecurityEngine.setErrorState("Unable to perform pair-wise consistency test - please ensure all required Providers are registered");
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (SignatureException signatureException) {}
    }

    private BigInteger a(DSAParams dSAParams, BigInteger bigInteger) {
        BigInteger bigInteger2 = dSAParams.getP();
        BigInteger bigInteger3 = dSAParams.getG();
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
        return bigInteger4;
    }

    private BigInteger a(DSAParams dSAParams) {
        BigInteger bigInteger = dSAParams.getQ();
        int n2 = bigInteger.bitLength() + 8;
        BigInteger bigInteger2 = new BigInteger(n2, this.a);
        BigInteger bigInteger3 = bigInteger2.mod(bigInteger.subtract(u));
        BigInteger bigInteger4 = bigInteger3.add(u);
        return bigInteger4;
    }

    private DSAParams c(int n2) {
        DSAParams dSAParams = DSAKeyPairGenerator.a(n2);
        if (this.m || dSAParams == null) {
            BigInteger[] bigIntegerArray = this.b((n2 - 512) / 64);
            BigInteger bigInteger = bigIntegerArray[0];
            BigInteger bigInteger2 = bigIntegerArray[1];
            BigInteger bigInteger3 = this.a(bigInteger, bigInteger2);
            dSAParams = new DSAParams(bigInteger, bigInteger2, bigInteger3);
            DSAKeyPairGenerator.a(n2, dSAParams);
        }
        return dSAParams;
    }

    private synchronized BigInteger[] b(int n2) {
        if (n2 < 0 || n2 > 8) {
            return null;
        }
        int n3 = 512 + 64 * n2;
        int n4 = (n3 - 1) / 160;
        int n5 = (n3 - 1) % 160;
        BigInteger bigInteger = t.pow(159);
        BigInteger bigInteger2 = t.pow(160);
        this.l.reset();
        while (true) {
            BigInteger bigInteger3;
            BigInteger bigInteger4 = new BigInteger(160, this.a);
            BigInteger bigInteger5 = bigInteger4.or(bigInteger);
            BigInteger bigInteger6 = bigInteger5.add(u).mod(bigInteger2);
            BigInteger[] bigIntegerArray = new BigInteger(1, this.l.digest(bigInteger5.toByteArray()));
            BigInteger bigInteger7 = bigIntegerArray.xor(bigInteger3 = new BigInteger(1, this.l.digest(bigInteger6.toByteArray())));
            BigInteger bigInteger8 = bigInteger7.or(bigInteger).or(u);
            if (!NumberTheory.isProbablePrime(bigInteger8)) continue;
            int n6 = 0;
            int n7 = 2;
            do {
                BigInteger bigInteger9;
                BigInteger bigInteger10;
                bigIntegerArray = new BigInteger[n4 + 1];
                bigInteger3 = BigInteger.valueOf(n7);
                int n8 = 0;
                while (n8 <= n4) {
                    bigInteger10 = BigInteger.valueOf(n8);
                    bigIntegerArray[n8] = new BigInteger(1, this.l.digest(bigInteger5.add(bigInteger3).add(bigInteger10).mod(bigInteger2).toByteArray()));
                    ++n8;
                }
                bigIntegerArray[n4] = bigIntegerArray[n4].mod(t.pow(n5));
                bigInteger10 = s;
                int n9 = 0;
                int n10 = 0;
                while (n10 <= n4) {
                    bigInteger10 = bigInteger10.add(bigIntegerArray[n10].shiftLeft(n9));
                    n9 += 160;
                    ++n10;
                }
                BigInteger bigInteger11 = bigInteger10.add(t.pow(n3 - 1));
                BigInteger bigInteger12 = bigInteger11.subtract((bigInteger9 = bigInteger11.mod(bigInteger8.shiftLeft(1))).subtract(u));
                if (bigInteger12.compareTo(t.pow(n3 - 1)) >= 0 && NumberTheory.isProbablePrime(bigInteger12)) {
                    BigInteger[] bigIntegerArray2 = new BigInteger[]{bigInteger12, bigInteger8};
                    return bigIntegerArray2;
                }
                n7 += n4 + 1;
            } while (++n6 < 4096);
        }
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4 = bigInteger.subtract(u);
        BigInteger bigInteger5 = bigInteger4.divide(bigInteger2);
        BigInteger bigInteger6 = u;
        do {
            bigInteger3 = bigInteger6.modPow(bigInteger5, bigInteger);
            bigInteger6 = bigInteger6.add(u);
        } while (bigInteger3.equals(u));
        return bigInteger3;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not a DSAParameterSpec");
        }
        DSAParams dSAParams = (DSAParams)((Object)algorithmParameterSpec);
        this.initialize(dSAParams, secureRandom);
    }

    public void initialize(java.security.interfaces.DSAParams dSAParams, SecureRandom secureRandom) throws InvalidParameterException {
        this.a = secureRandom;
        this.k = -1;
        this.r = new DSAParams(dSAParams);
    }

    public void initialize(int n2, boolean bl, SecureRandom secureRandom) throws InvalidParameterException {
        this.a = null;
        this.k = n2;
        this.m = bl;
        this.r = null;
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.k = n2;
        this.r = null;
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    private static void a() {
        f = new Hashtable();
        DSAKeyPairGenerator.a(512, new DSAParams(new BigInteger(h), new BigInteger(c), new BigInteger(o)));
        DSAKeyPairGenerator.a(768, new DSAParams(new BigInteger(g), new BigInteger(b), new BigInteger(n)));
        DSAKeyPairGenerator.a(1024, new DSAParams(new BigInteger(j), new BigInteger(e), new BigInteger(q)));
        DSAKeyPairGenerator.a(2048, new DSAParams(new BigInteger(i), new BigInteger(d), new BigInteger(p)));
    }

    private static DSAParams a(int n2) {
        return (DSAParams)f.get(new Integer(n2));
    }

    public KeyPair generateKeyPair() {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.a == null) {
            this.a = SecRandom.getDefault();
        }
        if (this.k == -1) {
            this.k = 1024;
        }
        if (this.k < 512) {
            this.k = 512;
        }
        if (this.k > 1024) {
            this.k = 1024;
        }
        this.k &= 0xFFC0;
        if (this.r == null) {
            this.r = this.c(this.k);
        }
        BigInteger bigInteger = this.a(this.r);
        BigInteger bigInteger2 = this.a(this.r, bigInteger);
        DSAPublicKey dSAPublicKey = new DSAPublicKey(bigInteger2, this.r);
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInteger, this.r);
        KeyPair keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
        if (SecurityEngine.isInFIPSMode()) {
            this.a(keyPair);
        }
        return keyPair;
    }

    private static boolean a(int n2, DSAParams dSAParams) {
        return f.put(new Integer(n2), dSAParams) == null;
    }

    public DSAKeyPairGenerator() {
        super("DSA");
        DSAKeyPairGenerator.a();
        this.a = null;
        this.k = -1;
        this.m = false;
        this.r = null;
    }

    static {
        byte[] byArray = new byte[65];
        byArray[1] = -63;
        byArray[2] = 108;
        byArray[3] = -70;
        byArray[4] = -45;
        byArray[5] = 77;
        byArray[6] = 71;
        byArray[7] = 94;
        byArray[8] = -59;
        byArray[9] = 57;
        byArray[10] = 102;
        byArray[11] = -107;
        byArray[12] = -42;
        byArray[13] = -108;
        byArray[14] = -68;
        byArray[15] = -117;
        byArray[16] = -60;
        byArray[17] = 126;
        byArray[18] = 89;
        byArray[19] = -114;
        byArray[20] = 35;
        byArray[21] = -75;
        byArray[22] = -87;
        byArray[23] = -41;
        byArray[24] = -59;
        byArray[25] = -50;
        byArray[26] = -56;
        byArray[27] = 45;
        byArray[28] = 101;
        byArray[29] = -74;
        byArray[30] = -126;
        byArray[31] = 125;
        byArray[32] = 68;
        byArray[33] = -23;
        byArray[34] = 83;
        byArray[35] = 120;
        byArray[36] = 72;
        byArray[37] = 71;
        byArray[38] = 48;
        byArray[39] = -64;
        byArray[40] = -65;
        byArray[41] = -15;
        byArray[42] = -12;
        byArray[43] = -53;
        byArray[44] = 86;
        byArray[45] = -12;
        byArray[46] = 124;
        byArray[47] = 110;
        byArray[48] = 81;
        byArray[49] = 5;
        byArray[50] = 75;
        byArray[51] = -24;
        byArray[52] = -110;
        byArray[54] = -13;
        byArray[55] = 13;
        byArray[56] = 67;
        byArray[57] = -36;
        byArray[58] = 79;
        byArray[59] = -17;
        byArray[60] = -106;
        byArray[61] = 36;
        byArray[62] = -44;
        byArray[63] = 102;
        byArray[64] = 91;
        h = byArray;
        byte[] byArray2 = new byte[21];
        byArray2[1] = -73;
        byArray2[2] = -72;
        byArray2[3] = 16;
        byArray2[4] = -75;
        byArray2[5] = -116;
        byArray2[6] = 9;
        byArray2[7] = 52;
        byArray2[8] = -10;
        byArray2[9] = 66;
        byArray2[10] = -121;
        byArray2[11] = -113;
        byArray2[12] = 54;
        byArray2[13] = 11;
        byArray2[14] = -106;
        byArray2[15] = -41;
        byArray2[16] = -52;
        byArray2[17] = 38;
        byArray2[18] = -75;
        byArray2[19] = 62;
        byArray2[20] = 77;
        c = byArray2;
        byte[] byArray3 = new byte[64];
        byArray3[0] = 76;
        byArray3[1] = 83;
        byArray3[2] = -57;
        byArray3[3] = 38;
        byArray3[4] = -67;
        byArray3[5] = -65;
        byArray3[6] = -69;
        byArray3[7] = -90;
        byArray3[8] = 84;
        byArray3[9] = -99;
        byArray3[10] = 126;
        byArray3[11] = 115;
        byArray3[12] = 25;
        byArray3[13] = 57;
        byArray3[14] = -58;
        byArray3[15] = -55;
        byArray3[16] = 58;
        byArray3[17] = -122;
        byArray3[18] = -102;
        byArray3[19] = 39;
        byArray3[20] = -59;
        byArray3[21] = -37;
        byArray3[22] = 23;
        byArray3[23] = -70;
        byArray3[24] = 60;
        byArray3[25] = -84;
        byArray3[26] = 88;
        byArray3[27] = -99;
        byArray3[28] = 123;
        byArray3[29] = 62;
        byArray3[31] = 63;
        byArray3[32] = -89;
        byArray3[33] = 53;
        byArray3[34] = -14;
        byArray3[35] = -112;
        byArray3[36] = -49;
        byArray3[37] = -48;
        byArray3[38] = 122;
        byArray3[39] = 62;
        byArray3[40] = -15;
        byArray3[41] = 15;
        byArray3[42] = 53;
        byArray3[43] = 21;
        byArray3[44] = 95;
        byArray3[45] = 26;
        byArray3[46] = 46;
        byArray3[47] = -9;
        byArray3[48] = 3;
        byArray3[49] = 53;
        byArray3[50] = -81;
        byArray3[51] = 123;
        byArray3[52] = 106;
        byArray3[53] = 82;
        byArray3[54] = 17;
        byArray3[55] = -95;
        byArray3[56] = 16;
        byArray3[57] = 53;
        byArray3[58] = 24;
        byArray3[59] = -5;
        byArray3[60] = -92;
        byArray3[61] = 78;
        byArray3[62] = -105;
        byArray3[63] = 24;
        o = byArray3;
        byte[] byArray4 = new byte[97];
        byArray4[1] = -28;
        byArray4[2] = -3;
        byArray4[3] = -67;
        byArray4[4] = -20;
        byArray4[5] = 39;
        byArray4[6] = 58;
        byArray4[7] = -72;
        byArray4[8] = -122;
        byArray4[9] = 46;
        byArray4[10] = 39;
        byArray4[11] = 109;
        byArray4[12] = 95;
        byArray4[13] = -18;
        byArray4[14] = 103;
        byArray4[15] = 72;
        byArray4[16] = -78;
        byArray4[17] = 63;
        byArray4[18] = -52;
        byArray4[19] = 114;
        byArray4[20] = 101;
        byArray4[21] = -1;
        byArray4[22] = -58;
        byArray4[24] = -51;
        byArray4[25] = 1;
        byArray4[26] = -32;
        byArray4[27] = 51;
        byArray4[28] = 104;
        byArray4[29] = -86;
        byArray4[30] = -75;
        byArray4[31] = 72;
        byArray4[32] = 114;
        byArray4[33] = -86;
        byArray4[34] = 108;
        byArray4[35] = -104;
        byArray4[36] = -12;
        byArray4[37] = -41;
        byArray4[38] = -106;
        byArray4[39] = -69;
        byArray4[40] = 125;
        byArray4[41] = -112;
        byArray4[42] = -52;
        byArray4[43] = -77;
        byArray4[44] = 106;
        byArray4[45] = 69;
        byArray4[46] = -11;
        byArray4[47] = 90;
        byArray4[48] = 5;
        byArray4[49] = -69;
        byArray4[50] = -96;
        byArray4[51] = 109;
        byArray4[52] = -35;
        byArray4[53] = -43;
        byArray4[54] = 61;
        byArray4[55] = 27;
        byArray4[56] = 65;
        byArray4[57] = 25;
        byArray4[58] = 96;
        byArray4[59] = -38;
        byArray4[60] = 9;
        byArray4[61] = 111;
        byArray4[62] = -84;
        byArray4[63] = 7;
        byArray4[64] = 95;
        byArray4[65] = 40;
        byArray4[66] = 51;
        byArray4[67] = -65;
        byArray4[68] = -113;
        byArray4[69] = 23;
        byArray4[70] = 59;
        byArray4[71] = -22;
        byArray4[72] = -106;
        byArray4[73] = -54;
        byArray4[74] = 83;
        byArray4[75] = 2;
        byArray4[76] = 106;
        byArray4[77] = 67;
        byArray4[78] = -79;
        byArray4[79] = 124;
        byArray4[80] = -100;
        byArray4[82] = -3;
        byArray4[83] = 81;
        byArray4[84] = -74;
        byArray4[85] = -98;
        byArray4[86] = -92;
        byArray4[87] = 4;
        byArray4[88] = -64;
        byArray4[89] = -42;
        byArray4[90] = 9;
        byArray4[91] = 107;
        byArray4[92] = -86;
        byArray4[93] = 101;
        byArray4[94] = 75;
        byArray4[95] = -35;
        byArray4[96] = 43;
        g = byArray4;
        byte[] byArray5 = new byte[21];
        byArray5[1] = -125;
        byArray5[2] = -36;
        byArray5[3] = -107;
        byArray5[4] = -78;
        byArray5[5] = 5;
        byArray5[6] = 106;
        byArray5[7] = 105;
        byArray5[8] = -92;
        byArray5[9] = -29;
        byArray5[10] = -120;
        byArray5[11] = 23;
        byArray5[12] = 114;
        byArray5[13] = -77;
        byArray5[14] = 4;
        byArray5[15] = 106;
        byArray5[16] = 119;
        byArray5[17] = 2;
        byArray5[18] = 26;
        byArray5[19] = 125;
        byArray5[20] = 105;
        b = byArray5;
        n = new byte[]{98, -7, 116, 90, 6, -5, 15, -93, -87, 78, -74, -26, -40, -3, 78, -56, 28, -32, 75, 26, 102, -12, -62, -25, -32, -4, 43, 116, 81, 37, 41, -45, 56, 22, -62, -90, -65, -112, 58, 23, -24, 64, 102, 66, -22, 76, -14, -98, 127, -42, -47, 46, 22, 115, 79, 6, 83, 91, -5, -47, -90, 28, 54, -15, 40, -70, -12, 122, 30, 98, 13, -6, -36, -11, 108, 118, -28, -116, 71, -100, -62, 12, 43, -5, -77, 111, -86, -116, 54, -125, 78, -106, -56, 68, 32, -48};
        byte[] byArray6 = new byte[129];
        byArray6[1] = -126;
        byArray6[2] = 125;
        byArray6[3] = -44;
        byArray6[4] = -100;
        byArray6[5] = -94;
        byArray6[6] = 5;
        byArray6[7] = 105;
        byArray6[8] = -124;
        byArray6[9] = -23;
        byArray6[10] = -125;
        byArray6[11] = 113;
        byArray6[12] = -79;
        byArray6[13] = 52;
        byArray6[14] = 13;
        byArray6[15] = 93;
        byArray6[16] = 113;
        byArray6[17] = -125;
        byArray6[18] = -110;
        byArray6[19] = -123;
        byArray6[20] = -78;
        byArray6[21] = 90;
        byArray6[22] = -54;
        byArray6[23] = -93;
        byArray6[24] = -126;
        byArray6[25] = -41;
        byArray6[26] = -84;
        byArray6[27] = 56;
        byArray6[28] = 110;
        byArray6[29] = -108;
        byArray6[30] = 64;
        byArray6[31] = -124;
        byArray6[32] = 63;
        byArray6[33] = 10;
        byArray6[34] = 70;
        byArray6[35] = 122;
        byArray6[36] = -88;
        byArray6[37] = 117;
        byArray6[38] = -88;
        byArray6[39] = -63;
        byArray6[40] = -54;
        byArray6[41] = 59;
        byArray6[42] = 112;
        byArray6[43] = -70;
        byArray6[44] = 106;
        byArray6[45] = -105;
        byArray6[46] = 7;
        byArray6[47] = 18;
        byArray6[48] = -10;
        byArray6[49] = -79;
        byArray6[50] = -103;
        byArray6[51] = -19;
        byArray6[52] = 62;
        byArray6[53] = -20;
        byArray6[54] = 83;
        byArray6[55] = 19;
        byArray6[56] = -13;
        byArray6[57] = -108;
        byArray6[58] = 10;
        byArray6[59] = 103;
        byArray6[60] = -69;
        byArray6[61] = -42;
        byArray6[62] = -97;
        byArray6[63] = 56;
        byArray6[64] = 114;
        byArray6[65] = 41;
        byArray6[66] = 97;
        byArray6[67] = -85;
        byArray6[68] = 2;
        byArray6[69] = 61;
        byArray6[70] = 23;
        byArray6[71] = -95;
        byArray6[72] = 51;
        byArray6[73] = 60;
        byArray6[74] = 82;
        byArray6[75] = 35;
        byArray6[76] = 93;
        byArray6[77] = -97;
        byArray6[78] = -73;
        byArray6[79] = -47;
        byArray6[80] = 14;
        byArray6[81] = -107;
        byArray6[82] = -29;
        byArray6[83] = -91;
        byArray6[84] = 94;
        byArray6[85] = -7;
        byArray6[86] = -80;
        byArray6[87] = 79;
        byArray6[88] = -57;
        byArray6[89] = -55;
        byArray6[90] = 32;
        byArray6[91] = -59;
        byArray6[92] = 114;
        byArray6[93] = -38;
        byArray6[94] = 122;
        byArray6[95] = -61;
        byArray6[96] = -43;
        byArray6[97] = 15;
        byArray6[98] = 36;
        byArray6[99] = 13;
        byArray6[100] = -69;
        byArray6[101] = -114;
        byArray6[102] = 84;
        byArray6[103] = -38;
        byArray6[104] = -98;
        byArray6[105] = -69;
        byArray6[106] = 112;
        byArray6[107] = 33;
        byArray6[108] = 17;
        byArray6[109] = -59;
        byArray6[110] = 53;
        byArray6[111] = -126;
        byArray6[112] = -27;
        byArray6[113] = 53;
        byArray6[114] = -123;
        byArray6[115] = 46;
        byArray6[116] = -97;
        byArray6[117] = 89;
        byArray6[118] = 57;
        byArray6[119] = 121;
        byArray6[120] = -77;
        byArray6[121] = 50;
        byArray6[122] = 80;
        byArray6[123] = -56;
        byArray6[124] = -122;
        byArray6[125] = -125;
        byArray6[126] = -106;
        byArray6[127] = 25;
        byArray6[128] = 23;
        j = byArray6;
        byte[] byArray7 = new byte[21];
        byArray7[1] = -6;
        byArray7[2] = 80;
        byArray7[3] = 121;
        byArray7[4] = -38;
        byArray7[5] = -6;
        byArray7[6] = 63;
        byArray7[7] = 58;
        byArray7[8] = -79;
        byArray7[9] = -24;
        byArray7[10] = 10;
        byArray7[11] = 109;
        byArray7[12] = -11;
        byArray7[13] = -67;
        byArray7[14] = 22;
        byArray7[15] = -14;
        byArray7[16] = 36;
        byArray7[17] = -40;
        byArray7[18] = -8;
        byArray7[19] = -41;
        byArray7[20] = 27;
        e = byArray7;
        q = new byte[]{79, -67, -11, 46, 51, 4, -16, 81, -63, 124, -91, 92, -109, -127, -75, -63, 125, 76, 32, 80, 118, -123, 52, 80, -49, -39, -4, 114, -78, -31, -78, -79, 111, -96, 16, 72, -72, -1, 23, -25, -87, 10, -31, -32, 24, 5, 62, 52, -39, -43, 97, -33, 113, 76, -56, -36, -110, -79, 81, -75, -33, 102, 89, 112, 107, 94, 87, -61, 25, -94, -42, 88, 59, 125, 50, -46, -23, -31, -15, 102, 62, -86, -84, 70, 13, -51, 78, 103, 112, 54, -9, -7, -66, 11, 46, 22, -96, 93, 105, 93, 91, -127, 19, -87, 3, -53, 56, 99, 86, 26, -67, 54, 74, 93, 108, 21, 102, 23, -6, 16, -93, 32, -103, -31, -46, 52, 119, 19};
        byte[] byArray8 = new byte[129];
        byArray8[1] = -126;
        byArray8[2] = 125;
        byArray8[3] = -44;
        byArray8[4] = -100;
        byArray8[5] = -94;
        byArray8[6] = 5;
        byArray8[7] = 105;
        byArray8[8] = -124;
        byArray8[9] = -23;
        byArray8[10] = -125;
        byArray8[11] = 113;
        byArray8[12] = -79;
        byArray8[13] = 52;
        byArray8[14] = 13;
        byArray8[15] = 93;
        byArray8[16] = 113;
        byArray8[17] = -125;
        byArray8[18] = -110;
        byArray8[19] = -123;
        byArray8[20] = -78;
        byArray8[21] = 90;
        byArray8[22] = -54;
        byArray8[23] = -93;
        byArray8[24] = -126;
        byArray8[25] = -41;
        byArray8[26] = -84;
        byArray8[27] = 56;
        byArray8[28] = 110;
        byArray8[29] = -108;
        byArray8[30] = 64;
        byArray8[31] = -124;
        byArray8[32] = 63;
        byArray8[33] = 10;
        byArray8[34] = 70;
        byArray8[35] = 122;
        byArray8[36] = -88;
        byArray8[37] = 117;
        byArray8[38] = -88;
        byArray8[39] = -63;
        byArray8[40] = -54;
        byArray8[41] = 59;
        byArray8[42] = 112;
        byArray8[43] = -70;
        byArray8[44] = 106;
        byArray8[45] = -105;
        byArray8[46] = 7;
        byArray8[47] = 18;
        byArray8[48] = -10;
        byArray8[49] = -79;
        byArray8[50] = -103;
        byArray8[51] = -19;
        byArray8[52] = 62;
        byArray8[53] = -20;
        byArray8[54] = 83;
        byArray8[55] = 19;
        byArray8[56] = -13;
        byArray8[57] = -108;
        byArray8[58] = 10;
        byArray8[59] = 103;
        byArray8[60] = -69;
        byArray8[61] = -42;
        byArray8[62] = -97;
        byArray8[63] = 56;
        byArray8[64] = 114;
        byArray8[65] = 41;
        byArray8[66] = 97;
        byArray8[67] = -85;
        byArray8[68] = 2;
        byArray8[69] = 61;
        byArray8[70] = 23;
        byArray8[71] = -95;
        byArray8[72] = 51;
        byArray8[73] = 60;
        byArray8[74] = 82;
        byArray8[75] = 35;
        byArray8[76] = 93;
        byArray8[77] = -97;
        byArray8[78] = -73;
        byArray8[79] = -47;
        byArray8[80] = 14;
        byArray8[81] = -107;
        byArray8[82] = -29;
        byArray8[83] = -91;
        byArray8[84] = 94;
        byArray8[85] = -7;
        byArray8[86] = -80;
        byArray8[87] = 79;
        byArray8[88] = -57;
        byArray8[89] = -55;
        byArray8[90] = 32;
        byArray8[91] = -59;
        byArray8[92] = 114;
        byArray8[93] = -38;
        byArray8[94] = 122;
        byArray8[95] = -61;
        byArray8[96] = -43;
        byArray8[97] = 15;
        byArray8[98] = 36;
        byArray8[99] = 13;
        byArray8[100] = -69;
        byArray8[101] = -114;
        byArray8[102] = 84;
        byArray8[103] = -38;
        byArray8[104] = -98;
        byArray8[105] = -69;
        byArray8[106] = 112;
        byArray8[107] = 33;
        byArray8[108] = 17;
        byArray8[109] = -59;
        byArray8[110] = 53;
        byArray8[111] = -126;
        byArray8[112] = -27;
        byArray8[113] = 53;
        byArray8[114] = -123;
        byArray8[115] = 46;
        byArray8[116] = -97;
        byArray8[117] = 89;
        byArray8[118] = 57;
        byArray8[119] = 121;
        byArray8[120] = -77;
        byArray8[121] = 50;
        byArray8[122] = 80;
        byArray8[123] = -56;
        byArray8[124] = -122;
        byArray8[125] = -125;
        byArray8[126] = -106;
        byArray8[127] = 25;
        byArray8[128] = 23;
        i = byArray8;
        byte[] byArray9 = new byte[21];
        byArray9[1] = -6;
        byArray9[2] = 80;
        byArray9[3] = 121;
        byArray9[4] = -38;
        byArray9[5] = -6;
        byArray9[6] = 63;
        byArray9[7] = 58;
        byArray9[8] = -79;
        byArray9[9] = -24;
        byArray9[10] = 10;
        byArray9[11] = 109;
        byArray9[12] = -11;
        byArray9[13] = -67;
        byArray9[14] = 22;
        byArray9[15] = -14;
        byArray9[16] = 36;
        byArray9[17] = -40;
        byArray9[18] = -8;
        byArray9[19] = -41;
        byArray9[20] = 27;
        d = byArray9;
        p = new byte[]{79, -67, -11, 46, 51, 4, -16, 81, -63, 124, -91, 92, -109, -127, -75, -63, 125, 76, 32, 80, 118, -123, 52, 80, -49, -39, -4, 114, -78, -31, -78, -79, 111, -96, 16, 72, -72, -1, 23, -25, -87, 10, -31, -32, 24, 5, 62, 52, -39, -43, 97, -33, 113, 76, -56, -36, -110, -79, 81, -75, -33, 102, 89, 112, 107, 94, 87, -61, 25, -94, -42, 88, 59, 125, 50, -46, -23, -31, -15, 102, 62, -86, -84, 70, 13, -51, 78, 103, 112, 54, -9, -7, -66, 11, 46, 22, -96, 93, 105, 93, 91, -127, 19, -87, 3, -53, 56, 99, 86, 26, -67, 54, 74, 93, 108, 21, 102, 23, -6, 16, -93, 32, -103, -31, -46, 52, 119, 19};
        s = BigInteger.valueOf(0L);
        u = BigInteger.valueOf(1L);
        t = BigInteger.valueOf(2L);
        v = new byte[]{97, 98, 99};
    }
}

