/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.mac;

import com.entrust.toolkit.security.fips.SecurityEngine;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

public class HMac
extends MacSpi {
    private byte[] a;
    private byte[] d = new byte[64];
    private MessageDigest b;
    private int c;
    private byte[] e;
    private static final int f = 64;

    public void engineUpdate(byte[] byArray, int n2, int n3) {
        SecurityEngine.assertCryptoOperationsAllowed();
        this.b.update(byArray, n2, n3);
    }

    public void engineUpdate(byte by) {
        SecurityEngine.assertCryptoOperationsAllowed();
        this.b.update(by);
    }

    public void engineReset() {
        this.b.reset();
        this.b.update(this.d);
    }

    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        this.e = new byte[64];
        byte[] byArray = key.getEncoded();
        if (byArray.length > 64) {
            byArray = this.b.digest(byArray);
        }
        System.arraycopy(byArray, 0, this.e, 0, byArray.length);
        int n2 = 0;
        while (n2 < 64) {
            this.d[n2] = (byte)(0x36 ^ this.e[n2]);
            this.a[n2] = (byte)(0x5C ^ this.e[n2]);
            ++n2;
        }
        this.engineReset();
    }

    public int engineGetMacLength() {
        SecurityEngine.assertCryptoOperationsAllowed();
        return this.c;
    }

    public byte[] engineDoFinal() {
        SecurityEngine.assertCryptoOperationsAllowed();
        byte[] byArray = this.b.digest();
        this.b.update(this.a);
        this.b.update(byArray);
        byArray = this.b.digest();
        this.engineReset();
        return byArray;
    }

    public HMac(String string) throws NoSuchAlgorithmException {
        this.a = new byte[64];
        try {
            this.b = MessageDigest.getInstance(string, "IAIK");
        }
        catch (Exception exception) {
            this.b = MessageDigest.getInstance(string);
        }
        this.c = this.b.digest().length;
        this.b.reset();
    }
}

