/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;

public class RSAPrivateKey
extends PrivateKeyInfo
implements Cloneable,
Serializable,
RSAPrivateCrtKey {
    static final BigInteger l;
    static final BigInteger k;
    private BigInteger j;
    private BigInteger g;
    private BigInteger h;
    private BigInteger e;
    private BigInteger f;
    private BigInteger d;
    private BigInteger b;
    private BigInteger i;
    private int a;
    private transient ASN1 c;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("modulus: " + this.i.toString(16) + "\n");
        stringBuffer.append("public exponent: " + this.b.toString(16) + "\n");
        stringBuffer.append("private exponent: " + this.d.toString(16) + "\n");
        stringBuffer.append("primeP: " + this.f.toString(16) + "\n");
        stringBuffer.append("primeQ: " + this.e.toString(16) + "\n");
        stringBuffer.append("primeExponentP: " + this.h.toString(16) + "\n");
        stringBuffer.append("primeExponentQ: " + this.g.toString(16) + "\n");
        stringBuffer.append("crt_coefficient: " + this.j.toString(16) + "\n");
        return stringBuffer.toString();
    }

    public static RSAPrivateKey parse(byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        rSAPrivateKey.decode(byArray);
        rSAPrivateKey.b();
        return rSAPrivateKey;
    }

    public int hashCode() {
        return this.i.hashCode() ^ this.b.hashCode() ^ this.d.hashCode() ^ this.f.hashCode() ^ this.e.hashCode() ^ this.h.hashCode() ^ this.g.hashCode() ^ this.j.hashCode();
    }

    public PublicKey getPublicKey() {
        return new RSAPublicKey(this.i, this.b);
    }

    public BigInteger getPublicExponent() {
        return this.b;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public BigInteger getPrimeQ() {
        return this.e;
    }

    public BigInteger getPrimeP() {
        return this.f;
    }

    public BigInteger getPrimeExponentQ() {
        return this.g;
    }

    public BigInteger getPrimeExponentP() {
        return this.h;
    }

    public BigInteger getModulus() {
        return this.i;
    }

    public BigInteger getCrtCoefficient() {
        return this.j;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    protected byte[] encode() {
        return this.c.toByteArray();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.a = ((BigInteger)this.c.getComponentAt(0).getValue()).intValue();
            this.i = (BigInteger)this.c.getComponentAt(1).getValue();
            this.b = (BigInteger)this.c.getComponentAt(2).getValue();
            this.d = (BigInteger)this.c.getComponentAt(3).getValue();
            this.f = (BigInteger)this.c.getComponentAt(4).getValue();
            this.e = (BigInteger)this.c.getComponentAt(5).getValue();
            this.h = (BigInteger)this.c.getComponentAt(6).getValue();
            this.g = (BigInteger)this.c.getComponentAt(7).getValue();
            this.j = (BigInteger)this.c.getComponentAt(8).getValue();
            if (this.f.compareTo(this.e) < 0) {
                BigInteger bigInteger = this.f;
                this.f = this.e;
                this.e = bigInteger;
                this.a();
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No RSA Private Key: " + exception.toString());
        }
    }

    public BigInteger crypt(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (this.f.bitCount() == 0) {
            return bigInteger.modPow(this.d, this.i);
        }
        BigInteger bigInteger3 = bigInteger.mod(this.f).modPow(this.h, this.f);
        BigInteger bigInteger4 = bigInteger3.subtract(bigInteger2 = bigInteger.mod(this.e).modPow(this.g, this.e));
        if (bigInteger4.signum() < 0) {
            bigInteger4 = bigInteger4.add(this.f);
        }
        return bigInteger4.multiply(this.j).mod(this.f).multiply(this.e).add(bigInteger2);
    }

    private void b() {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.a));
            sEQUENCE.addComponent(new INTEGER(this.i));
            sEQUENCE.addComponent(new INTEGER(this.b));
            sEQUENCE.addComponent(new INTEGER(this.d));
            sEQUENCE.addComponent(new INTEGER(this.f));
            sEQUENCE.addComponent(new INTEGER(this.e));
            sEQUENCE.addComponent(new INTEGER(this.h));
            sEQUENCE.addComponent(new INTEGER(this.g));
            sEQUENCE.addComponent(new INTEGER(this.j));
            this.c = new ASN1(sEQUENCE);
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPrivateKeyInfo();
    }

    public Object clone() {
        return new RSAPrivateKey(this);
    }

    private void a() {
        this.h = this.d.mod(this.f.subtract(l));
        this.g = this.d.mod(this.e.subtract(l));
        this.j = this.e.modInverse(this.f);
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.private_key_info = new ASN1(byArray);
            this.a = ((BigInteger)this.private_key_info.getComponentAt(0).getValue()).intValue();
            this.private_key_algorithm = new AlgorithmID(this.private_key_info.getComponentAt(1));
            this.decode((byte[])this.private_key_info.getComponentAt(2).getValue());
        }
        catch (Exception exception) {
            this.decode(byArray);
            this.b();
        }
    }

    public RSAPrivateKey(RSAPrivateKeySpec rSAPrivateKeySpec) {
        if (rSAPrivateKeySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)rSAPrivateKeySpec;
            this.i = rSAPrivateCrtKeySpec.getModulus();
            this.b = rSAPrivateCrtKeySpec.getPublicExponent();
            this.d = rSAPrivateCrtKeySpec.getPrivateExponent();
            this.f = rSAPrivateCrtKeySpec.getPrimeP();
            this.e = rSAPrivateCrtKeySpec.getPrimeQ();
            this.h = rSAPrivateCrtKeySpec.getPrimeExponentP();
            this.g = rSAPrivateCrtKeySpec.getPrimeExponentQ();
            this.j = rSAPrivateCrtKeySpec.getCrtCoefficient();
        } else {
            this.i = rSAPrivateKeySpec.getModulus();
            this.d = rSAPrivateKeySpec.getPrivateExponent();
            this.b = k;
            this.f = k;
            this.e = k;
            this.h = k;
            this.g = k;
            this.j = k;
        }
        this.b();
    }

    public RSAPrivateKey(java.security.interfaces.RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
            this.i = rSAPrivateCrtKey.getModulus();
            this.b = rSAPrivateCrtKey.getPublicExponent();
            this.d = rSAPrivateCrtKey.getPrivateExponent();
            this.f = rSAPrivateCrtKey.getPrimeP();
            this.e = rSAPrivateCrtKey.getPrimeQ();
            this.h = rSAPrivateCrtKey.getPrimeExponentP();
            this.g = rSAPrivateCrtKey.getPrimeExponentQ();
            this.j = rSAPrivateCrtKey.getCrtCoefficient();
        } else {
            this.i = rSAPrivateKey.getModulus();
            this.d = rSAPrivateKey.getPrivateExponent();
            this.b = k;
            this.f = k;
            this.e = k;
            this.h = k;
            this.g = k;
            this.j = k;
        }
        this.b();
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.d = bigInteger3;
        this.b = bigInteger2;
        this.i = bigInteger;
        this.f = bigInteger4;
        this.e = bigInteger5;
        if (this.f.compareTo(this.e) < 0) {
            BigInteger bigInteger9 = this.f;
            this.f = this.e;
            this.e = bigInteger9;
            this.a();
        } else {
            this.h = bigInteger6;
            this.g = bigInteger7;
            this.j = bigInteger8;
        }
        this.b();
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, k, bigInteger2, k, k, k, k, k);
    }

    public RSAPrivateKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public RSAPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    protected RSAPrivateKey() {
    }

    static {
        k = BigInteger.valueOf(0L);
        l = BigInteger.valueOf(1L);
    }
}

