/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.RSAPublicKeySpec;

public class RSAPublicKey
extends PublicKeyInfo
implements Cloneable,
Serializable,
java.security.interfaces.RSAPublicKey {
    private BigInteger b;
    private BigInteger c;
    private transient ASN1 a;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("public exponent: " + this.b.toString(16) + "\n");
        stringBuffer.append("modulus: " + this.c.toString(16) + "\n");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.b.hashCode() ^ this.c.hashCode();
    }

    public BigInteger getPublicExponent() {
        return this.b;
    }

    public BigInteger getModulus() {
        return this.c;
    }

    public byte[] getFingerprint() {
        return this.a.fingerprint();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
        return this.c.equals(rSAPublicKey.c) && this.b.equals(rSAPublicKey.b);
    }

    protected byte[] encode() {
        return this.a.toByteArray();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.a = new ASN1(byArray);
            this.c = (BigInteger)this.a.getComponentAt(0).getValue();
            this.b = (BigInteger)this.a.getComponentAt(1).getValue();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No RSA Public Key: " + exception.toString());
        }
    }

    public BigInteger crypt(BigInteger bigInteger) {
        return bigInteger.modPow(this.b, this.c);
    }

    private void a() {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.c));
            sEQUENCE.addComponent(new INTEGER(this.b));
            this.a = new ASN1(sEQUENCE);
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.rsaEncryption.clone();
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPublicKeyInfo();
    }

    public Object clone() {
        return new RSAPublicKey(this);
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public RSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
        this(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
    }

    public RSAPublicKey(java.security.interfaces.RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.c = bigInteger;
        this.b = bigInteger2;
        this.a();
    }

    public RSAPublicKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public RSAPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }
}

