/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.Name;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class X509CRL
extends java.security.cert.X509CRL
implements ASN1Type {
    private boolean i = true;
    private X509Extensions j;
    private Hashtable f = new Hashtable();
    private ChoiceOfTime g = null;
    private ChoiceOfTime b = null;
    private Name h = null;
    private AlgorithmID d = null;
    private Signature e = null;
    private int a = 1;
    private ASN1 c = null;
    private ASN1 k = null;

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.i) {
            throw new RuntimeException("Cannot encode this crl. First the crl has to be signed.");
        }
        this.k.writeTo(outputStream);
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        BIT_STRING bIT_STRING = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.i) {
            throw new RuntimeException("Cannot verify this crl. First it has to be signed.");
        }
        if (this.d == null) {
            throw new NoSuchAlgorithmException("Cannot verify crl! No signature algorithm set.");
        }
        try {
            AlgorithmID algorithmID = new AlgorithmID(this.k.getComponentAt(1));
            if (!algorithmID.equals(this.d)) {
                throw new SignatureException("Signature AlgorithmID mismatch!");
            }
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.getMessage());
        }
        if (string == null || string.length() == 0) {
            try {
                this.e = Signature.getInstance(this.d.getAlgorithm().getID(), "Entrust");
            }
            catch (Exception exception) {
                this.e = Signature.getInstance(this.d.getAlgorithm().getID());
            }
        } else {
            this.e = Signature.getInstance(this.d.getAlgorithm().getID(), string);
        }
        try {
            bIT_STRING = (BIT_STRING)this.k.getComponentAt(2);
            byArray = (byte[])bIT_STRING.getValue();
            byArray2 = this.k.getFirstObject();
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        this.e.initVerify(publicKey);
        this.e.update(byArray2);
        if (!this.e.verify(byArray)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CRLException {
        this.verify(publicKey, (String)null);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509 version " + this.a + " CRL\n");
        stringBuffer.append("Signature Algorithm: " + this.d.getName() + "\n");
        stringBuffer.append("Issuer: " + this.h.toString() + "\n");
        stringBuffer.append("this update: " + this.b.toString() + "\n");
        if (this.g != null) {
            stringBuffer.append("next update: " + this.g.toString() + "\n");
        }
        if (this.j != null) {
            if (bl) {
                stringBuffer.append(this.j);
            } else {
                stringBuffer.append("Extensions: " + this.j.countExtensions());
            }
        }
        if (bl) {
            int n2 = 1;
            Enumeration enumeration = this.f.elements();
            while (enumeration.hasMoreElements()) {
                RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
                stringBuffer.append(String.valueOf(n2) + ": " + revokedCertificate.toString(bl));
                ++n2;
            }
        } else {
            stringBuffer.append("CRL contains " + this.f.size() + " revoked certificates");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        if (this.i) {
            throw new RuntimeException("Cannot encode this crl. First the crl has to be signed.");
        }
        return this.k.toByteArray();
    }

    public ASN1Object toASN1Object() {
        if (this.i) {
            throw new RuntimeException("Cannot give an ASN.1 representation of this crl. First the crl has to be signed.");
        }
        return this.k.toASN1Object();
    }

    public void sign(PrivateKey privateKey) throws InvalidKeyException, CRLException {
        BIT_STRING bIT_STRING = null;
        this.a();
        this.e.initSign(privateKey);
        try {
            this.e.update(this.c.toByteArray());
            bIT_STRING = new BIT_STRING(this.e.sign());
        }
        catch (SignatureException signatureException) {
            throw new CRLException(signatureException.getMessage());
        }
        try {
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.k = new ASN1(sEQUENCE);
            this.i = false;
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.getMessage());
        }
    }

    public void setThisUpdate(Date date) {
        this.b = new ChoiceOfTime(date, true);
        this.i = true;
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new NoSuchAlgorithmException("Cannot set null signature algorithm for this CRL!");
        }
        this.d = algorithmID;
        try {
            this.e = this.d.getSignatureInstance("Entrust");
        }
        catch (Exception exception) {
            this.e = this.d.getSignatureInstance();
        }
        this.i = true;
    }

    public void setSignatureAlgorithm(ObjectID objectID) throws NoSuchAlgorithmException {
        if (objectID == null) {
            throw new NoSuchAlgorithmException("Cannot set null signature algorithm for this CRL!");
        }
        this.d = new AlgorithmID(objectID);
        try {
            this.e = this.d.getSignatureInstance("Entrust");
        }
        catch (Exception exception) {
            this.e = this.d.getSignatureInstance();
        }
        this.i = true;
    }

    public void setNextUpdate(Date date) {
        this.g = new ChoiceOfTime(date, true);
        this.i = true;
    }

    public void setIssuerDN(Principal principal) throws IllegalArgumentException {
        try {
            this.h = (Name)principal;
            this.i = true;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Issuer is not an instance of name.");
        }
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.j == null ? false : this.j.removeExtension(objectID);
        if (bl) {
            this.i = true;
        }
        return bl;
    }

    public boolean removeCertificate(BigInteger bigInteger) {
        if (this.f.remove(bigInteger) != null) {
            this.i = true;
            return true;
        }
        return false;
    }

    public void removeAllExtensions() {
        if (this.j != null) {
            this.j.removeAllExtensions();
            this.i = true;
        }
    }

    public void removeAllCertificates() {
        this.f.clear();
        this.i = true;
    }

    private void a(ASN1Object aSN1Object) throws CRLException, CodingException {
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            RevokedCertificate revokedCertificate = new RevokedCertificate(aSN1Object.getComponentAt(n2));
            this.f.put(revokedCertificate.getSerialNumber(), revokedCertificate);
            ++n2;
        }
    }

    public Enumeration listExtensions() {
        return this.j == null ? null : this.j.listExtensions();
    }

    public Enumeration listCertificates() {
        return this.f.elements();
    }

    public boolean isRevoked(Certificate certificate) {
        return this.containsCertificate((X509Certificate)certificate) != null;
    }

    public boolean isRevoked(BigInteger bigInteger) {
        if (this.i) {
            throw new RuntimeException("Cannot check revocation status. First the crl has to be signed.");
        }
        return this.containsCertificate(bigInteger) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void c() throws CRLException {
        int n2 = 0;
        try {
            ASN1Object aSN1Object = this.k.toASN1Object();
            aSN1Object.setIndefiniteRecursive(false);
            this.k = new ASN1(aSN1Object);
            this.c = new ASN1(this.k.getComponentAt(0));
            aSN1Object = this.c.getComponentAt(n2);
            if (aSN1Object.isA(ASN.INTEGER)) {
                BigInteger bigInteger = (BigInteger)aSN1Object.getValue();
                this.a = bigInteger.intValue();
                ++this.a;
            }
            int n3 = ++n2;
            this.d = new AlgorithmID(this.c.getComponentAt(n3));
            int n4 = ++n2;
            this.h = new Name(this.c.getComponentAt(n4));
            int n5 = ++n2;
            ++n2;
            this.b = new ChoiceOfTime(this.c.getComponentAt(n5));
            while (n2 < this.c.countComponents()) {
                aSN1Object = this.c.getComponentAt(n2);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    this.a(aSN1Object);
                } else if (aSN1Object.isA(ASN.CON_SPEC)) {
                    if (aSN1Object.getAsnType().getTag() != 0) throw new CRLException("Unknown CRL format.");
                    this.j = new X509Extensions((ASN1Object)aSN1Object.getValue());
                } else {
                    if (!aSN1Object.isA(ASN.UTCTime) && !aSN1Object.isA(ASN.GeneralizedTime)) throw new CRLException("Unknown CRL format.");
                    this.g = new ChoiceOfTime(this.c.getComponentAt(n2));
                }
                ++n2;
            }
            this.i = false;
            return;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException(x509ExtensionException.getMessage());
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.getMessage());
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.j == null ? false : this.j.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        return this.j == null ? false : this.j.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public Date getThisUpdate() {
        return this.b.getDate();
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            if (this.k != null && this.k.toByteArray() != null) {
                return this.k.getFirstObject();
            }
            this.a();
            return this.c.toByteArray();
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.d;
    }

    public byte[] getSignature() {
        try {
            BIT_STRING bIT_STRING = (BIT_STRING)this.k.getComponentAt(2);
            return (byte[])bIT_STRING.getValue();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public byte[] getSigAlgParams() {
        try {
            ASN1Object aSN1Object = this.d.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public String getSigAlgOID() {
        return this.d.getAlgorithm().getID();
    }

    public String getSigAlgName() {
        return this.d.getName();
    }

    public Set getRevokedCertificates() {
        HashSet<RevokedCertificate> hashSet = new HashSet<RevokedCertificate>();
        Enumeration enumeration = this.listCertificates();
        while (enumeration.hasMoreElements()) {
            RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
            hashSet.add(revokedCertificate);
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        return this.containsCertificate(bigInteger);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.j == null ? null : this.j.getNonCriticalExtensionOIDs();
    }

    public Date getNextUpdate() {
        return this.g.getDate();
    }

    public Principal getIssuerDN() {
        return this.h;
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        if (this.i) {
            throw new RuntimeException("Cannot give a fingerprint this certificate. First it has to be signed.");
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string, "IAIK");
        }
        catch (Exception exception) {
            messageDigest = MessageDigest.getInstance(string);
        }
        messageDigest.update(this.k.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprint() {
        if (this.i) {
            throw new RuntimeException("Cannot give a fingerprint this certificate. First it has to be signed.");
        }
        return this.k.fingerprint();
    }

    public byte[] getExtensionValue(String string) {
        return this.j == null ? null : this.j.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.j == null ? null : this.j.getExtension(objectID);
    }

    public byte[] getEncoded() throws CRLException {
        if (this.i) {
            throw new RuntimeException("Cannot encode this crl. First the crl has to be signed.");
        }
        return this.toByteArray();
    }

    public Set getCriticalExtensionOIDs() {
        return this.j == null ? null : this.j.getCriticalExtensionOIDs();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.k = new ASN1(aSN1Object);
        try {
            if (this.k != null) {
                this.c();
            }
        }
        catch (CRLException cRLException) {
            throw new CodingException(cRLException.getMessage());
        }
    }

    private ASN1Object b() throws CRLException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Enumeration enumeration = this.f.elements();
        while (enumeration.hasMoreElements()) {
            sEQUENCE.addComponent(((RevokedCertificate)enumeration.nextElement()).toASN1Object());
        }
        return sEQUENCE;
    }

    private void a() throws CRLException {
        SEQUENCE sEQUENCE = null;
        if (this.d == null) {
            throw new CRLException("Signature algorithm not set!");
        }
        if (this.h == null) {
            throw new CRLException("Issuer not set!");
        }
        if (this.b == null) {
            throw new CRLException("ThisUpdate not set!");
        }
        if (this.j != null) {
            this.a = 2;
        }
        try {
            sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new INTEGER(this.a - 1));
            }
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(this.h.toASN1Object());
            sEQUENCE.addComponent(this.b.toASN1Object());
            if (this.g != null) {
                sEQUENCE.addComponent(this.g.toASN1Object());
            }
            if (this.f.size() > 0) {
                sEQUENCE.addComponent(this.b());
            }
            if (this.j != null) {
                CON_SPEC cON_SPEC = new CON_SPEC(0, this.j.toASN1Object());
                sEQUENCE.addComponent(cON_SPEC);
            }
            this.c = new ASN1(sEQUENCE);
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException(x509ExtensionException.getMessage());
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.getMessage());
        }
    }

    public int countExtensions() {
        return this.j == null ? 0 : this.j.countExtensions();
    }

    public RevokedCertificate containsCertificate(BigInteger bigInteger) {
        if (this.i) {
            throw new RuntimeException("Cannot check revocation status. First the crl has to be signed.");
        }
        Enumeration enumeration = this.f.elements();
        while (enumeration.hasMoreElements()) {
            RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
            if (!bigInteger.equals(revokedCertificate.getSerialNumber())) continue;
            return revokedCertificate;
        }
        return null;
    }

    public RevokedCertificate containsCertificate(X509Certificate x509Certificate) {
        return this.containsCertificate(x509Certificate.getSerialNumber());
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.j == null) {
            this.j = new X509Extensions();
        }
        this.j.addExtension(v3Extension);
        this.i = true;
    }

    public void addCertificate(X509Certificate x509Certificate, Date date) {
        this.f.put(x509Certificate.getSerialNumber(), new RevokedCertificate(x509Certificate, date));
        this.i = true;
    }

    public void addCertificate(RevokedCertificate revokedCertificate) {
        this.f.put(revokedCertificate.getSerialNumber(), revokedCertificate);
        this.i = true;
    }

    public X509CRL(byte[] byArray) throws CRLException {
        try {
            this.k = new ASN1(byArray);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        if (this.k != null) {
            this.c();
        }
    }

    public X509CRL(InputStream inputStream) throws CRLException, IOException {
        try {
            this.k = new ASN1(inputStream);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        if (this.k != null) {
            this.c();
        }
    }

    public X509CRL() {
        this.k = new ASN1();
    }
}

