/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.Name;
import iaik.utils.Util;
import iaik.x509.PublicKeyInfo;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.KeyUsage;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;

public class X509Certificate
extends java.security.cert.X509Certificate
implements Serializable,
ASN1Type {
    private boolean m = true;
    private X509Extensions n;
    private BigInteger c;
    private BigInteger k;
    private PublicKey h;
    private Name d;
    private ChoiceOfTime j;
    private ChoiceOfTime i;
    private Name l;
    private AlgorithmID e;
    private Signature f;
    private BigInteger g;
    private int a = 1;
    private transient ASN1 b;
    private transient ASN1 o;

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.m) {
            throw new RuntimeException("Cannot encode this certificate. First it has to be signed.");
        }
        this.o.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    public void verify(DSAPublicKey dSAPublicKey, DSAParameterSpec dSAParameterSpec) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        if (this.m) {
            throw new RuntimeException("Cannot verify this certificate. First it has to be signed.");
        }
        if (this.e == null) {
            throw new NoSuchAlgorithmException("Cannot verify certificate! No signature algorithm set.");
        }
        try {
            object = new AlgorithmID(this.o.getComponentAt(1));
            if (!((AlgorithmID)object).equals(this.e)) {
                throw new SignatureException("Signature AlgorithmID mismatch!");
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        this.f = Signature.getInstance("DSA", "Entrust");
        try {
            object = (BIT_STRING)this.o.getComponentAt(2);
            byArray2 = (byte[])((BIT_STRING)object).getValue();
            byArray = this.o.getFirstObject();
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        this.f.setParameter("DSAParameterSpec", dSAParameterSpec);
        this.f.initVerify(dSAPublicKey);
        this.f.update(byArray);
        if (!this.f.verify(byArray2)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        byte[] byArray;
        byte[] byArray2;
        Signature signature;
        Object object;
        if (this.m) {
            throw new RuntimeException("Cannot verify this certificate. First it has to be signed.");
        }
        if (this.e == null) {
            throw new NoSuchAlgorithmException("Cannot verify certificate! No signature algorithm set.");
        }
        try {
            object = new AlgorithmID(this.o.getComponentAt(1));
            if (!((AlgorithmID)object).equals(this.e)) {
                throw new SignatureException("Signature AlgorithmID mismatch!");
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        if (string == null) {
            try {
                signature = Signature.getInstance(this.e.getAlgorithm().getID(), "Entrust");
            }
            catch (Exception exception) {
                signature = Signature.getInstance(this.e.getAlgorithm().getID());
            }
        } else {
            signature = Signature.getInstance(this.e.getAlgorithm().getID(), string);
        }
        try {
            object = (BIT_STRING)this.o.getComponentAt(2);
            byArray2 = (byte[])((BIT_STRING)object).getValue();
            byArray = this.o.getFirstObject();
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        this.verify(publicKey, (String)null);
    }

    public void verify() throws SignatureException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, CertificateException {
        if (!this.l.equals(this.d)) {
            throw new SignatureException("The certificate is not self-signed.");
        }
        this.verify(this.h);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        if (this.g != null) {
            stringBuffer.append("Serial number: " + this.g + "\n");
        }
        if (this.e != null) {
            stringBuffer.append("Signature algorithm: " + this.e + "\n");
        }
        if (this.l != null) {
            stringBuffer.append("Issuer: " + this.l + "\n");
        }
        if (this.i != null) {
            stringBuffer.append("Valid not before: " + this.i + "\n");
        }
        if (this.j != null) {
            stringBuffer.append("      not after: " + this.j + "\n");
        }
        if (this.d != null) {
            stringBuffer.append("Subject: " + this.d + "\n");
        }
        if (this.h != null) {
            stringBuffer.append(this.h.toString());
        }
        if (this.k != null) {
            stringBuffer.append("Issuer Unique ID: " + this.k + "\n");
        }
        if (this.c != null) {
            stringBuffer.append("Subject Unique ID: " + this.c + "\n");
        }
        stringBuffer.append("\n");
        if (this.n != null) {
            if (bl) {
                stringBuffer.append(this.n);
            } else {
                stringBuffer.append("Extensions: " + this.n.countExtensions() + "\n");
            }
        }
        stringBuffer.append("Certificate Fingerprint: " + Util.toString(this.getFingerprint()) + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        if (this.m) {
            throw new RuntimeException("Cannot encode this certificate. First it has to be signed.");
        }
        return this.o.toByteArray();
    }

    private boolean[] a(String string) {
        boolean[] blArray = new boolean[string.length()];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = string.charAt(n2) == '1';
            ++n2;
        }
        return blArray;
    }

    public ASN1Object toASN1Object() {
        if (this.m) {
            throw new RuntimeException("Cannot give an ASN.1 representation of this certificate. First it has to be signed.");
        }
        return this.o.toASN1Object();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        if (algorithmID == null) {
            throw new CertificateException("Cannot sign certificate! No signature algorithm specified!");
        }
        if (privateKey == null) {
            throw new CertificateException("Cannot sign certificate! No private key specified!");
        }
        this.e = algorithmID;
        try {
            this.f = this.e.getSignatureInstance("Entrust");
        }
        catch (Exception exception) {
            this.f = this.e.getSignatureInstance();
        }
        this.a();
        this.f.initSign(privateKey);
        try {
            this.f.update(this.b.toByteArray());
            BIT_STRING bIT_STRING = new BIT_STRING(this.f.sign());
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(this.e.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.o = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        catch (SignatureException signatureException) {
            throw new CertificateException(signatureException.getMessage());
        }
        this.m = false;
    }

    public void setValidNotBefore(Date date) {
        this.i = new ChoiceOfTime(date, true);
        this.m = true;
    }

    public void setValidNotAfter(Date date) {
        this.j = new ChoiceOfTime(date, true);
        this.m = true;
    }

    public void setSubjectUniqueID(boolean[] blArray) {
        this.c = new BigInteger(this.a(blArray), 2);
        this.a = 2;
        this.m = true;
    }

    public void setSubjectDN(Principal principal) throws IllegalArgumentException {
        try {
            this.d = (Name)principal;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Subject is not an instance of Name.");
        }
        this.m = true;
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        this.e = algorithmID;
        this.m = true;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.g = bigInteger;
        this.m = true;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        this.h = publicKey;
        this.m = true;
    }

    public void setIssuerUniqueID(boolean[] blArray) {
        this.k = new BigInteger(this.a(blArray), 2);
        this.a = 2;
        this.m = true;
    }

    public void setIssuerDN(Principal principal) throws IllegalArgumentException {
        try {
            this.l = (Name)principal;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Issuer is not an instance of Name.");
        }
        this.m = true;
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.n == null ? false : this.n.removeExtension(objectID);
        if (bl) {
            this.m = true;
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.n != null) {
            this.n.removeAllExtensions();
            this.m = true;
        }
        this.n = null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.o = new ASN1(objectInputStream);
            this.b();
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public Enumeration listExtensions() {
        return this.n == null ? null : this.n.listExtensions();
    }

    private void b() throws X509ExtensionException, CertificateException {
        int n2 = 0;
        ASN1Object aSN1Object = null;
        try {
            Object object;
            ASN1Object aSN1Object2 = this.o.toASN1Object();
            aSN1Object2.setIndefiniteRecursive(false);
            this.o = new ASN1(aSN1Object2);
            this.b = new ASN1(this.o.getComponentAt(0));
            aSN1Object2 = this.b.getComponentAt(0);
            if (aSN1Object2.isA(ASN.CON_SPEC)) {
                object = (BigInteger)((ASN1Object)aSN1Object2.getValue()).getValue();
                this.a = ((BigInteger)object).intValue() + 1;
                ++n2;
            }
            this.g = (BigInteger)this.b.getComponentAt(n2).getValue();
            this.e = new AlgorithmID(this.b.getComponentAt(1 + n2));
            this.l = new Name(this.b.getComponentAt(2 + n2));
            object = new ASN1(this.b.getComponentAt(3 + n2));
            this.i = new ChoiceOfTime(((ASN1)object).getComponentAt(0));
            this.j = new ChoiceOfTime(((ASN1)object).getComponentAt(1));
            this.d = new Name(this.b.getComponentAt(4 + n2));
            aSN1Object = this.b.getComponentAt(5 + n2);
            int n3 = 6 + n2;
            while (n3 < this.b.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)this.b.getComponentAt(n3);
                if (cON_SPEC.getAsnType().getTag() == 1) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    this.k = new BigInteger(1, (byte[])((ASN1Object)cON_SPEC.getValue()).getValue());
                } else if (cON_SPEC.getAsnType().getTag() == 2) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    this.c = new BigInteger(1, (byte[])((ASN1Object)cON_SPEC.getValue()).getValue());
                } else if (cON_SPEC.getAsnType().getTag() == 3) {
                    this.n = new X509Extensions((ASN1Object)cON_SPEC.getValue());
                }
                ++n3;
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new CertificateException("Error in parsing certificate: " + classCastException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new CertificateException("Error in parsing certificate. Missing component(s).");
        }
        try {
            this.h = PublicKeyInfo.getPublicKey(aSN1Object);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertificateException(invalidKeyException.getMessage());
        }
        this.m = false;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.n == null ? false : this.n.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        return this.n == null ? false : this.n.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            if (this.o != null && this.o.toByteArray() != null) {
                return this.o.getFirstObject();
            }
            this.a();
            return this.b.toByteArray();
        }
        catch (CodingException codingException) {
            throw new CertificateEncodingException(codingException.toString());
        }
    }

    public boolean[] getSubjectUniqueID() {
        if (this.c == null) {
            return null;
        }
        String string = this.c.toString(2);
        return this.a(string);
    }

    public Principal getSubjectDN() {
        return this.d;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.e;
    }

    public byte[] getSignature() {
        if (this.o == null) {
            throw new RuntimeException("Cannot get Signature from a null certificate.");
        }
        try {
            BIT_STRING bIT_STRING = (BIT_STRING)this.o.getComponentAt(2);
            return (byte[])bIT_STRING.getValue();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public byte[] getSigAlgParams() {
        if (this.e == null) {
            return null;
        }
        try {
            ASN1Object aSN1Object = this.e.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public String getSigAlgOID() {
        return this.e == null ? null : this.e.getAlgorithm().getID();
    }

    public String getSigAlgName() {
        return this.e == null ? null : this.e.getName();
    }

    public BigInteger getSerialNumber() {
        return this.g;
    }

    public PublicKey getPublicKey() {
        return this.h;
    }

    public Date getNotBefore() {
        return this.i == null ? null : this.i.getDate();
    }

    public Date getNotAfter() {
        return this.j == null ? null : this.j.getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.n == null ? null : this.n.getNonCriticalExtensionOIDs();
    }

    public boolean[] getKeyUsage() {
        if (this.n == null) {
            return null;
        }
        try {
            KeyUsage keyUsage = (KeyUsage)this.n.getExtension(KeyUsage.oid);
            if (keyUsage != null) {
                return keyUsage.getBooleanArray();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        if (this.k == null) {
            return null;
        }
        String string = this.k.toString(2);
        return this.a(string);
    }

    public Principal getIssuerDN() {
        return this.l;
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        if (this.m) {
            throw new RuntimeException("Cannot give a fingerprint this certificate. First it has to be signed.");
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string, "IAIK");
        }
        catch (Exception exception) {
            messageDigest = MessageDigest.getInstance(string);
        }
        messageDigest.update(this.o.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprint() {
        if (this.m) {
            throw new RuntimeException("Cannot give a fingerprint this certificate. First it has to be signed.");
        }
        return this.o.fingerprint();
    }

    public byte[] getExtensionValue(String string) {
        return this.n == null ? null : this.n.getExtensionValue(string);
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.n == null ? null : this.n.getExtension(objectID);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        if (this.m) {
            throw new RuntimeException("Cannot encode this certificate. First it has to be signed.");
        }
        return this.toByteArray();
    }

    public Set getCriticalExtensionOIDs() {
        return this.n == null ? null : this.n.getCriticalExtensionOIDs();
    }

    public int getBasicConstraints() {
        if (this.n == null) {
            return -1;
        }
        try {
            BasicConstraints basicConstraints = (BasicConstraints)this.n.getExtension(BasicConstraints.oid);
            if (basicConstraints == null) {
                return -1;
            }
            return basicConstraints.getPathLenConstraint();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String a(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                stringBuffer.append('1');
            } else {
                stringBuffer.append('0');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void decode(InputStream inputStream) throws CertificateException, IOException {
        if (inputStream == null) {
            throw new IOException("Cannot parse certificate from a null input stream!");
        }
        try {
            this.o = new ASN1(inputStream);
            if (this.o != null) {
                this.b();
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot parse certificate from a null object!");
        }
        this.o = new ASN1(aSN1Object);
        try {
            if (this.o != null) {
                this.b();
            }
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    private void a() throws CertificateEncodingException {
        SEQUENCE sEQUENCE = null;
        if (this.g == null) {
            throw new CertificateEncodingException("Serial number not set!");
        }
        if (this.e == null) {
            throw new CertificateEncodingException("Signature algorithm not set!");
        }
        if (this.l == null) {
            throw new CertificateEncodingException("Issuer not set!");
        }
        if (this.i == null) {
            throw new CertificateEncodingException("Valid not before not set!");
        }
        if (this.j == null) {
            throw new CertificateEncodingException("Valid not after not set!");
        }
        if (this.d == null) {
            throw new CertificateEncodingException("Subject not set!");
        }
        if (this.h == null) {
            throw new CertificateEncodingException("Public key not set!");
        }
        if (this.k != null || this.c != null) {
            this.a = 2;
        }
        if (this.n != null) {
            if (this.n.hasExtensions()) {
                this.a = 3;
            } else {
                this.n = null;
            }
        }
        try {
            BIT_STRING bIT_STRING;
            sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.a - 1)));
            }
            sEQUENCE.addComponent(new INTEGER(this.g));
            sEQUENCE.addComponent(this.e.toASN1Object());
            sEQUENCE.addComponent(this.l.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.i.toASN1Object());
            sEQUENCE2.addComponent(this.j.toASN1Object());
            sEQUENCE.addComponent(sEQUENCE2);
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(DerCoder.decode(this.h.getEncoded()));
            if (this.k != null) {
                bIT_STRING = new BIT_STRING(this.k.toByteArray());
                sEQUENCE.addComponent(new CON_SPEC(1, bIT_STRING, true));
            }
            if (this.c != null) {
                bIT_STRING = new BIT_STRING(this.c.toByteArray());
                sEQUENCE.addComponent(new CON_SPEC(2, bIT_STRING, true));
            }
            if (this.n != null) {
                sEQUENCE.addComponent(new CON_SPEC(3, this.n.toASN1Object()));
            }
            this.b = new ASN1(sEQUENCE);
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.getMessage());
        }
    }

    public int countExtensions() {
        return this.n == null ? 0 : this.n.countExtensions();
    }

    public void checkValidity(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (this.m) {
            throw new RuntimeException("Cannot check validity. First this certificate has to be signed.");
        }
        if (this.i == null) {
            throw new CertificateNotYetValidException("ValidNotBefore date not set!");
        }
        if (date.before(this.i.getDate())) {
            throw new CertificateNotYetValidException();
        }
        if (this.j == null) {
            throw new CertificateExpiredException("ValidNotAfter date not set!");
        }
        if (date.after(this.j.getDate())) {
            throw new CertificateExpiredException();
        }
    }

    public void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException {
        this.checkValidity(new Date());
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.n == null) {
            this.n = new X509Extensions();
        }
        this.n.addExtension(v3Extension);
        this.a = 3;
        this.m = true;
    }

    public X509Certificate(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Cannot parse certificate from a null byte array!");
        }
        try {
            this.o = new ASN1(byArray);
            if (this.o != null) {
                this.b();
            }
        }
        catch (CodingException codingException) {
            throw new CertificateException(codingException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CertificateException(x509ExtensionException.getMessage());
        }
    }

    public X509Certificate(InputStream inputStream) throws CertificateException, IOException {
        if (inputStream == null) {
            throw new IOException("Cannot parse certificate from a null input stream!");
        }
        this.decode(inputStream);
    }

    public X509Certificate() {
        this.o = new ASN1();
    }
}

