/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.IssuerSerial;
import iaik.x509.attr.ObjectDigestInfo;
import iaik.x509.extensions.SubjectAltName;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;

public class Holder {
    ObjectDigestInfo a;
    GeneralNames b;
    IssuerSerial c;

    public String toString() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != null) {
            stringBuffer.append("baseCertificateID: " + this.c);
            bl = false;
        }
        if (this.b != null) {
            stringBuffer.append(String.valueOf(bl ? "" : "\n") + "entityName: " + this.b);
            bl = false;
        }
        if (this.a != null) {
            stringBuffer.append(String.valueOf(bl ? "" : "\n") + "objectDigestInfo: " + this.a);
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        boolean bl = false;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.c != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.c.toASN1Object(), bl));
        }
        if (this.b != null) {
            try {
                sEQUENCE.addComponent(new CON_SPEC(1, this.b.toASN1Object(), bl));
            }
            catch (CodingException codingException) {
                throw new InternalErrorException("Error when adding entityName component: " + codingException.getMessage(), codingException);
            }
        }
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, this.a.toASN1Object(), bl));
        }
        return sEQUENCE;
    }

    public void setObjectDigestInfo(ObjectDigestInfo objectDigestInfo) {
        this.a = objectDigestInfo;
    }

    public void setEntityName(GeneralNames generalNames) {
        this.b = generalNames;
    }

    public void setBaseCertificateID(IssuerSerial issuerSerial) {
        this.c = issuerSerial;
    }

    public boolean identifiesCert(X509Certificate x509Certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        if (this.c != null) {
            return this.c.identifiesCert(x509Certificate);
        }
        if (this.b != null) {
            Name name = (Name)x509Certificate.getSubjectDN();
            if (name != null && !name.isEmpty()) {
                GeneralName generalName = new GeneralName(GeneralName.directoryName, name);
                GeneralNames generalNames = new GeneralNames(generalName);
                return generalNames.equals(this.b);
            }
            try {
                SubjectAltName subjectAltName = (SubjectAltName)x509Certificate.getExtension(SubjectAltName.oid);
                GeneralNames generalNames = subjectAltName.getGeneralNames();
                if (this.b.equals(generalNames)) {
                    return true;
                }
                Enumeration enumeration = this.b.getNames();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)enumeration.nextElement();
                    Enumeration enumeration2 = generalNames.getNames();
                    bl = false;
                    while (enumeration2.hasMoreElements()) {
                        if (!generalName.equals(enumeration2.nextElement())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
            }
            catch (X509ExtensionException x509ExtensionException) {
                return false;
            }
            return false;
        }
        if (this.a != null) {
            return this.a.identifiesCert(x509Certificate);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.c != null) {
            n2 += this.c.hashCode();
        }
        if (this.b != null) {
            n2 += this.b.hashCode();
        }
        if (this.a != null) {
            n2 += this.a.hashCode();
        }
        return n2;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.a;
    }

    public GeneralNames getEntityName() {
        return this.b;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.c;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Holder)) {
            return false;
        }
        Holder holder = (Holder)object;
        if (this.c != null && holder.c != null ? !this.c.equals(holder.c) : this.c != null || holder.c != null) {
            return false;
        }
        if (this.b != null && holder.b != null ? !this.b.equals(holder.b) : this.b != null || holder.b != null) {
            return false;
        }
        if (this.a != null && holder.a != null) {
            return this.a.equals(holder.a);
        }
        return this.a == null && holder.a == null;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        int n2 = aSN1Object.countComponents();
        if (n2 > 3) {
            throw new CodingException("Cannot decode Holder: invalid number of components: " + n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n3);
            if (cON_SPEC.countComponents() > 1 || ((ASN1Object)cON_SPEC.getValue()).isA(ASN.CON_SPEC)) {
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
            }
            int n4 = cON_SPEC.getAsnType().getTag();
            switch (n4) {
                case 0: {
                    this.c = new IssuerSerial((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                case 1: {
                    this.b = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                case 2: {
                    this.a = new ObjectDigestInfo((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                default: {
                    throw new CodingException("Cannot decode Holder. Invalid tag: " + n4);
                }
            }
            ++n3;
        }
    }

    public boolean containsObjectDigestInfo() {
        return this.a != null;
    }

    public Holder(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public Holder() {
    }
}

