/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.ObsClient;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.security.EcsSecurityUtils;
import com.obs.services.internal.security.LimitedTimeSecurityKey;
import com.obs.services.internal.security.SecurityKey;
import com.obs.services.internal.security.SecurityKeyBean;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.model.ISecurityKey;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class EcsObsCredentialsProvider
implements IObsCredentialsProvider {
    private volatile LimitedTimeSecurityKey securityKey;
    private AtomicBoolean getNewKeyFlag = new AtomicBoolean(false);
    private static final ILogger ILOG = LoggerBuilder.getLogger(ObsClient.class);

    @Override
    public void setSecurityKey(ISecurityKey securityKey) {
        throw new UnsupportedOperationException("EcsObsCredentialsProvider class does not support this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISecurityKey getSecurityKey() {
        if (this.securityKey == null || this.securityKey.willSoonExpire()) {
            EcsObsCredentialsProvider ecsObsCredentialsProvider = this;
            synchronized (ecsObsCredentialsProvider) {
                if (this.securityKey == null || this.securityKey.willSoonExpire()) {
                    this.securityKey = this.getNewSecurityKey();
                }
            }
        } else if (this.securityKey.aboutToExpire()) {
            this.refresh();
        }
        return this.securityKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (this.getNewKeyFlag.compareAndSet(false, true)) {
            try {
                this.securityKey = this.getNewSecurityKey();
            }
            finally {
                this.getNewKeyFlag.set(false);
            }
        }
    }

    private LimitedTimeSecurityKey getNewSecurityKey() {
        SecurityKey securityInfo = null;
        String securityKeyInfo = new String();
        String detail = new String();
        try {
            List<String> list = EcsSecurityUtils.getSecurityKeyInfoWithDetail();
            if (list != null && list.size() == 2) {
                securityKeyInfo = list.get(0);
                detail = list.get(1);
                securityInfo = (SecurityKey)JSONChange.jsonToObj(new SecurityKey(), securityKeyInfo);
            }
        }
        catch (ServiceException se) {
            String errorMessage = "Get securityKey form ECS failed :" + se.getMessage() + " \n the detail : " + detail;
            ILOG.warn(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        catch (IOException e) {
            String errorMessage = "Get securityKey form ECS failed :" + e.getMessage() + " \n the detail : " + detail;
            ILOG.warn(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (securityInfo == null) {
            throw new IllegalArgumentException("Invalid securityKey");
        }
        Date expiryDate = new Date();
        SecurityKeyBean bean = securityInfo.getBean();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            String strDate = bean.getExpiresDate();
            expiryDate = df.parse(strDate.substring(0, strDate.length() - 4));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Date parse failed :" + e.getMessage());
        }
        StringBuilder strAccess = new StringBuilder();
        String accessKey = bean.getAccessKey();
        int length = accessKey.length();
        strAccess.append(accessKey.substring(0, length / 3));
        strAccess.append("******");
        strAccess.append(accessKey.substring(2 * length / 3, length - 1));
        ILOG.warn("the AccessKey : " + strAccess.toString() + "will expiry at UTC time : " + expiryDate);
        return new LimitedTimeSecurityKey(bean.getAccessKey(), bean.getSecretKey(), bean.getSecurityToken(), expiryDate);
    }
}

