/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class EcsSecurityUtils {
    private static final String OPENSTACK_METADATA_ROOT = "/openstack/latest";
    private static final String ECS_METADATA_SERIVCE_URL = "http://169.254.169.254";
    private static final String EC2_METADATA_SERVICE_OVERRIDE_URL = "ecsMetadataServiceOverrideEndpoint";
    private static final long HTTP_CONNECT_TIMEOUT_VALUE = 50000L;
    private static OkHttpClient httpClient = new OkHttpClient.Builder().followRedirects(false).retryOnConnectionFailure(false).cache(null).connectTimeout(50000L, TimeUnit.MILLISECONDS).writeTimeout(50000L, TimeUnit.MILLISECONDS).readTimeout(50000L, TimeUnit.MILLISECONDS).build();

    public static List<String> getSecurityKeyInfoWithDetail() throws IOException {
        List<String> list = EcsSecurityUtils.getResourceWithDetail(EcsSecurityUtils.getEndpointForECSMetadataService() + OPENSTACK_METADATA_ROOT + "/securitykey");
        return list;
    }

    public static String getEndpointForECSMetadataService() {
        String overridUrl = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE_URL);
        return overridUrl != null ? overridUrl : ECS_METADATA_SERIVCE_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getResourceWithDetail(String endpoint) throws IOException {
        Request.Builder builder = new Request.Builder();
        builder.header("Accept", "*/*");
        Request request = builder.url(endpoint).get().build();
        Call c = httpClient.newCall(request);
        Response res = null;
        String content = new String();
        ArrayList<String> list = new ArrayList<String>();
        try {
            res = c.execute();
            String header = new String();
            if (res.headers() != null) {
                header = res.headers().toString();
            }
            if (res.body() != null) {
                content = res.body().string();
            }
            String detail = "Get securityKey form ECS failed code:" + res.code() + " the headers : " + header + "the content : " + content;
            if (res.code() < 200 || res.code() >= 300) {
                String errorMessage = "Get securityKey form ECS failed the detail : " + detail;
                throw new IllegalArgumentException(errorMessage);
            }
            list.add(content);
            list.add(detail);
        }
        finally {
            if (res != null) {
                res.close();
            }
        }
        return list;
    }
}

