/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.Constants;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ReflectUtils;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HttpProtocolTypeEnum;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Headers;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ServiceUtils {
    private static final ILogger log = LoggerBuilder.getLogger(ServiceUtils.class);
    protected static final String iso8601DateParserString = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String iso8601DateMidnightParserString = "yyyy-MM-dd'T'00:00:00'Z'";
    protected static final String iso8601DateParser_WalrusString = "yyyy-MM-dd'T'HH:mm:ss";
    protected static final String rfc822DateParserString = "EEE, dd MMM yyyy HH:mm:ss z";
    protected static final String _iso8601DateParserString = "yyyy-MM-dd";
    private static Pattern pattern = Pattern.compile("^((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)$");

    public static boolean isValid(String s) {
        return s != null && !s.trim().equals("");
    }

    public static boolean isValid2(String s) {
        return s != null && !s.equals("");
    }

    public static String toValid(String s) {
        return s == null ? "" : s;
    }

    public static void asserParameterNotNull(String value, String errorMessage) {
        if (!ServiceUtils.isValid(value)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void asserParameterNotNull2(String value, String errorMessage) {
        if (value == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void asserParameterNotNull(Object value, String errorMessage) {
        if (value == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static Date parseIso8601Date(String dateString) throws ParseException {
        ParseException exception = null;
        SimpleDateFormat iso8601DateParser = new SimpleDateFormat(iso8601DateParserString);
        TimeZone gmt = Constants.GMT_TIMEZONE;
        iso8601DateParser.setTimeZone(gmt);
        try {
            return iso8601DateParser.parse(dateString);
        }
        catch (ParseException e) {
            exception = e;
            SimpleDateFormat iso8601DateParser_Walrus = new SimpleDateFormat(iso8601DateParser_WalrusString);
            iso8601DateParser_Walrus.setTimeZone(gmt);
            try {
                return iso8601DateParser_Walrus.parse(dateString);
            }
            catch (ParseException e2) {
                exception = e2;
                SimpleDateFormat _iso8601DateParser = new SimpleDateFormat(_iso8601DateParserString);
                _iso8601DateParser.setTimeZone(gmt);
                try {
                    return _iso8601DateParser.parse(dateString);
                }
                catch (Exception exception2) {
                    throw exception;
                }
            }
        }
    }

    public static String formatIso8601Date(Date date) {
        SimpleDateFormat iso8601DateParser = new SimpleDateFormat(iso8601DateParserString);
        iso8601DateParser.setTimeZone(Constants.GMT_TIMEZONE);
        return iso8601DateParser.format(date);
    }

    public static String formatIso8601MidnightDate(Date date) {
        SimpleDateFormat iso8601DateParser = new SimpleDateFormat(iso8601DateMidnightParserString);
        iso8601DateParser.setTimeZone(Constants.GMT_TIMEZONE);
        return iso8601DateParser.format(date);
    }

    public static Date parseRfc822Date(String dateString) throws ParseException {
        SimpleDateFormat rfc822DateParser = new SimpleDateFormat(rfc822DateParserString, Locale.US);
        rfc822DateParser.setTimeZone(Constants.GMT_TIMEZONE);
        return rfc822DateParser.parse(dateString);
    }

    public static String formatRfc822Date(Date date) {
        SimpleDateFormat rfc822DateParser = new SimpleDateFormat(rfc822DateParserString, Locale.US);
        rfc822DateParser.setTimeZone(Constants.GMT_TIMEZONE);
        return rfc822DateParser.format(date);
    }

    public static String signWithHmacSha1(String sk, String canonicalString) throws ServiceException {
        SecretKeySpec signingKey = null;
        try {
            signingKey = new SecretKeySpec(sk.getBytes("UTF-8"), "HmacSHA1");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to get bytes from secret string", e);
        }
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        try {
            return ServiceUtils.toBase64(mac.doFinal(canonicalString.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to get bytes from canonical string", e);
        }
    }

    public static Map<String, Object> cleanRestMetadataMap(Map<String, List<String>> metadata, String headerPrefix, String metadataPrefix) {
        if (log.isDebugEnabled()) {
            log.debug("Cleaning up REST metadata items");
        }
        TreeMap<String, Object> cleanMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (metadata != null) {
            for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
                ArrayList<String> value;
                String key;
                block31: {
                    ArrayList<String> _values;
                    key = entry.getKey();
                    List<String> values = entry.getValue();
                    if (key == null || values == null) continue;
                    ArrayList<String> arrayList = value = values.size() == 1 ? values.get(0) : values;
                    if ("Date".equalsIgnoreCase(key) || "Last-Modified".equalsIgnoreCase(key)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Parsing date string '" + value + "' into Date object for key: " + key);
                        }
                        try {
                            value = ServiceUtils.parseRfc822Date(((Object)value).toString());
                        }
                        catch (ParseException pe) {
                            try {
                                value = ServiceUtils.parseIso8601Date(((Object)value).toString());
                            }
                            catch (ParseException pe2) {
                                if (!log.isWarnEnabled()) break block31;
                                log.warn("Date string is not RFC 822 compliant for metadata field " + key, pe);
                            }
                        }
                    } else if (key.toLowerCase().startsWith(headerPrefix)) {
                        try {
                            if (key.toLowerCase().startsWith(metadataPrefix)) {
                                key = key.substring(metadataPrefix.length(), key.length());
                                key = URLDecoder.decode(key, "UTF-8");
                                if (log.isDebugEnabled()) {
                                    log.debug("Removed meatadata header prefix " + metadataPrefix + " from key: " + key + "=>" + key);
                                }
                            } else {
                                key = key.substring(headerPrefix.length(), key.length());
                            }
                            if (value instanceof List) {
                                _values = new ArrayList<String>(values.size());
                                for (String _value : values) {
                                    _values.add(_value != null ? URLDecoder.decode(_value, "UTF-8") : null);
                                }
                                value = _values;
                                break block31;
                            }
                            value = URLDecoder.decode(((Object)value).toString(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isDebugEnabled()) break block31;
                            log.debug("Error to decode value of key:" + key);
                        }
                    } else if (key.toLowerCase().startsWith("x-obs-")) {
                        try {
                            if (key.toLowerCase().startsWith("x-obs-meta-")) {
                                key = key.substring("x-obs-meta-".length(), key.length());
                                key = URLDecoder.decode(key, "UTF-8");
                                if (log.isDebugEnabled()) {
                                    log.debug("Removed meatadata header prefix x-obs-meta- from key: " + key + "=>" + key);
                                }
                            } else {
                                key = key.substring("x-obs-".length(), key.length());
                            }
                            if (value instanceof List) {
                                _values = new ArrayList(values.size());
                                for (String _value : values) {
                                    _values.add(_value != null ? URLDecoder.decode(_value, "UTF-8") : null);
                                }
                                value = _values;
                                break block31;
                            }
                            value = URLDecoder.decode(((Object)value).toString(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isDebugEnabled()) break block31;
                            log.debug("Error to decode value of key:" + key);
                        }
                    } else if (Constants.ALLOWED_RESPONSE_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault()))) {
                        if (log.isDebugEnabled()) {
                            log.debug("Leaving HTTP header item unchanged: " + key + "=" + values);
                        }
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Ignoring metadata item: " + key + "=" + values);
                        continue;
                    }
                }
                cleanMap.put(key, value);
            }
        }
        return cleanMap;
    }

    public static Map<String, String> cleanRestMetadataMapV2(Map<String, String> metadata, String headerPrefix, String metadataPrefix) {
        if (log.isDebugEnabled()) {
            log.debug("Cleaning up REST metadata items");
        }
        IdentityHashMap<String, String> cleanMap = new IdentityHashMap<String, String>();
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                String value;
                String key;
                block20: {
                    key = entry.getKey();
                    value = entry.getValue();
                    String string = key = key != null ? key.toString() : "";
                    if (key.toLowerCase().startsWith(headerPrefix)) {
                        try {
                            if (key.toLowerCase().startsWith(metadataPrefix)) {
                                key = key.substring(metadataPrefix.length(), key.length());
                                key = URLDecoder.decode(key, "UTF-8");
                                if (log.isDebugEnabled()) {
                                    log.debug("Removed meatadata header prefix " + metadataPrefix + " from key: " + key + "=>" + key);
                                }
                            } else {
                                key = key.substring(headerPrefix.length(), key.length());
                            }
                            value = URLDecoder.decode(value.toString(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isDebugEnabled()) break block20;
                            log.debug("Error to decode value of key:" + key);
                        }
                    } else if (key.toLowerCase().startsWith("x-obs-")) {
                        try {
                            if (key.toLowerCase().startsWith("x-obs-meta-")) {
                                key = key.substring("x-obs-meta-".length(), key.length());
                                key = URLDecoder.decode(key, "UTF-8");
                                if (log.isDebugEnabled()) {
                                    log.debug("Removed meatadata header prefix x-obs-meta- from key: " + key + "=>" + key);
                                }
                            } else {
                                key = key.substring("x-obs-".length(), key.length());
                            }
                            value = URLDecoder.decode(value.toString(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isDebugEnabled()) break block20;
                            log.debug("Error to decode value of key:" + key);
                        }
                    } else if (Constants.ALLOWED_RESPONSE_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault()))) {
                        if (log.isDebugEnabled()) {
                            log.debug("Leaving HTTP header item unchanged: " + key + "=" + value);
                        }
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Ignoring metadata item: " + key + "=" + value);
                        continue;
                    }
                }
                cleanMap.put(new String(key), value);
            }
        }
        return cleanMap;
    }

    public static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    public static byte[] fromHex(String hexData) {
        if ((hexData.length() & 1) != 0 || hexData.replaceAll("[a-fA-F0-9]", "").length() > 0) {
            throw new IllegalArgumentException("'" + hexData + "' is not a hex string");
        }
        byte[] result = new byte[(hexData.length() + 1) / 2];
        String hexNumber = null;
        int byteOffset = 0;
        for (int stringOffset = 0; stringOffset < hexData.length(); stringOffset += 2) {
            hexNumber = hexData.substring(stringOffset, stringOffset + 2);
            result[byteOffset++] = (byte)Integer.parseInt(hexNumber, 16);
        }
        return result;
    }

    public static String toBase64(byte[] data) {
        return ReflectUtils.toBase64(data);
    }

    public static String join(Object[] items, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(List<?> items, String delimiter, boolean needTrim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i).toString();
            sb.append(needTrim ? item.trim() : item);
            if (i >= items.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(List<?> items, String delimiter) {
        return ServiceUtils.join(items, delimiter, false);
    }

    public static String join(Headers headers, String delimiter, List<String> excludes) {
        if (excludes == null) {
            excludes = new ArrayList<String>();
        }
        StringBuilder sb = new StringBuilder();
        Map map = headers.toMultimap();
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (!excludes.contains(entry.getKey())) {
                sb.append(entry.getValue());
            }
            if (i >= map.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(int[] ints, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ints.length; ++i) {
            sb.append(ints[i]);
            if (i >= ints.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static byte[] fromBase64(String b64Data) throws UnsupportedEncodingException {
        return ReflectUtils.fromBase64(b64Data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            ServiceUtils.closeStream(bis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is, long length, long offset) throws NoSuchAlgorithmException, IOException {
        byte[] byArray;
        BufferedInputStream bis = null;
        try {
            long bufLen;
            bis = new BufferedInputStream(is);
            if (offset > 0L) {
                long skipByte = bis.skip(offset);
                if (log.isDebugEnabled()) {
                    log.debug("computeMD5Hash: Skip " + skipByte + " bytes");
                }
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            long readLen = 0L;
            long l = bufLen = 16384L > length ? length : 16384L;
            while (readLen < length && (bytesRead = bis.read(buffer, 0, (int)bufLen)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
                bufLen = length - (readLen += (long)bytesRead) > 16384L ? 16384L : length - readLen;
            }
            byArray = messageDigest.digest();
        }
        catch (Throwable throwable) {
            ServiceUtils.closeStream(bis);
            throw throwable;
        }
        ServiceUtils.closeStream(bis);
        return byArray;
    }

    public static String computeMD5(String data) throws ServiceException {
        try {
            return ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("Failed to get MD5 for requestXmlElement:" + data);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Failed to get MD5 for requestXmlElement:" + data);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to get MD5 for requestXmlElement:" + data);
        }
    }

    public static byte[] computeMD5Hash(byte[] data) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.computeMD5Hash(new ByteArrayInputStream(data));
    }

    public static boolean isBucketNameValidDNSName(String bucketName) {
        if (bucketName == null || bucketName.length() > 63 || bucketName.length() < 3) {
            return false;
        }
        if (!Pattern.matches("^[a-z0-9][a-z0-9.-]+$", bucketName)) {
            return false;
        }
        if (Pattern.matches("([0-9]{1,3}\\.){3}[0-9]{1,3}", bucketName)) {
            return false;
        }
        String[] fragments = bucketName.split("\\.");
        for (int i = 0; i < fragments.length; ++i) {
            if (!Pattern.matches("^-.*", fragments[i]) && !Pattern.matches(".*-$", fragments[i]) && !Pattern.matches("^$", fragments[i])) continue;
            return false;
        }
        return true;
    }

    public static String generateHostnameForBucket(String bucketName, boolean pathStyle, String endpoint) {
        if (!ServiceUtils.isBucketNameValidDNSName(bucketName)) {
            throw new IllegalArgumentException("the bucketName is illegal");
        }
        if (!pathStyle) {
            return bucketName + "." + endpoint;
        }
        return endpoint;
    }

    public static XMLReader loadXMLReader() throws ServiceException {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (Exception e) {
            Exception ex = e;
            String[] altXmlReaderClasspaths = new String[]{"org.apache.crimson.parser.XMLReaderImpl", "org.xmlpull.v1.sax2.Driver"};
            for (int i = 0; i < altXmlReaderClasspaths.length; ++i) {
                String xmlReaderClasspath = altXmlReaderClasspaths[i];
                try {
                    return XMLReaderFactory.createXMLReader(xmlReaderClasspath);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            throw new ServiceException("Failed to initialize a SAX XMLReader", ex);
        }
    }

    public static SimpleDateFormat getShortDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        format.setTimeZone(Constants.GMT_TIMEZONE);
        return format;
    }

    public static SimpleDateFormat getLongDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        format.setTimeZone(Constants.GMT_TIMEZONE);
        return format;
    }

    public static SimpleDateFormat getHeaderDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat(rfc822DateParserString);
        format.setTimeZone(Constants.GMT_TIMEZONE);
        return format;
    }

    public static SimpleDateFormat getExpirationDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat(iso8601DateParserString);
        format.setTimeZone(Constants.GMT_TIMEZONE);
        return format;
    }

    public static ObsException changeFromServiceException(ServiceException se) {
        ObsException exception;
        if (se.getResponseCode() < 0) {
            exception = new ObsException("OBS servcie Error Message. " + se.getMessage(), se.getCause());
        } else {
            exception = new ObsException((se.getMessage() != null ? "Error message:" + se.getMessage() : "") + "OBS servcie Error Message.", se.getXmlMessage(), se.getCause());
            exception.setErrorCode(se.getErrorCode());
            exception.setErrorMessage(se.getErrorMessage() == null ? se.getMessage() : se.getErrorMessage());
            exception.setErrorRequestId(se.getErrorRequestId());
            exception.setErrorHostId(se.getErrorHostId());
            exception.setResponseCode(se.getResponseCode());
            exception.setResponseStatus(se.getResponseStatus());
            exception.setResponseHeaders(se.getResponseHeaders());
            exception.setErrorIndicator(se.getErrorIndicator());
        }
        return exception;
    }

    public static void closeStream(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream in) throws IOException {
        String ret = null;
        if (in != null) {
            StringBuilder sb = new StringBuilder();
            BufferedReader br = null;
            try {
                String temp;
                br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((temp = br.readLine()) != null) {
                    sb.append(temp);
                }
                ret = sb.toString();
            }
            catch (Throwable throwable) {
                ServiceUtils.closeStream(br);
                ServiceUtils.closeStream(in);
                throw throwable;
            }
            ServiceUtils.closeStream(br);
            ServiceUtils.closeStream(in);
        }
        return ret;
    }

    public static ObsProperties changeFromObsConfiguration(ObsConfiguration config) {
        Matcher m;
        int index;
        ObsProperties obsProperties = new ObsProperties();
        String endPoint = config.getEndPoint();
        while ((index = endPoint.lastIndexOf("/")) == endPoint.length() - 1) {
            endPoint = endPoint.substring(0, index);
        }
        if (endPoint.startsWith("http://")) {
            config.setHttpsOnly(false);
            endPoint = endPoint.substring("http://".length());
        } else if (endPoint.startsWith("https://")) {
            config.setHttpsOnly(true);
            endPoint = endPoint.substring("https://".length());
        }
        index = endPoint.lastIndexOf(":");
        if (index > 0) {
            int port = Integer.parseInt(endPoint.substring(index + 1));
            if (config.isHttpsOnly()) {
                config.setEndpointHttpsPort(port);
            } else {
                config.setEndpointHttpPort(port);
            }
            endPoint = endPoint.substring(0, index);
        }
        if ((m = pattern.matcher(endPoint)).matches()) {
            config.setPathStyle(true);
        }
        if (config.isPathStyle() || config.isCname()) {
            config.setAuthTypeNegotiation(false);
            if (config.getAuthType() == AuthTypeEnum.OBS) {
                config.setAuthType(AuthTypeEnum.V2);
            }
        }
        config.setEndPoint(endPoint);
        obsProperties.setProperty("obs-endpoint", config.getEndPoint());
        obsProperties.setProperty("obs-endpoint-http-port", String.valueOf(config.getEndpointHttpPort()));
        obsProperties.setProperty("obs.https-only", String.valueOf(config.isHttpsOnly()));
        obsProperties.setProperty("obs.disable-dns-buckets", String.valueOf(config.isPathStyle()));
        obsProperties.setProperty("obs-endpoint-https-port", String.valueOf(config.getEndpointHttpsPort()));
        obsProperties.setProperty("httpclient.socket-timeout-ms", String.valueOf(config.getSocketTimeout()));
        obsProperties.setProperty("httpclient.max-connections", String.valueOf(config.getMaxConnections()));
        obsProperties.setProperty("httpclient.retry-max", String.valueOf(config.getMaxErrorRetry()));
        obsProperties.setProperty("httpclient.connection-timeout-ms", String.valueOf(config.getConnectionTimeout()));
        obsProperties.setProperty("httpclient.proxy-enable", String.valueOf(Boolean.FALSE));
        obsProperties.setProperty("uploads.stream-retry-buffer-size", String.valueOf(config.getUploadStreamRetryBufferSize() > 0 ? config.getUploadStreamRetryBufferSize() : 524288));
        obsProperties.setProperty("httpclient.validate-certificate", String.valueOf(config.isValidateCertificate()));
        obsProperties.setProperty("obs.verify-content-type", String.valueOf(config.isVerifyResponseContentType()));
        obsProperties.setProperty("httpclient.write-buffer-size", String.valueOf(config.getWriteBufferSize()));
        obsProperties.setProperty("httpclient.read-buffer-size", String.valueOf(config.getReadBufferSize()));
        obsProperties.setProperty("socket.write-buffer-size", String.valueOf(config.getSocketWriteBufferSize()));
        obsProperties.setProperty("socket.read-buffer-size", String.valueOf(config.getSocketReadBufferSize()));
        obsProperties.setProperty("httpclient.strict-hostname-verification", String.valueOf(config.isStrictHostnameVerification()));
        obsProperties.setProperty("httpclient.idle-connection-time", String.valueOf(config.getIdleConnectionTime()));
        obsProperties.setProperty("httpclient.max-idle-connections", String.valueOf(config.getMaxIdleConnections()));
        obsProperties.setProperty("httpclient.ssl-provider", config.getSslProvider() == null ? "" : config.getSslProvider());
        obsProperties.setProperty("httpclient.keep-alive", String.valueOf(config.isKeepAlive()));
        obsProperties.setProperty("filesystem.delimiter", config.getDelimiter() == null ? "/" : config.getDelimiter());
        obsProperties.setProperty("httpclient.protocol", config.getHttpProtocolType() == null ? HttpProtocolTypeEnum.HTTP1_1.getCode() : config.getHttpProtocolType().getCode());
        obsProperties.setProperty("httpclient.is-cname", String.valueOf(config.isCname()));
        obsProperties.setProperty("httpclient.auth-type-negotiation", String.valueOf(config.isAuthTypeNegotiation()));
        if (null != config.getHttpProxy()) {
            obsProperties.setProperty("httpclient.proxy-enable", String.valueOf(Boolean.TRUE));
            obsProperties.setProperty("httpclient.proxy-host", config.getHttpProxy().getProxyAddr());
            obsProperties.setProperty("httpclient.proxy-port", String.valueOf(config.getHttpProxy().getProxyPort()));
            obsProperties.setProperty("httpclient.proxy-user", config.getHttpProxy().getProxyUName());
            obsProperties.setProperty("httpclient.proxy-password", config.getHttpProxy().getUserPaaswd());
            obsProperties.setProperty("httpclient.proxy-domain", config.getHttpProxy().getDomain());
            obsProperties.setProperty("httpclient.proxy-workstation", config.getHttpProxy().getWorkstation());
        }
        return obsProperties;
    }
}

