/*
 * Decompiled with CFR 0.152.
 */
package com.obs.shade.jamesmurty.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;

public class NamespaceContextImpl
implements NamespaceContext {
    protected Element element = null;
    protected Map<String, String> prefixToNsUriMap = new HashMap<String, String>();
    protected Map<String, Set<String>> nsUriToPrefixesMap = new HashMap<String, Set<String>>();

    public NamespaceContextImpl() {
    }

    public NamespaceContextImpl(Element element) {
        this.element = element;
    }

    public void addNamespace(String prefix, String namespaceURI) {
        this.prefixToNsUriMap.put(prefix, namespaceURI);
        if (this.nsUriToPrefixesMap.get(namespaceURI) == null) {
            this.nsUriToPrefixesMap.put(namespaceURI, new HashSet());
        }
        this.nsUriToPrefixesMap.get(namespaceURI).add(prefix);
    }

    public String getNamespaceURI(String prefix) {
        String namespaceURI = this.prefixToNsUriMap.get(prefix);
        if (namespaceURI == null && this.element != null) {
            if (prefix != null && prefix.length() == 0) {
                prefix = null;
            }
            namespaceURI = this.element.lookupNamespaceURI(prefix);
        }
        return namespaceURI;
    }

    public String getPrefix(String namespaceURI) {
        Set<String> prefixes = this.nsUriToPrefixesMap.get(namespaceURI);
        if (prefixes != null && prefixes.size() > 0) {
            return prefixes.iterator().next();
        }
        if (this.element != null) {
            return this.element.lookupPrefix(namespaceURI);
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return Collections.EMPTY_LIST.iterator();
    }
}

