/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.documents.excel;

import com.grapecity.documents.excel.IJSR310TypeHandler;
import com.grapecity.documents.excel.f.J;
import com.grapecity.documents.excel.f.bQ;
import com.grapecity.documents.excel.z.y;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;

@y
public class JSR310TypeHandler
implements IJSR310TypeHandler {
    private static final long a = 10000L;
    private static final long b = 10000000L;
    private static final long c = 600000000L;
    private static final long d = 36000000000L;
    private static final long e = 864000000000L;
    private static final double f = 1.1574074074074074E-12;
    private static final int g = 1000000;
    private static final int h = 100;
    private static final int[] i = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] j = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};

    public boolean isHandled(Object object) {
        return object instanceof LocalDate || object instanceof LocalTime || object instanceof LocalDateTime || object instanceof Instant || object instanceof MonthDay || object instanceof OffsetDateTime || object instanceof OffsetTime || object instanceof Year || object instanceof YearMonth || object instanceof ZonedDateTime;
    }

    public int getDateTimeType(Object object) {
        if (object instanceof LocalDate || object instanceof LocalDateTime || object instanceof Instant || object instanceof MonthDay || object instanceof OffsetDateTime || object instanceof Year || object instanceof YearMonth || object instanceof ZonedDateTime) {
            return 1;
        }
        if (object instanceof LocalTime || object instanceof OffsetTime) {
            return 2;
        }
        return 0;
    }

    public Object fromOADate(double d) {
        J j = J.g((double)d);
        return LocalDateTime.of(j.r(), j.k(), j.d(), j.g(), j.j(), j.n(), (int)(j.o() % 10000000L) * 100);
    }

    public double toOADate(Object object) {
        long l = this.toTicks(object);
        if (object instanceof LocalTime || object instanceof OffsetTime) {
            return JSR310TypeHandler.toTotalDays(l);
        }
        return J.c((long)l);
    }

    public long toTicks(Object object) {
        long l = 0L;
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            l = J.a((int)localDate.getYear(), (int)localDate.getMonthValue(), (int)localDate.getDayOfMonth());
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            l = bQ.a((int)localTime.getHour(), (int)localTime.getMinute(), (int)localTime.getSecond());
            l += (long)(localTime.getNano() / 100);
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            l = J.a((int)localDateTime.getYear(), (int)localDateTime.getMonthValue(), (int)localDateTime.getDayOfMonth());
            l += bQ.a((int)localDateTime.getHour(), (int)localDateTime.getMinute(), (int)localDateTime.getSecond());
            l += (long)(localDateTime.getNano() / 100);
        } else if (object instanceof Instant) {
            Instant instant = (Instant)object;
            l = J.a((int)1970, (int)1, (int)1);
            l += instant.getEpochSecond() * 10000000L;
            l += (long)(instant.getNano() / 100);
        } else if (object instanceof MonthDay) {
            MonthDay monthDay = (MonthDay)object;
            l = J.a((int)LocalDate.now().getYear(), (int)monthDay.getMonthValue(), (int)monthDay.getDayOfMonth());
        } else if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            l = J.a((int)offsetDateTime.getYear(), (int)offsetDateTime.getMonthValue(), (int)offsetDateTime.getDayOfMonth());
            l += bQ.a((int)offsetDateTime.getHour(), (int)offsetDateTime.getMinute(), (int)offsetDateTime.getSecond());
            l += (long)(offsetDateTime.getNano() / 100);
        } else if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            l = bQ.a((int)offsetTime.getHour(), (int)offsetTime.getMinute(), (int)offsetTime.getSecond());
            l += (long)(offsetTime.getNano() / 100);
        } else if (object instanceof Year) {
            Year year = (Year)object;
            l = J.a((int)year.getValue(), (int)1, (int)1);
        } else if (object instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)object;
            l = J.a((int)yearMonth.getYear(), (int)yearMonth.getMonthValue(), (int)1);
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            l = J.a((int)zonedDateTime.getYear(), (int)zonedDateTime.getMonthValue(), (int)zonedDateTime.getDayOfMonth());
            l += bQ.a((int)zonedDateTime.getHour(), (int)zonedDateTime.getMinute(), (int)zonedDateTime.getSecond());
            l += (long)(zonedDateTime.getNano() / 100);
        }
        return l;
    }

    private static double toTotalDays(long l) {
        return (double)l * 1.1574074074074074E-12;
    }
}

