/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel;

import com.huawei.gauss.channel.CHandlerContext;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.handler.ChannelHandler;
import com.huawei.gauss.jdbc.AbstractGaussLob;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.IGaussDriver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class DefaultCHandlerContext<ResT>
implements CHandlerContext<ResT> {
    protected final GaussStatement statement;
    protected ResT result;
    private final IGaussDriver gaussDriver;
    private final GaussConnection gaussConnection;
    private SQLException exception;
    private Map<String, Object> attachments = new HashMap<String, Object>();

    public DefaultCHandlerContext(IGaussDriver gaussDriver, GaussConnection gaussConnection, GaussStatement statement) {
        this.gaussDriver = gaussDriver;
        this.gaussConnection = gaussConnection;
        this.statement = statement;
    }

    @Override
    public GaussConnection getGaussConnection() {
        return this.gaussConnection;
    }

    @Override
    public IGaussDriver getGaussDriver() {
        return this.gaussDriver;
    }

    @Override
    public SQLException getException() {
        return this.exception;
    }

    @Override
    public ResT getResult() {
        return this.result;
    }

    @Override
    public GaussStatement getStatement() {
        return this.statement;
    }

    public abstract CHandlerContext.ProcessState preProcess(ChannelHandler var1) throws SQLException;

    public abstract void postProcess(ChannelHandler var1) throws SQLException;

    @Override
    public void setException(Throwable exception) {
        SQLException nextException = null;
        nextException = exception instanceof SQLException ? (SQLException)exception : new SQLException(exception);
        if (null != this.exception) {
            this.exception.setNextException(nextException);
        } else {
            this.exception = nextException;
        }
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public void setAttachment(String attachmentName, Object attachment) {
        this.attachments.put(attachmentName, attachment);
    }

    @Override
    public <T> T getAttachment(String attachmentName, Class<T> classType) throws ClassCastException {
        return (T)this.attachments.get(attachmentName);
    }

    public int isAutoCommit() {
        return this.statement.isAutoCommit() ? 1 : 0;
    }

    public int getStatementId() {
        return -1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CHandlerContext [gaussDriver=");
        builder.append(this.gaussDriver);
        builder.append(", gaussConnection=");
        builder.append(this.gaussConnection);
        builder.append(", statement=");
        builder.append(this.statement);
        builder.append(", result=");
        builder.append(this.result);
        builder.append(", exception=");
        builder.append(this.exception);
        builder.append(", attachments=");
        builder.append(this.attachments);
        builder.append("]");
        return builder.toString();
    }

    public AbstractGaussLob getGaussLob() throws SQLException {
        throw ExceptionUtil.notSupportedFeature("Is not Clob or Blob Context.");
    }
}

