/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel.context.statement;

import com.huawei.gauss.channel.context.statement.FieldType;
import com.huawei.gauss.channel.context.statement.ParamsData;
import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.exception.ExceptionUtil;
import com.huawei.gauss.jdbc.GaussConnection;
import com.huawei.gauss.jdbc.GaussPrepareStatement;
import com.huawei.gauss.jdbc.GaussResultSet;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import com.huawei.gauss.util.BytesUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class CallableParams {
    public static final int PARAM_IN = 1;
    public static final int PARAM_OUT = 2;
    public static final int PARAM_INOUT = 3;
    private static final int NULL_LENGTH = 0;
    private static final int FOUR_LENGTH = 1;
    private static final int EIGHT_LENGTH = 2;
    private static final int CHANGE_LENGTH = 3;
    protected final Map<Integer, Integer> paramIndex2outIndex = new HashMap<Integer, Integer>();
    protected final Map<String, Integer> paramName2outIndex = new HashMap<String, Integer>();
    protected final boolean isBigEndianess;
    protected GaussResultSet outParamResultSet;
    private int outParamCount = 0;
    private RowsData.FieldValue[] outValues = null;
    private CallableParamDef[] outParamsDef = null;
    private GaussStatement gaussStatement = null;

    public CallableParams(GaussStatement stmt) throws SQLException {
        this.gaussStatement = stmt;
        GaussStatementImpl gaussStatement = (GaussStatementImpl)stmt;
        GaussConnectionImpl gaussConnection = (GaussConnectionImpl)gaussStatement.getConnection();
        this.isBigEndianess = gaussConnection.getIOClient().isBigEndian();
        GaussResultSetImpl resultSetImpl = new GaussResultSetImpl(gaussStatement, null);
        gaussConnection.getZenithDriver().getChannelHandlerFactory().createResultSetCHandlers(resultSetImpl.getChannelHandlers(), gaussConnection);
        this.outParamResultSet = resultSetImpl;
    }

    public void decodeCallableParamDefs(ByteBuffer buffer) throws SQLException {
        GaussPrepareStatement ps;
        this.outParamCount = 0;
        this.paramIndex2outIndex.clear();
        this.paramName2outIndex.clear();
        this.outValues = null;
        this.outParamCount = buffer.getInt();
        this.outParamsDef = new CallableParamDef[this.outParamCount];
        for (int i = 0; i < this.outParamCount; ++i) {
            CallableParamDef oneParamDef = new CallableParamDef();
            oneParamDef.decodeCallableParamDef(buffer);
            this.outParamsDef[i] = oneParamDef;
        }
        if (this.gaussStatement instanceof GaussPrepareStatement && (ps = (GaussPrepareStatement)this.gaussStatement).getParamsData().getParamsCache().size() == 1) {
            ParamsData.ParamData paramData = ps.getParamsData().getParamsCache().get(0);
            int count = 0;
            for (int i = 0; i < paramData.params.length; ++i) {
                if (!paramData.isOutParam(i)) continue;
                if (count < this.outParamCount) {
                    this.paramIndex2outIndex.put(i + 1, count + 1);
                    this.paramName2outIndex.put(this.outParamsDef[count].paramName, count + 1);
                }
                ++count;
            }
            if (count != this.outParamCount) {
                throw ExceptionUtil.illegalJDBCArgumentException("out parameter count(" + this.outParamCount + ") is not equal to register out parameter count(" + count + ")");
            }
        }
    }

    public void decodeCallableOutParamValues(ByteBuffer buffer) throws SQLException {
        buffer.getShort();
        buffer.getShort();
        buffer.get();
        int bitmapLen = this.outParamCount <= 12 ? 3 : 3 + ((this.outParamCount - 12 + 15 & 0xFFFFF0) >> 2);
        byte[] bitmap = new byte[bitmapLen];
        buffer.get(bitmap);
        this.outValues = new RowsData.FieldValue[this.outParamCount];
        int columnFlag = -1;
        for (int j = 0; j < this.outParamCount; ++j) {
            if (j % 4 == 0) {
                columnFlag = bitmap[j >> 2];
            }
            switch (columnFlag & 3) {
                case 0: {
                    this.outValues[j] = new RowsData.FieldValue(-1, new byte[0]);
                    break;
                }
                case 1: {
                    byte[] bytes4 = new byte[4];
                    buffer.get(bytes4);
                    this.outValues[j] = new RowsData.FieldValue(4, bytes4);
                    break;
                }
                case 2: {
                    byte[] bytes8 = new byte[8];
                    buffer.get(bytes8);
                    this.outValues[j] = new RowsData.FieldValue(8, bytes8);
                    break;
                }
                case 3: {
                    byte[] len = new byte[2];
                    buffer.get(len);
                    int curColumnLength = BytesUtil.toUnsignedShort(len, 0, buffer.order().equals(ByteOrder.BIG_ENDIAN));
                    int curColumnTmp = curColumnLength + (4 - (curColumnLength + 2) % 4) % 4;
                    byte[] bytes = new byte[curColumnTmp];
                    buffer.get(bytes);
                    this.outValues[j] = new RowsData.FieldValue(curColumnLength, bytes);
                    break;
                }
            }
            columnFlag >>= 2;
        }
    }

    public <T> T getCallableOutValueByColumnIndex(int columnIndex, Class<T> desireType, Calendar cal) throws SQLException {
        this.isValidIndex(columnIndex);
        int realOutIndex = this.paramIndex2outIndex.get(columnIndex);
        FieldType fieldType = this.outParamsDef[realOutIndex - 1].paramType;
        try {
            return this.outValues[realOutIndex - 1].getValue(fieldType, desireType, this.isBigEndianess, cal, (GaussConnection)this.gaussStatement.getConnection());
        }
        catch (RuntimeException e) {
            StringBuilder err = new StringBuilder();
            err.append("Get column [");
            err.append(fieldType.getName());
            err.append("] value failed");
            err.append(", cause data type is [");
            err.append(fieldType.getName()).append("]");
            err.append(", but desired data type is [");
            err.append(desireType.getName()).append("].");
            throw ExceptionUtil.processJDBCException(err.toString(), "S1002", 635, e);
        }
    }

    public <T> T getCallableOutValueByColumnName(String columnName, Class<T> desireType, Calendar cal) throws SQLException {
        this.isValidName(columnName);
        int realOutIndex = this.paramName2outIndex.get(columnName);
        FieldType fieldType = this.outParamsDef[realOutIndex - 1].paramType;
        return this.outValues[realOutIndex - 1].getValue(fieldType, desireType, this.isBigEndianess, cal, (GaussConnection)this.gaussStatement.getConnection());
    }

    public int getColumnIndex(String columnName) throws SQLException {
        this.isValidName(columnName);
        return this.paramName2outIndex.get(columnName);
    }

    public boolean wasNull(int columnIndex) throws SQLException {
        this.isValidIndex(columnIndex);
        int realOutIndex = this.paramIndex2outIndex.get(columnIndex);
        return this.outValues[realOutIndex - 1].wasNull();
    }

    public FieldType getColumnType(int columnIndex) throws SQLException {
        this.isValidIndex(columnIndex);
        int realOutIndex = this.paramIndex2outIndex.get(columnIndex);
        return this.outParamsDef[realOutIndex - 1].paramType;
    }

    public void isValidIndex(int columnIndex) throws SQLException {
        if (columnIndex <= 0) {
            throw ExceptionUtil.illegalJDBCArgumentException("Column index must larger than 0!");
        }
        if (!this.paramIndex2outIndex.containsKey(columnIndex)) {
            throw ExceptionUtil.illegalJDBCArgumentException("invalid column index");
        }
    }

    public void isValidName(String columnName) throws SQLException {
        if (!this.paramName2outIndex.containsKey(columnName)) {
            throw ExceptionUtil.illegalJDBCArgumentException("invalid column name");
        }
    }

    public boolean checkLobType(int columnIndex) throws SQLException {
        this.isValidIndex(columnIndex);
        int realOutIndex = this.paramIndex2outIndex.get(columnIndex);
        FieldType type = this.outParamsDef[realOutIndex - 1].paramType;
        return FieldType.BLOB.equals((Object)type) || FieldType.CLOB.equals((Object)type) || FieldType.IMAGE.equals((Object)type);
    }

    public String getColumnName(int columnIndex) throws SQLException {
        this.isValidIndex(columnIndex);
        int realOutIndex = this.paramIndex2outIndex.get(columnIndex);
        return this.outParamsDef[realOutIndex - 1].paramName;
    }

    public GaussResultSet getOutParamResultSet() {
        return this.outParamResultSet;
    }

    public static class CallableParamDef {
        String paramName;
        FieldType paramType;
        int size;
        int paramPrecision;
        int paramScale;
        int inOutType;

        public void decodeCallableParamDef(ByteBuffer buffer) throws SQLException {
            byte[] name = new byte[68];
            buffer.get(name);
            this.paramName = BytesUtil.toString(name);
            byte[] width = new byte[2];
            buffer.get(width);
            this.inOutType = buffer.get();
            byte gsType = buffer.get();
            this.paramType = FieldType.getFieldType(gsType);
            if (this.paramType == FieldType.NUMERIC || this.paramType == FieldType.DECIMAL) {
                this.paramPrecision = width[0];
                this.paramScale = width[1];
            } else if (this.paramType == FieldType.TIMESTAMP || this.paramType == FieldType.DATE || this.paramType == FieldType.TIMESTAMP_TZ_FAKE || this.paramType == FieldType.TIMESTAMP_LTZ || this.paramType == FieldType.TIMESTAMP_TZ) {
                this.paramPrecision = width[0];
            } else {
                this.size = BytesUtil.toShort(width, buffer.order().equals(ByteOrder.BIG_ENDIAN));
            }
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public FieldType getParamType() {
            return this.paramType;
        }

        public void setParamType(FieldType paramType) {
            this.paramType = paramType;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getParamPrecision() {
            return this.paramPrecision;
        }

        public void setParamPrecision(int precision) {
            this.paramPrecision = precision;
        }

        public int getParamScale() {
            return this.paramScale;
        }

        public void setParamScale(int scale) {
            this.paramScale = scale;
        }

        public int getInOutType() {
            return this.inOutType;
        }

        public void setInOutType(int inOutType) {
            this.inOutType = inOutType;
        }
    }
}

