/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss.channel.context.statement;

import com.huawei.gauss.channel.context.statement.IntervalDS;
import com.huawei.gauss.channel.context.statement.IntervalYM;
import com.huawei.gauss.exception.ExceptionUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum FieldType {
    UNKNOWN("UNKNOWN", -1, 1111, Object.class),
    INTEGER("INTEGER", 1, 4, Integer.class),
    BOOLEAN("BOOLEAN", 17, 16, Boolean.class),
    BIGINT("BIGINT", 2, -5, Long.class),
    REAL("REAL", 3, 8, Double.class),
    NUMERIC("NUMERIC", 4, 2, BigDecimal.class),
    DECIMAL("DECIMAL", 5, 2, BigDecimal.class),
    DATE("DATE", 6, 93, Date.class),
    TIMESTAMP("TIMESTAMP", 7, 93, Timestamp.class),
    CHAR("CHAR", 8, 1, String.class),
    VARCHAR("VARCHAR", 9, 12, String.class),
    STRING("STRING", 10, 12, String.class),
    BINARY("BINARY", 11, -2, Byte[].class),
    VARBINARY("VARBINARY", 12, -3, byte[].class),
    CLOB("CLOB", 13, 2005, Clob.class),
    BLOB("BLOB", 14, 2004, Blob.class),
    TIMESTAMP_TZ_FAKE("TIMESTAMP_TZ_FAKE", 18, 93, Timestamp.class),
    TIMESTAMP_LTZ("TIMESTAMP_LTZ", 19, 93, Timestamp.class),
    TIMESTAMP_TZ("TIMESTAMP_TZ", 32, 2014, Timestamp.class),
    CURSOR("CURSOR", 15, -10, ResultSet.class),
    INTERVAL_YM("INTERVAL_YM", 21, -103, IntervalYM.class),
    INTERVAL_DS("INTERVAL_DS", 22, -104, IntervalDS.class),
    RAW("RAW", 23, -2, Byte[].class),
    IMAGE("IMAGE", 24, 2004, Blob.class),
    UINT32("INTEGER UNSIGNED", 25, 4, Long.class),
    UTC("UTC", 106, 93, Timestamp.class),
    TIME("TIME", 113, 92, Time.class),
    DATE_NOTIME("DATE_NOTIME", 114, 91, java.sql.Date.class);

    private final String name;
    private final int gaussType;
    private final int jdbcType;
    private final Class<?> jdbcClazz;
    private static final Map<Integer, FieldType> GAUSS_TYPE_INDEX;
    private static final Map<Integer, FieldType> JDBC_TYPE_INDEX;

    private FieldType(String name, int gaussTypeIn, int jdbcType, Class<?> jdbcClazz) {
        this.name = name;
        this.gaussType = gaussTypeIn;
        this.jdbcType = jdbcType;
        this.jdbcClazz = jdbcClazz;
    }

    public String getName() {
        return this.name;
    }

    public int getGaussType() {
        return this.gaussType;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getJdbcTypeName() {
        return this.jdbcClazz.getName();
    }

    public static FieldType getFieldType(int gaussType) throws SQLException {
        FieldType type = GAUSS_TYPE_INDEX.get(gaussType);
        if (type == null) {
            throw ExceptionUtil.illegalJDBCArgumentException("Illegal gaussType,value is [" + gaussType + "].");
        }
        return type;
    }

    public static FieldType getGaussTypeFromJDBCType(int jdbcType) throws SQLException {
        FieldType type = JDBC_TYPE_INDEX.get(jdbcType);
        if (type == null) {
            throw ExceptionUtil.illegalJDBCArgumentException("Illegal jdbcType,value is [" + jdbcType + "].");
        }
        return type;
    }

    static {
        GAUSS_TYPE_INDEX = new HashMap<Integer, FieldType>();
        for (FieldType type : FieldType.values()) {
            GAUSS_TYPE_INDEX.put(type.gaussType, type);
        }
        JDBC_TYPE_INDEX = new HashMap<Integer, FieldType>();
        JDBC_TYPE_INDEX.put(1111, UNKNOWN);
        JDBC_TYPE_INDEX.put(0, VARCHAR);
        JDBC_TYPE_INDEX.put(12, STRING);
        JDBC_TYPE_INDEX.put(1, CHAR);
        JDBC_TYPE_INDEX.put(2005, CLOB);
        JDBC_TYPE_INDEX.put(-1, CLOB);
        JDBC_TYPE_INDEX.put(-2, BINARY);
        JDBC_TYPE_INDEX.put(-3, VARBINARY);
        JDBC_TYPE_INDEX.put(2004, BLOB);
        JDBC_TYPE_INDEX.put(-4, BLOB);
        JDBC_TYPE_INDEX.put(16, BOOLEAN);
        JDBC_TYPE_INDEX.put(5, INTEGER);
        JDBC_TYPE_INDEX.put(-6, INTEGER);
        JDBC_TYPE_INDEX.put(4, INTEGER);
        JDBC_TYPE_INDEX.put(-5, BIGINT);
        JDBC_TYPE_INDEX.put(3, DECIMAL);
        JDBC_TYPE_INDEX.put(2, NUMERIC);
        JDBC_TYPE_INDEX.put(8, REAL);
        JDBC_TYPE_INDEX.put(6, REAL);
        JDBC_TYPE_INDEX.put(7, REAL);
        JDBC_TYPE_INDEX.put(93, TIMESTAMP);
        JDBC_TYPE_INDEX.put(91, DATE);
        JDBC_TYPE_INDEX.put(2012, CURSOR);
        JDBC_TYPE_INDEX.put(-10, CURSOR);
        JDBC_TYPE_INDEX.put(-7, INTEGER);
    }
}

